
package fr.ifremer.suiviobsmer.ui.data;

import fr.ifremer.suiviobsmer.SuiviObsmerException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.tapestry5.PropertyConduit;
import org.apache.tapestry5.grid.ColumnSort;
import org.apache.tapestry5.grid.GridDataSource;
import org.apache.tapestry5.grid.SortConstraint;
import org.apache.tapestry5.ioc.internal.util.TapestryException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * ContactDataSource
 *
 * Created: 18 janv. 2010
 *
 * @param <K> Type of the map key
 * @param <E> Type of the map value
 * @author fdesbois
 * @version $Revision: 238 $
 *
 * Mise a jour: $Date: 2010-01-19 15:57:51 +0100 (mar., 19 janv. 2010) $
 * par : $Author$
 */
public abstract class AbstractMappedGridDataSource<K, E extends TopiaEntity> implements GridDataSource {

//    @Inject
//    private ServiceContact serviceContact;

    private Logger log = LoggerFactory.getLogger(AbstractMappedGridDataSource.class);

//    private UserFilter filter;

    private Map<K, E> mapResults;

    private List<E> listResults;

    private int nbRows = -1;

    private int nbRowsPerPage;

//    public AbstractMappedGridDataSource(UserFilter filter) {
//        this.filter = filter;
//    }

    @Override
    public int getAvailableRows() {
        if (nbRows < 0) {
            try {
                nbRows = count();
                if (log.isDebugEnabled()) {
                    log.debug("Count : " + nbRows);
                }
            } catch (SuiviObsmerException eee) {
                throw new TapestryException("", eee);
            }
        }
        return nbRows;
    }

    @Override
    public void prepare(int startIndex, int endIndex, List<SortConstraint> sortConstraints) {
        if (log.isDebugEnabled()) {
            log.debug("Prepare results : " + startIndex + ", " + endIndex);
        }
        nbRowsPerPage = endIndex - startIndex + 1;
        try {
            mapResults = execute(startIndex, endIndex, getSortConstraint(sortConstraints));
            listResults = new ArrayList<E>(mapResults.values());

            // FIXME manage sort columns in execute ???? obvious
            sortResults(sortConstraints);
        } catch (SuiviObsmerException eee) {
            throw new TapestryException("", eee);
        }
    }

    protected abstract Map<K, E> execute(int startIndex, int endIndex, SortConstraint orderBy) throws SuiviObsmerException;

    protected abstract int count() throws SuiviObsmerException;

    protected SortConstraint getSortConstraint(List<SortConstraint> sortConstraints) {
        for (SortConstraint constraint : sortConstraints)
        {
            final ColumnSort sort = constraint.getColumnSort();

            if (sort != ColumnSort.UNSORTED) {
                return constraint;
            }
        }
        return null;
    }

    protected void sortResults(List<SortConstraint> sortConstraints) {

        for (SortConstraint constraint : sortConstraints)
        {
            final ColumnSort sort = constraint.getColumnSort();

            if (sort == ColumnSort.UNSORTED) continue;

            final PropertyConduit conduit = constraint.getPropertyModel().getConduit();

            final Comparator valueComparator = new Comparator<Comparable>()
            {
                public int compare(Comparable o1, Comparable o2)
                {
                    // Simplify comparison, and handle case where both are nulls.

                    if (o1 == o2) return 0;

                    if (o2 == null) return 1;

                    if (o1 == null) return -1;

                    return o1.compareTo(o2);
                }
            };

            final Comparator rowComparator = new Comparator()
            {
                public int compare(Object row1, Object row2)
                {
                    Comparable value1 = (Comparable) conduit.get(row1);
                    Comparable value2 = (Comparable) conduit.get(row2);

                    return valueComparator.compare(value1, value2);
                }
            };

            final Comparator reverseComparator = new Comparator()
            {
                public int compare(Object o1, Object o2)
                {
                    int modifier = sort == ColumnSort.ASCENDING ? 1 : -1;

                    return modifier * rowComparator.compare(o1, o2);
                }
            };

            // We can freely sort this list because its just a copy.

            Collections.sort(listResults, reverseComparator);
        }
    }

    @Override
    public Object getRowValue(int index) {
        index = index % nbRowsPerPage;
        if (index >= listResults.size()) {
            if (log.isErrorEnabled()) {
                log.error("Size error : " + index + " / " + listResults.size());
            }
            return null;
        }
        return CollectionUtils.get(listResults, index);
    }

    @Override
    public abstract Class getRowType();

    public E get(K key) {
        return mapResults.get(key);
    }

    public List<E> values() {
        return listResults;
    }

}
