/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util.matrix;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.BidiMap;
import org.apache.commons.collections4.bidimap.DualHashBidiMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.SemanticsDecorator;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;

public class EntitySemanticsDecorator
implements SemanticsDecorator<Object, String> {
    private static Log log = LogFactory.getLog(EntitySemanticsDecorator.class);
    private static final String SEP = ":";
    protected EntityProvider provider;
    protected BidiMap<String, Object> cache = new DualHashBidiMap();

    public EntitySemanticsDecorator() {
    }

    public EntitySemanticsDecorator(EntityProvider provider) {
        this.provider = provider;
    }

    public Collection<Object> getDecoratedObject() {
        Set result = this.cache.values();
        return result;
    }

    public Object decorate(String internalValue) {
        Object result = this.cache.get((Object)internalValue);
        if (result == null && internalValue != null) {
            internalValue = internalValue.intern();
            result = internalValue;
            if (StringUtils.startsWith((CharSequence)internalValue, (CharSequence)"Month")) {
                String val = StringUtils.substringAfter((String)internalValue, (String)SEP);
                int monthNumber = Integer.parseInt(val);
                result = Month.MONTH[monthNumber];
            } else if (StringUtils.startsWith((CharSequence)internalValue, (CharSequence)"TimeStep")) {
                String val = StringUtils.substringAfter((String)internalValue, (String)SEP);
                int stepNumber = Integer.parseInt(val);
                result = new TimeStep(stepNumber);
            } else if (StringUtils.startsWith((CharSequence)internalValue, (CharSequence)"fr.ifremer.isisfish.entities.")) {
                if (this.provider == null) {
                    result = StringUtils.substringAfter((String)internalValue, (String)SEP);
                } else {
                    try {
                        String id = StringUtils.substringBefore((String)internalValue, (String)SEP);
                        result = this.provider.findById(id);
                    }
                    catch (Exception eee) {
                        log.info((Object)("Fallback use string representation because i can't decorate (String->Entity): " + internalValue), (Throwable)eee);
                    }
                }
            }
            this.cache.put((Object)internalValue, result);
        }
        return result;
    }

    public String undecorate(Object decoratedValue) {
        if (decoratedValue instanceof String) {
            return (String)decoratedValue;
        }
        Object result = (String)this.cache.getKey(decoratedValue);
        if (result == null && decoratedValue != null) {
            result = decoratedValue instanceof Month ? "Month:" + ((Month)decoratedValue).getMonthNumber() : (decoratedValue instanceof TimeStep ? "TimeStep:" + ((TimeStep)decoratedValue).getStep() : (decoratedValue instanceof TopiaEntity ? ((TopiaEntity)decoratedValue).getTopiaId() + SEP + String.valueOf(decoratedValue) : String.valueOf(decoratedValue)));
            result = ((String)result).intern();
            this.cache.put(result, decoratedValue);
        }
        return result;
    }

    public static interface EntityProvider {
        public Object findById(String var1);
    }

    public static class EntityMapProvider
    implements EntityProvider {
        protected Map<String, TopiaEntity> map;

        public EntityMapProvider(Map<String, TopiaEntity> map) {
            this.map = map;
        }

        @Override
        public Object findById(String id) {
            TopiaEntity result = this.map.get(id);
            if (result == null) {
                throw new IsisFishRuntimeException("Can't find entity in map: " + id);
            }
            return result;
        }
    }

    public static class EntityTxProvider
    implements EntityProvider {
        protected TopiaContext tx;

        public EntityTxProvider(TopiaContext tx) {
            this.tx = tx;
        }

        @Override
        public Object findById(String id) {
            TopiaEntity result = this.tx.findByTopiaId(id);
            return result;
        }
    }
}

