/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.population;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.PopulationSeasonInfoDAO;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.input.population.PopulationSeasonsUI;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import fr.ifremer.isisfish.ui.widget.interval.Interval;
import fr.ifremer.isisfish.util.ErrorHelper;
import fr.ifremer.isisfish.util.IsisUtil;
import java.beans.PropertyChangeEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;

public class PopulationSeasonsHandler
extends InputContentHandler<PopulationSeasonsUI> {
    private static final Log log = LogFactory.getLog(PopulationSeasonsHandler.class);
    protected Interval seasonInterval;
    protected boolean init = false;

    protected PopulationSeasonsHandler(PopulationSeasonsUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        ((PopulationSeasonsUI)this.inputContentUI).addPropertyChangeListener("bean", evt -> {
            if (evt.getNewValue() == null) {
                ((PopulationSeasonsUI)this.inputContentUI).fieldPopulationSeasonComment.setText("");
                ((PopulationSeasonsUI)this.inputContentUI).fieldPopulationSeasonReproductionDistribution.setMatrix(null);
            }
            if (evt.getNewValue() != null) {
                this.refresh();
            }
        });
        ((PopulationSeasonsUI)this.inputContentUI).seasonIntervalPanel.addPropertyChangeListener("first", evt -> {
            if (((PopulationSeasonsUI)this.inputContentUI).getPopulationSeasonInfo() != null) {
                ((PopulationSeasonsUI)this.inputContentUI).getPopulationSeasonInfo().setFirstMonth(new Month(this.seasonInterval.getFirst()));
                this.setReproductionDistributionMatrix();
            }
            this.updateSeasonOverlapIcon(evt);
        });
        ((PopulationSeasonsUI)this.inputContentUI).seasonIntervalPanel.addPropertyChangeListener("last", evt -> {
            if (((PopulationSeasonsUI)this.inputContentUI).getPopulationSeasonInfo() != null) {
                ((PopulationSeasonsUI)this.inputContentUI).getPopulationSeasonInfo().setLastMonth(new Month(this.seasonInterval.getLast()));
                this.setReproductionDistributionMatrix();
            }
            this.updateSeasonOverlapIcon(evt);
        });
        ((PopulationSeasonsUI)this.inputContentUI).addPropertyChangeListener("bean", this::updateSeasonOverlapIcon);
    }

    protected void updateSeasonOverlapIcon(PropertyChangeEvent evt) {
        boolean visible = false;
        if (((PopulationSeasonsUI)this.inputContentUI).getBean() != null) {
            visible = IsisUtil.isSeasonOverlap(((PopulationSeasonsUI)this.inputContentUI).getBean().getPopulationSeasonInfo());
        }
        ((PopulationSeasonsUI)this.inputContentUI).overlapSeasonLabel.setVisible(visible);
    }

    protected void create() {
        PopulationSeasonInfo seasonNew = this.createPopulationSeasonInfo(((PopulationSeasonsUI)this.inputContentUI).getBean());
        ((PopulationSeasonsUI)this.inputContentUI).setPopulationSeasonInfo(seasonNew);
        this.setPopulationSeasonInfoCombo();
    }

    protected void delete() {
        this.removePopulationSeasonInfo(((PopulationSeasonsUI)this.inputContentUI).getBean(), ((PopulationSeasonsUI)this.inputContentUI).getPopulationSeasonInfo());
        ((PopulationSeasonsUI)this.inputContentUI).setPopulationSeasonInfo(null);
        this.setPopulationSeasonInfoCombo();
    }

    protected PopulationSeasonInfo createPopulationSeasonInfo(Population pop) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"createSeasonInfo called");
        }
        PopulationSeasonInfo seasonInfo = null;
        try {
            PopulationSeasonInfoDAO dao = IsisFishDAOHelper.getPopulationSeasonInfoDAO(pop.getTopiaContext());
            seasonInfo = (PopulationSeasonInfo)dao.create(new Object[0]);
            seasonInfo.setFirstMonth(Month.MONTH[0]);
            seasonInfo.setLastMonth(Month.MONTH[3]);
            pop.addPopulationSeasonInfo(seasonInfo);
            seasonInfo.setPopulation(pop);
            seasonInfo.update();
            pop.update();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't create PopulationSeasonInfo", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.createentity", (Object[])new Object[]{"PopulationSeasonInfo"}), eee);
        }
        return seasonInfo;
    }

    protected void removePopulationSeasonInfo(Population pop, PopulationSeasonInfo populationSeasonInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"removePopulationSeasonInfo called");
        }
        try {
            pop.removePopulationSeasonInfo(populationSeasonInfo);
            pop.update();
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't remove PopulationSeasonInfo", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.removeentity", (Object[])new Object[]{"PopulationSeasonInfo"}), eee);
        }
    }

    protected void save() {
        ((PopulationSeasonsUI)this.inputContentUI).getSaveVerifier().save();
        this.setPopulationSeasonInfoCombo();
    }

    protected void populationSeasonReproductionDistributionMatrixChanged(MatrixPanelEvent event) {
        if (((PopulationSeasonsUI)this.inputContentUI).getPopulationSeasonInfo() != null && ((PopulationSeasonsUI)this.inputContentUI).fieldPopulationSeasonReproductionDistribution.getMatrix() != null) {
            MatrixND reproductionDistribution = ((PopulationSeasonsUI)this.inputContentUI).fieldPopulationSeasonReproductionDistribution.getMatrix().copy();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Matrix ReproductionDistribution modified : " + String.valueOf(reproductionDistribution)));
            }
            ((PopulationSeasonsUI)this.inputContentUI).getPopulationSeasonInfo().setReproductionDistribution(reproductionDistribution);
        }
    }

    public void refresh() {
        ((PopulationSeasonsUI)this.inputContentUI).setPopulationSeasonInfo(null);
        this.seasonInterval = new Interval();
        this.seasonInterval.setMin(0);
        this.seasonInterval.setMax(11);
        this.seasonInterval.setFirst(0);
        this.seasonInterval.setLast(2);
        this.setPopulationSeasonInfoCombo();
        this.setSeasonInterval();
        ((PopulationSeasonsUI)this.inputContentUI).seasonIntervalPanel.setLabelRenderer(Month.MONTH);
        ((PopulationSeasonsUI)this.inputContentUI).seasonIntervalPanel.setModel(this.seasonInterval);
    }

    protected void setSeasonInterval() {
        block10: {
            if (((PopulationSeasonsUI)this.inputContentUI).getPopulationSeasonInfo() != null) {
                try {
                    Month lastMonth;
                    Month firstMonth;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Updating interval : ");
                    }
                    if ((firstMonth = ((PopulationSeasonsUI)this.inputContentUI).getPopulationSeasonInfo().getFirstMonth()) != null) {
                        this.seasonInterval.setFirst(firstMonth.getMonthNumber());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(" first : " + this.seasonInterval.getFirst()));
                        }
                    } else {
                        this.seasonInterval.setFirst(0);
                    }
                    if ((lastMonth = ((PopulationSeasonsUI)this.inputContentUI).getPopulationSeasonInfo().getLastMonth()) != null) {
                        this.seasonInterval.setLast(lastMonth.getMonthNumber());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)(" last : " + this.seasonInterval.getLast()));
                        }
                    } else {
                        this.seasonInterval.setLast(3);
                    }
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) break block10;
                    log.error((Object)"Can't display interval", (Throwable)e);
                }
            }
        }
    }

    protected void setPopulationSeasonInfoCombo() {
        if (((PopulationSeasonsUI)this.inputContentUI).getBean() != null) {
            GenericComboModel<PopulationSeasonInfo> populationSeasonInfoModel = new GenericComboModel<PopulationSeasonInfo>(((PopulationSeasonsUI)this.inputContentUI).getBean().getPopulationSeasonInfo());
            ((PopulationSeasonsUI)this.inputContentUI).fieldPopulationSeasonInfoChooser.setModel(populationSeasonInfoModel);
            populationSeasonInfoModel.setSelectedItem(((PopulationSeasonsUI)this.inputContentUI).getPopulationSeasonInfo());
        }
    }

    protected void seasonGroupChanged() {
        if (((PopulationSeasonsUI)this.inputContentUI).getPopulationSeasonInfo() != null) {
            ((PopulationSeasonsUI)this.inputContentUI).getPopulationSeasonInfo().setGroupChange(((PopulationSeasonsUI)this.inputContentUI).fieldPopulationSeasonGroupChange.isSelected());
        }
    }

    protected void seasonChanged() {
        this.init = true;
        PopulationSeasonInfo seasonInfoSelected = (PopulationSeasonInfo)((PopulationSeasonsUI)this.inputContentUI).fieldPopulationSeasonInfoChooser.getSelectedItem();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Season changed : " + String.valueOf(seasonInfoSelected)));
        }
        ((PopulationSeasonsUI)this.inputContentUI).setPopulationSeasonInfo(seasonInfoSelected);
        if (seasonInfoSelected != null) {
            ((PopulationSeasonsUI)this.inputContentUI).getSaveVerifier().addCurrentEntity(seasonInfoSelected);
        }
        this.setSeasonInterval();
        this.setReproductionDistributionMatrix();
        this.init = false;
    }

    protected void setReproductionDistributionMatrix() {
        MatrixND reproductionDistribution;
        if (((PopulationSeasonsUI)this.inputContentUI).getPopulationSeasonInfo() != null && (reproductionDistribution = ((PopulationSeasonsUI)this.inputContentUI).getPopulationSeasonInfo().getReproductionDistribution()) != null) {
            ((PopulationSeasonsUI)this.inputContentUI).fieldPopulationSeasonReproductionDistribution.setMatrix(reproductionDistribution.copy());
        }
    }

    protected boolean isAgeGroupType(boolean result) {
        ((PopulationSeasonsUI)this.inputContentUI).populationSeasonSpecializedUI.setVisible(result);
        return result;
    }
}

