/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.StorageException;
import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.EquationDAO;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.entities.StrategyAbstract;
import fr.ifremer.isisfish.entities.StrategyEquationType;
import fr.ifremer.isisfish.entities.StrategyMonthInfo;
import fr.ifremer.isisfish.entities.StrategyMonthInfoDAO;
import fr.ifremer.isisfish.entities.StrategyMonthInfoImpl;
import fr.ifremer.isisfish.equation.StrategyEffortEquation;
import fr.ifremer.isisfish.equation.StrategyInactivityEquation;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.util.EvaluatorHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;

public class StrategyImpl
extends StrategyAbstract {
    private static Log log = LogFactory.getLog(StrategyImpl.class);
    private static final long serialVersionUID = 1L;

    @Override
    public FisheryRegion getFisheryRegion() {
        try {
            FisheryRegion result = RegionStorage.getFisheryRegion(this.getTopiaContext());
            return result;
        }
        catch (StorageException eee) {
            throw new IsisFishRuntimeException("Can't get fishery region", eee);
        }
    }

    @Override
    public void setName(String value) {
        super.setName(value);
        Equation eq = this.getInactivityEquation();
        if (eq != null) {
            eq.setName(this.getName());
        }
    }

    @Override
    public void setInactivityEquation(Equation inactivityEquation) {
        super.setInactivityEquation(inactivityEquation);
        this.computeNumberOfTrips();
    }

    @Override
    public List<StrategyMonthInfo> getStrategyMonthInfo() {
        try {
            List<StrategyMonthInfo> result = super.getStrategyMonthInfo();
            if (result == null || result.size() != Month.NUMBER_OF_MONTH) {
                if (result != null) {
                    log.warn((Object)I18n.t((String)"isisfish.error.strategy.order", (Object[])new Object[]{this.getName(), result.size()}));
                    this.clearStrategyMonthInfo();
                } else {
                    result = new ArrayList<StrategyMonthInfo>(Month.NUMBER_OF_MONTH);
                    this.setStrategyMonthInfo(result);
                }
                for (Month month : Month.MONTH) {
                    StrategyMonthInfoDAO dao = IsisFishDAOHelper.getStrategyMonthInfoDAO(this.getTopiaContext());
                    StrategyMonthInfo smi = (StrategyMonthInfo)dao.create(new Object[0]);
                    smi.setMonth(month);
                    smi.setStrategy(this);
                    smi.update();
                    this.addStrategyMonthInfo(smi);
                }
                this.update();
                result = super.getStrategyMonthInfo();
            }
            return result;
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException("Can't create StrategyMonthInfo", eee);
        }
    }

    @Override
    public StrategyMonthInfo getStrategyMonthInfo(Month month) {
        List<StrategyMonthInfo> smis = this.getStrategyMonthInfo();
        StrategyMonthInfo result = smis.get(month.getMonthNumber());
        if (!month.equals(result.getMonth())) {
            log.warn((Object)"StrategyMonthInfo not in month order, i take time to find good StrategyMonthInfo");
            result = null;
            for (StrategyMonthInfo smi : smis) {
                if (!month.equals(smi.getMonth())) continue;
                result = smi;
                break;
            }
        }
        return result;
    }

    @Override
    public double getInactivityDays(Month month) {
        double result = 0.0;
        StrategyMonthInfo info = this.getStrategyMonthInfo(month);
        if (this.isInactivityEquationUsed()) {
            try {
                Equation eq = this.getInactivityEquation();
                result = eq.evaluate("month", month, "info", info);
            }
            catch (Exception ex) {
                EvaluatorHelper.catchEvaluateException(ex, log);
            }
        } else {
            result = info.getMinInactivityDays();
        }
        return result;
    }

    @Override
    public double getEffortNominalPerVessel(Month month) {
        double result = 0.0;
        StrategyMonthInfo info = this.getStrategyMonthInfo(month);
        if (this.isEffortEquationUsed()) {
            try {
                Equation eq = this.getEffortEquation();
                result = eq.evaluate("month", month, "info", info);
            }
            catch (Exception ex) {
                EvaluatorHelper.catchEvaluateException(ex, log);
            }
        } else {
            throw new IllegalStateException("Strategy %s is not configured to use effort equation.".formatted(this.name));
        }
        return result;
    }

    @Override
    public boolean isInactivityEquationUsed() {
        return this.getEquationTypeUsed() == StrategyEquationType.INACTIVITY;
    }

    @Override
    public boolean isEffortEquationUsed() {
        return this.getEquationTypeUsed() == StrategyEquationType.EFFORT;
    }

    protected void computeNumberOfTrips() {
        if (this.getTopiaContext() != null && this.getStrategyMonthInfo() != null) {
            this.getStrategyMonthInfo().stream().map(StrategyMonthInfoImpl.class::cast).forEach(StrategyMonthInfoImpl::computeNumberOfTrips);
        }
    }

    public void setInactivityEquationContent(String content) {
        try {
            Equation eq = this.getInactivityEquation();
            if (eq == null) {
                EquationDAO dao = IsisFishDAOHelper.getEquationDAO(this.getTopiaContext());
                eq = (Equation)dao.create(new Object[0]);
                eq.setCategory("Inactivity");
                eq.setJavaInterface(StrategyInactivityEquation.class);
                eq.setLanguage("java");
                this.setInactivityEquation(eq);
            }
            eq.setName(this.getName());
            String _oldValue = eq.getContent();
            this.fireOnPreWrite("content", _oldValue, content);
            eq.setContent(content);
            eq.update();
            this.computeNumberOfTrips();
            this.fireOnPostWrite("content", _oldValue, content);
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.change.equation", (Object[])new Object[0]), eee);
        }
    }

    public void setEffortEquationContent(String content) {
        try {
            Equation eq = this.getEffortEquation();
            if (eq == null) {
                EquationDAO dao = IsisFishDAOHelper.getEquationDAO(this.getTopiaContext());
                eq = (Equation)dao.create(new Object[0]);
                eq.setCategory("Effort");
                eq.setJavaInterface(StrategyEffortEquation.class);
                eq.setLanguage("java");
                this.setEffortEquation(eq);
            }
            eq.setName(this.getName());
            String _oldValue = eq.getContent();
            this.fireOnPreWrite("content", _oldValue, content);
            eq.setContent(content);
            eq.update();
            this.fireOnPostWrite("content", _oldValue, content);
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.change.equation", (Object[])new Object[0]), eee);
        }
    }

    @Override
    public MatrixND getProportionMetier() {
        if (this.getSetOfVessels() == null || this.getSetOfVessels().getPossibleMetiers() == null) {
            return null;
        }
        Collection<EffortDescription> efforts = this.getSetOfVessels().getPossibleMetiers();
        ArrayList<Metier> metiers = new ArrayList<Metier>(efforts.size());
        for (EffortDescription effort : efforts) {
            metiers.add(effort.getPossibleMetiers());
        }
        List<Month> months = Arrays.asList(Month.MONTH);
        MatrixND result = MatrixFactory.getInstance().create(I18n.t((String)"isisfish.strategy.proportionMetier", (Object[])new Object[0]), new List[]{metiers, months}, new String[]{I18n.t((String)"isisfish.strategyMonthInfo.metier", (Object[])new Object[0]), I18n.t((String)"isisfish.common.months", (Object[])new Object[0])});
        if (this.getStrategyMonthInfo() != null) {
            for (StrategyMonthInfo smi : this.getStrategyMonthInfo()) {
                if (smi.getProportionMetier() == null) continue;
                MatrixND mat = smi.getProportionMetier();
                for (Metier metier : metiers) {
                    double value = mat.getValue((Object)metier);
                    result.setValue((Object)metier, (Object)smi.getMonth(), value);
                }
            }
        }
        return result;
    }

    @Override
    public void setProportionMetier(MatrixND strategyProportionMetier) {
        if (this.getSetOfVessels() == null || this.getSetOfVessels().getPossibleMetiers() == null) {
            return;
        }
        List months = strategyProportionMetier.getSemantic(1);
        for (Month month : months) {
            MatrixND proportionMetier = strategyProportionMetier.getSubMatrix(1, new Object[]{month}).reduce();
            StrategyMonthInfo smi = this.getStrategyMonthInfo(month);
            smi.setProportionMetier(proportionMetier);
        }
    }

    @Override
    public String toString() {
        String result = this.getName();
        return result;
    }
}

