/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.simulator;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.datastore.StorageChangeEvent;
import fr.ifremer.isisfish.datastore.StorageChangeListener;
import fr.ifremer.isisfish.datastore.StorageException;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.mexico.MexicoHelper;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.launcher.SimulationJob;
import fr.ifremer.isisfish.simulator.launcher.SimulationService;
import fr.ifremer.isisfish.simulator.launcher.SimulationServiceListener;
import fr.ifremer.isisfish.simulator.launcher.SimulatorLauncher;
import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityAnalysis;
import fr.ifremer.isisfish.ui.SimulationUI;
import fr.ifremer.isisfish.ui.WelcomePanelUI;
import fr.ifremer.isisfish.ui.WelcomeTabUI;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityUI;
import fr.ifremer.isisfish.ui.sensitivity.wizard.FactorWizardHandler;
import fr.ifremer.isisfish.ui.sensitivity.wizard.FactorWizardUI;
import fr.ifremer.isisfish.ui.simulator.ParamsUI;
import fr.ifremer.isisfish.ui.simulator.RuleChooser;
import fr.ifremer.isisfish.ui.simulator.SimulatorContext;
import fr.ifremer.isisfish.ui.simulator.SimulatorTabHandler;
import fr.ifremer.isisfish.util.ErrorHelper;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ParamsHandler
extends SimulatorTabHandler {
    private static final Log log = LogFactory.getLog(ParamsHandler.class);
    private static final SimpleDateFormat DATEFORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm");
    protected ParamsUI tabUI;
    protected SimulationServiceListener simulationListener;
    protected StorageChangeListener regionStorageListener;
    protected List<String> oldSimulNames = null;
    protected String simulationName;

    protected ParamsHandler(ParamsUI tabUI) {
        super(tabUI);
        this.tabUI = tabUI;
    }

    protected void initRegionComboModel(StorageChangeEvent evt) {
        SwingUtilities.invokeLater(() -> this.tabUI.simulParamsRegionModel.setElementList(RegionStorage.getRegionNames()));
    }

    protected void afterInit() {
        this.regionStorageListener = this::initRegionComboModel;
        RegionStorage.addStorageListener(this.regionStorageListener);
        this.initRegionComboModel(null);
        this.simulationListener = new SimulationServiceListener(){

            @Override
            public void simulationStart(SimulationService simService, SimulationJob job) {
            }

            @Override
            public void simulationStop(SimulationService simService, SimulationJob job) {
                GenericComboModel model = (GenericComboModel)ParamsHandler.this.tabUI.fieldSimulParamsSelect.getModel();
                SwingUtilities.invokeLater(() -> model.addElement(job.getId()));
            }

            @Override
            public void clearJobDone(SimulationService simService) {
            }
        };
        SimulationService.getService().addSimulationServiceListener(this.simulationListener);
    }

    public void setSimulationName(String simulationName) {
        this.simulationName = simulationName;
    }

    public void refresh() {
        this.tabUI.fieldSimulParamsDesc.setText(this.getParameters().getDescription());
        this.tabUI.fieldSimulParamsRegion.setSelectedItem(this.getParameters().getRegionName());
        SwingUtilities.invokeLater(() -> {
            this.setListSimulParamsStrategiesItems();
            this.setListSimulParamsPopulationsItems();
        });
    }

    protected void regionChange(ItemEvent event) {
        String selected;
        if (event.getStateChange() == 1 && StringUtils.isNotBlank((CharSequence)(selected = (String)this.tabUI.fieldSimulParamsRegion.getSelectedItem()))) {
            this.tabUI.getParentContainer(WelcomePanelUI.class).setStatusMessage(I18n.t((String)"isisfish.message.loading.region", (Object[])new Object[0]));
            SwingUtilities.invokeLater(() -> {
                this.regionChange(selected);
                this.tabUI.getParentContainer(SimulationUI.class).refresh();
                this.setSensitivityTabRegion();
                this.tabUI.getParentContainer(WelcomePanelUI.class).setStatusMessage(I18n.t((String)"isisfish.message.region.loaded", (Object[])new Object[0]));
            });
        }
    }

    public void regionChange(String regionName) {
        RegionStorage regionStorage = RegionStorage.getRegion(regionName);
        this.tabUI.getParentContainer(SimulationUI.class).setContextValue(regionStorage);
        this.tabUI.getParentContainer(SimulationUI.class).setRegionStorage(regionStorage);
        SimulatorContext.setDb(regionStorage.getStorage().beginTransaction());
        this.getParameters().setRegionName(regionName);
        this.getParameters().reloadRegionChangeParameter();
    }

    public boolean loadOldSimulation(String simulName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("call loadOldSimulation: " + simulName));
        }
        try {
            SimulatorContext context = this.tabUI.getContextValue(SimulatorContext.class, "SimulatorContext");
            SimulationStorage simulStorage = SimulationStorage.getSimulation(simulName);
            this.tabUI.getFieldSimulParamsName().setText(simulStorage.getName());
            SimulationParameter param = simulStorage.getParameter().copy();
            param.fixReloadContext(this.tabUI.isSensitivity());
            param.setSimulationPlanNumber(-1);
            context.setSimulationParameter(param);
            RegionStorage regionStorage = param.getRegion();
            if (regionStorage == null) {
                JOptionPane.showMessageDialog((Component)((Object)this.tabUI), I18n.t((String)"isisfish.error.simulation.loadoldsimulation.regionnotfound", (Object[])new Object[]{param.getRegionName()}), I18n.t((String)"isisfish.common.error", (Object[])new Object[0]), 0);
                return false;
            }
            context.setRegionStorage(regionStorage);
            this.getFactorGroup().clearFactors();
            File f = SimulationStorage.getMexicoDesignPlan(SimulationStorage.getSimulationDirectory(simulName));
            if (f != null && f.canRead()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Import design plan from : " + f.getAbsolutePath()));
                }
                TopiaContext topiaContext = regionStorage.getStorage();
                DesignPlan designPlan = MexicoHelper.getDesignPlanFromXML(f, topiaContext);
                for (Factor factor : designPlan.getFactors()) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Find factor : " + factor.getName()));
                    }
                    FactorGroup factorGroup = designPlan.getFactorGroup();
                    context.setFactorGroup(factorGroup);
                }
            } else if (log.isInfoEnabled()) {
                log.info((Object)"No xml design plan file found");
            }
        }
        catch (Exception eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.simulation.loadoldsimulation", (Object[])new Object[0]), eee);
        }
        return true;
    }

    public SimulatorLauncher[] getSimulationLauncher() {
        return SimulationService.getService().getSimulationLaunchers().toArray(new SimulatorLauncher[0]);
    }

    protected void setSensitivityTabRegion() {
        block3: {
            if (this.tabUI.isSensitivity().booleanValue()) {
                try {
                    TopiaContext tx = this.tabUI.getContextValue(RegionStorage.class).getStorage().beginTransaction();
                    FisheryRegion fisheryRegion = RegionStorage.getFisheryRegion(tx);
                    this.tabUI.getParentContainer(SensitivityUI.class).getSensitivityInputUI().setFisheryRegion(fisheryRegion);
                    this.tabUI.getParentContainer(SensitivityUI.class).getSensitivityInputUI().getHandler().setTreeModel();
                }
                catch (StorageException | TopiaException ex) {
                    if (!log.isErrorEnabled()) break block3;
                    log.error((Object)"Can't reload factors", ex);
                }
            }
        }
    }

    protected void initSensitivityParams() {
        if (this.tabUI.isSensitivity().booleanValue()) {
            this.tabUI.getParentContainer(SensitivityUI.class).getSensitivityChooserUI().getHandler().refreshSelectedSensitivityAnalysis();
            this.tabUI.getParentContainer(SensitivityUI.class).getSensitivityInputUI().getHandler().setFactorModel();
            this.tabUI.getParentContainer(SensitivityUI.class).getSensitivityChooserUI().getHandler().setSensitivityExportListModel();
        }
    }

    protected void loadOldSimulation() {
        String selected = this.tabUI.fieldSimulParamsSelect.getSelectedItem().toString();
        if (selected != null && !selected.equals(" ")) {
            this.tabUI.getParentContainer(WelcomePanelUI.class).setStatusMessage(I18n.t((String)"isisfish.message.loading.old.simulation", (Object[])new Object[0]));
            this.tabUI.setCursor(Cursor.getPredefinedCursor(3));
            SwingUtilities.invokeLater(() -> {
                boolean loaded = this.loadOldSimulation(selected);
                if (loaded) {
                    this.tabUI.fieldSimulParamsRegion.setSelectedItem(this.getParameters().getRegionName());
                    this.tabUI.getParentContainer(SimulationUI.class).refresh();
                    this.tabUI.fieldSimulParamsNbMois.setText(String.valueOf(this.getNumberOfMonths()));
                    this.initSensitivityParams();
                    this.tabUI.getParentContainer(WelcomePanelUI.class).setStatusMessage(I18n.t((String)"isisfish.message.old.simulation.loaded", (Object[])new Object[0]));
                }
                this.tabUI.setCursor(Cursor.getDefaultCursor());
            });
        }
    }

    protected void launchSimulation() {
        if (!this.tabUI.isSensitivity().booleanValue()) {
            this.launchSimulation(this.tabUI.fieldSimulParamsName.getText(), (SimulatorLauncher)this.tabUI.comboSelLauncher.getSelectedItem());
        } else {
            this.launchSimulationWithSensibility(this.tabUI.fieldSimulParamsName.getText(), (SimulatorLauncher)this.tabUI.comboSelLauncher.getSelectedItem());
        }
        WelcomeTabUI parent = this.tabUI.getParentContainer(WelcomeTabUI.class);
        if (parent != null) {
            parent.setQueueTabSelection();
        }
    }

    public void launchSimulationWithSensibility(String simulationId, SimulatorLauncher launcher) {
        String fullSimulationId = "as_" + simulationId + "_" + DATEFORMAT.format(new Date());
        SensitivityAnalysis sensitivityAnalysis = this.getParameters().getSensitivityAnalysis();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Launch factor simulation with custom launcher " + launcher.toString()));
            log.debug((Object)("Using sensitivityCalculator : " + sensitivityAnalysis.getDescription()));
        }
        try {
            if (this.checkAndPrepare(fullSimulationId)) {
                DesignPlan designPlan = new DesignPlan();
                designPlan.setFactorGroup(this.getFactorGroup());
                SimulationService.getService().submit(fullSimulationId, this.getParameters(), launcher, 0, sensitivityAnalysis, designPlan);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't start simulation", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.simulation.launchsimulation", (Object[])new Object[0]), eee);
        }
    }

    protected boolean checkAndPrepare(String fullSimulationId) {
        boolean result;
        boolean bl = result = !"".equals(fullSimulationId) && !SimulationStorage.localyExists(fullSimulationId) && !SimulationService.getService().exists(fullSimulationId);
        if (result) {
            HashMap<String, String> m = new HashMap<String, String>(IsisFish.config.getDefaultSimulationConfig());
            Map<String, String> tv = this.getParameters().getTagValue();
            m.putAll(tv);
            this.getParameters().setTagValue(m);
        } else {
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.simulator.simulaction.badid", (Object[])new Object[]{fullSimulationId}), null);
        }
        return result;
    }

    public void launchSimulation(String simulationId, SimulatorLauncher launcher) {
        String fullSimulationId = "sim_" + simulationId + "_" + DATEFORMAT.format(new Date());
        if (log.isDebugEnabled()) {
            log.debug((Object)("Launch simulation with custom launcher " + launcher.toString()));
        }
        try {
            if (this.checkAndPrepare(fullSimulationId)) {
                SimulationService.getService().submit(fullSimulationId, this.getParameters(), launcher, 0);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't start simulation", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.simulation.launchsimulation", (Object[])new Object[0]), eee);
        }
    }

    public void populationSelected() {
        CardLayout layout = (CardLayout)this.tabUI.getPopulationEffectivesPanel().getLayout();
        List<Population> selectedPopulationsValues = this.tabUI.getListSimulParamsPopulations().getSelectedValuesList();
        if (CollectionUtils.isNotEmpty(selectedPopulationsValues)) {
            this.tabUI.getPopulationEffectivesTabbedPane().removeAll();
            this.setPopulations(selectedPopulationsValues);
            for (Population selectedPopulation : selectedPopulationsValues) {
                final MatrixPanelEditor matrixPanel = new MatrixPanelEditor();
                final String populationName = selectedPopulation.getName();
                MatrixND populationEffectives = this.getParameters().getNumberOf(selectedPopulation);
                matrixPanel.setMatrix(populationEffectives);
                JPanel matrixPanelComponent = new JPanel(new BorderLayout());
                matrixPanelComponent.add((Component)matrixPanel, "Center");
                if (this.tabUI.isSensitivity().booleanValue()) {
                    matrixPanel.putClientProperty((Object)"sensitivityPopulation", (Object)selectedPopulation);
                    JButton addFactorButton = new JButton();
                    addFactorButton.setAction(new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            ParamsHandler.this.addFactorWithComponent((JComponent)matrixPanel);
                        }

                        @Override
                        public Object getValue(String key) {
                            Object result = null;
                            if (key.equals("SmallIcon")) {
                                result = SwingUtil.createImageIcon((String)"fatcow/brick_add.png");
                            } else if (key.equals("ShortDescription")) {
                                result = I18n.t((String)"isisfish.params.populationEffectives.factorTooltip", (Object[])new Object[]{populationName});
                            }
                            return result;
                        }
                    });
                    matrixPanelComponent.add((Component)addFactorButton, "East");
                }
                this.tabUI.getPopulationEffectivesTabbedPane().add((Component)matrixPanelComponent, I18n.t((String)"isisfish.params.populationEffectives", (Object[])new Object[]{populationName}));
            }
            layout.show(this.tabUI.getPopulationEffectivesPanel(), "specific");
        } else {
            layout.show(this.tabUI.getPopulationEffectivesPanel(), "default");
        }
    }

    public void addFactorWithComponent(JComponent source) {
        Population population;
        String factorPath;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Event intercepted on " + String.valueOf(source)));
        }
        Factor selectedFactor = null;
        if (source instanceof RuleChooser) {
            String factorPath2 = "parameters.rules";
            selectedFactor = this.getFactor(factorPath2);
            if (selectedFactor == null) {
                selectedFactor = new Factor(I18n.t((String)"isisfish.sensitivity.rulesfactorname", (Object[])new Object[0]));
                selectedFactor.setPath(factorPath2);
            }
        } else if (source instanceof MatrixPanelEditor && (selectedFactor = this.getFactor(factorPath = "parameters.population." + (population = (Population)source.getClientProperty("sensitivityPopulation")).getName() + ".number")) == null) {
            selectedFactor = new Factor(I18n.t((String)"isisfish.sensitivity.populationfactorname", (Object[])new Object[]{population.getName()}));
            selectedFactor.setPath(factorPath);
        }
        if (selectedFactor != null) {
            FactorWizardUI wizard = new FactorWizardUI((JAXXContext)this.tabUI);
            FactorWizardHandler handler = wizard.getHandler();
            handler.initExistingFactor(wizard, selectedFactor);
            wizard.pack();
            wizard.setLocationRelativeTo((Component)((Object)this.tabUI));
            wizard.setVisible(true);
        }
    }

    public Factor getFactor(String factorPath) {
        return this.getFactor(this.getFactorGroup(), factorPath);
    }

    protected Factor getFactor(FactorGroup factorGroup, String factorPath) {
        Factor result = null;
        for (Factor factor : factorGroup.getFactors()) {
            if (factor instanceof FactorGroup) {
                result = this.getFactor((FactorGroup)factor, factorPath);
            }
            if (!factorPath.equals(factor.getPath())) continue;
            result = factor;
        }
        return result;
    }

    protected void setListSimulParamsStrategiesItems() {
        List<Strategy> strategiesSelected = this.getParameters().getStrategies();
        DefaultListModel<Strategy> listSimulParamsStrategiesModel = new DefaultListModel<Strategy>();
        List<Strategy> strategies = this.getStrategies();
        for (Strategy s : strategies) {
            listSimulParamsStrategiesModel.addElement(s);
        }
        this.tabUI.listSimulParamsStrategies.setModel(listSimulParamsStrategiesModel);
        if (listSimulParamsStrategiesModel.size() != 0) {
            for (Strategy s : strategiesSelected) {
                int index = listSimulParamsStrategiesModel.indexOf(s);
                this.tabUI.listSimulParamsStrategies.addSelectionInterval(index, index);
            }
        }
    }

    protected void setListSimulParamsPopulationsItems() {
        List<Population> populationsSelected = this.getParameters().getPopulations();
        DefaultListModel<Population> listSimulParamsPopulationsModel = new DefaultListModel<Population>();
        List<Population> populations = this.getPopulations();
        for (Population p : populations) {
            listSimulParamsPopulationsModel.addElement(p);
        }
        this.tabUI.listSimulParamsPopulations.setModel(listSimulParamsPopulationsModel);
        if (listSimulParamsPopulationsModel.size() != 0) {
            for (Population p : populationsSelected) {
                int index = listSimulParamsPopulationsModel.indexOf(p);
                this.tabUI.listSimulParamsPopulations.addSelectionInterval(index, index);
            }
        }
    }

    protected void strategySelected() {
        this.setStrategies(this.tabUI.listSimulParamsStrategies.getSelectedValuesList());
    }

    protected ComboBoxModel<String> getSimulParamsSelectModel() {
        return this.getSimulParamsSelectModel(false);
    }

    protected ComboBoxModel<String> getSimulParamsSelectModel(boolean force) {
        List<String> items = this.getFilteredOldSimulatorNames(force);
        GenericComboModel<String> result = new GenericComboModel<String>(items);
        return result;
    }

    protected void resetFilter() {
        this.resetOldSimulatorNames();
        this.tabUI.fieldSimulParamsSelect.setModel(this.getSimulParamsSelectModel(false));
    }

    public List<String> getOldSimulationItem() {
        this.oldSimulNames = new ArrayList<String>();
        this.oldSimulNames.addAll(SimulationStorage.getSimulationNames());
        this.oldSimulNames.add(0, " ");
        return this.oldSimulNames;
    }

    public List<String> getFilteredOldSimulatorNames(boolean force) {
        if (this.oldSimulNames == null || force) {
            this.oldSimulNames = this.getOldSimulationItem();
        }
        return this.oldSimulNames;
    }

    public void setOldSimulatorNames(List<String> sn) {
        this.oldSimulNames = sn;
    }

    public void resetOldSimulatorNames() {
        this.oldSimulNames = this.getOldSimulationItem();
    }

    public List<Strategy> getStrategies() {
        ArrayList<Strategy> result = new ArrayList();
        try {
            TopiaContext tx = this.getParameters().getRegion().getStorage().beginTransaction();
            result = RegionStorage.getFisheryRegion(tx).getStrategy();
            tx.rollbackTransaction();
            tx.closeContext();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't get strategies", (Throwable)e);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.simulation.liststrategies", (Object[])new Object[0]), e);
        }
        return result;
    }

    public void setStrategies(List<Strategy> strategies) {
        ArrayList<Strategy> result = new ArrayList<Strategy>(strategies);
        this.getParameters().setStrategies(result);
    }

    public List<Population> getPopulations() {
        ArrayList<Population> result = new ArrayList<Population>();
        try {
            TopiaContext tx = this.getParameters().getRegion().getStorage().beginTransaction();
            List<Species> species = RegionStorage.getFisheryRegion(tx).getSpecies();
            for (Species s : species) {
                Collection<Population> populations = s.getPopulation();
                for (Population p : populations) {
                    p.getPopulationGroup().size();
                    p.getPopulationZone().size();
                }
                result.addAll(populations);
            }
            tx.rollbackTransaction();
            tx.closeContext();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't get population", (Throwable)e);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.simulation.listpopulation", (Object[])new Object[0]), e);
        }
        return result;
    }

    public void setPopulations(List<Population> populations) {
        ArrayList<Population> result = new ArrayList<Population>(populations);
        this.getParameters().setPopulations(result);
    }

    public int getNumberOfMonths() {
        return this.getParameters().getNumberOfMonths();
    }

    public void setNumberOfMonths(String months) {
        try {
            this.getParameters().setNumberOfMonths(Integer.parseInt(months));
        }
        catch (NumberFormatException ex) {
            this.getParameters().setNumberOfMonths(1);
        }
    }
}

