/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.sensitivity.wizard;

import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.ui.sensitivity.wizard.ContinuousPanelListener;
import fr.ifremer.isisfish.ui.sensitivity.wizard.EquationContinuousPanelUI;
import fr.ifremer.isisfish.ui.sensitivity.wizard.FactorWizardUI;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class EquationContinuousPanelHandler
implements ContinuousPanelListener {
    protected EquationContinuousPanelUI equationContinuousPanelUI;
    protected List<Factor> factors = new ArrayList<Factor>();

    public EquationContinuousPanelHandler(EquationContinuousPanelUI equationContinuousPanelUI) {
        this.equationContinuousPanelUI = equationContinuousPanelUI;
    }

    public void afterInit() {
        this.equationContinuousPanelUI.distributionPanel.addContinuousPanelListener(this);
    }

    public List<Factor> getFactors() {
        return this.factors;
    }

    public void initWithFactor(Factor factor) {
        this.addFactor(factor);
    }

    protected void addFactor(Factor factor) {
        this.factors.add(factor);
        this.equationContinuousPanelUI.factorsListModel.setFactors(this.factors);
    }

    /*
     * WARNING - void declaration
     */
    protected void validSelectedFactor() {
        Factor selectedFactor = this.equationContinuousPanelUI.factorsList.getSelectedValue();
        selectedFactor.setDomain(this.equationContinuousPanelUI.distributionPanel.generateDomain());
        FactorWizardUI wizard = this.equationContinuousPanelUI.getParentContainer(FactorWizardUI.class);
        String factorName = wizard.getFactorNameField().getText().trim();
        String variableName = selectedFactor.getEquationVariableName();
        String[] lines = this.equationContinuousPanelUI.editor.getEditor().getText().split("\n");
        Object result = "";
        for (String string : lines) {
            void var10_10;
            Pattern p = Pattern.compile("(^.*\\s+" + variableName + "\\s*\\=\\s*)([\\d\\.]+).*\\;$");
            Matcher matcher = p.matcher(string);
            if (matcher.find()) {
                String fullVariableName = factorName + "." + variableName;
                String string2 = matcher.group(1) + "context.getValueAndCompute(\"" + fullVariableName + "\", " + matcher.group(2) + ");";
            }
            result = (String)result + (String)var10_10 + "\n";
        }
        this.equationContinuousPanelUI.editor.getEditor().setText((String)result);
        this.equationContinuousPanelUI.factorsListModel.setFactors(this.factors);
    }

    protected void addNewVariable() {
        Factor factor = new Factor("");
        factor.setEquationVariableName("X");
        this.addFactor(factor);
        this.equationContinuousPanelUI.factorsList.setSelectedValue(factor, true);
    }

    protected void displaySelectedFactor() {
        Factor selectedFactor = this.equationContinuousPanelUI.factorsList.getSelectedValue();
        this.equationContinuousPanelUI.setSelectedFactor(selectedFactor);
        this.equationContinuousPanelUI.distributionPanel.initWithFactor(selectedFactor);
    }

    protected void removeSelectedVariable() {
        int selectedIndex = this.equationContinuousPanelUI.factorsList.getSelectedIndex();
        this.factors.remove(selectedIndex);
        this.equationContinuousPanelUI.factorsList.clearSelection();
        this.equationContinuousPanelUI.factorsListModel.setFactors(this.factors);
    }

    public boolean isFactorValid() {
        return this.equationContinuousPanelUI.getValidator().isValid() && this.equationContinuousPanelUI.distributionPanel.isFactorValid();
    }

    @Override
    public void panelChanged() {
        this.equationContinuousPanelUI.fireContinousPanelEvent();
    }
}

