/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.rule;

import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.ui.models.RendererHelper;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

public class RuleNamesListRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -4070846632975105788L;
    protected Map<String, Rule> ruleCache = new HashMap<String, Rule>();

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        String text;
        JLabel c = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        String ruleName = (String)value;
        try {
            Rule rule = this.ruleCache.get(ruleName);
            if (rule == null) {
                RuleStorage storage = RuleStorage.getRule(ruleName, new CodeSourceStorage.Location[0]);
                rule = (Rule)storage.getNewInstance();
                this.ruleCache.put(ruleName, rule);
            }
            text = RendererHelper.getNameAndDocListString(ruleName, rule.getDescription());
        }
        catch (Exception ex) {
            text = RendererHelper.getNameAndCompListString(ruleName);
        }
        c.setText(text);
        return c;
    }
}

