/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models.optimization;

import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ObjectiveStorage;
import fr.ifremer.isisfish.simulator.Objective;
import fr.ifremer.isisfish.ui.models.RendererHelper;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;

public class ObjectiveComboRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -4070846632975105788L;
    protected Map<String, Objective> objectiveCache = new HashMap<String, Objective>();

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel c = (JLabel)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        String objectiveName = (String)value;
        if (objectiveName != null) {
            String text;
            try {
                Objective objective = this.objectiveCache.get(objectiveName);
                if (objective == null) {
                    ObjectiveStorage storage = ObjectiveStorage.getObjective(objectiveName, new CodeSourceStorage.Location[0]);
                    objective = (Objective)storage.getNewInstance();
                    this.objectiveCache.put(objectiveName, objective);
                }
                text = RendererHelper.getNameAndDocComboString(objectiveName, objective.getDescription());
            }
            catch (Exception e) {
                text = RendererHelper.getNameAndCompComboString(objectiveName);
            }
            c.setText(text);
        }
        return c;
    }
}

