/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.logging;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.ui.logging.LogFrame;
import fr.ifremer.isisfish.util.UIUtil;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.ThreadContext;
import org.nuiton.i18n.I18n;

public class SimulationLoggerUtil {
    public static final String PLAN_CONTEXT_ID = "planContextId";
    public static final String PLAN_LOG_FILE = "planLogFile";

    public static void showSimulationLogConsole(Component parent, String simulationName) throws IOException {
        SimulationStorage storage = SimulationStorage.getSimulation(simulationName);
        File logFile = new File(storage.getSimulationLogFile());
        String title = I18n.t((String)"isisfish.simulation.log.console.title", (Object[])new Object[]{simulationName});
        LogFrame logFrame = new LogFrame();
        logFrame.setName("logFrame");
        UIUtil.setIconImage(logFrame);
        logFrame.setTitle(title);
        logFrame.open(logFile);
        logFrame.setSize(1024, 768);
        logFrame.setLocationRelativeTo(parent);
        logFrame.setVisible(true);
    }

    public static void setPlanLoggingContext(String id) {
        ThreadContext.put((String)PLAN_CONTEXT_ID, (String)id);
        File logFile = new File(IsisFish.config.getLogDirectory(), id + ".log");
        ThreadContext.put((String)PLAN_LOG_FILE, (String)logFile.getAbsolutePath());
    }

    public static void clearPlanLoggingContext() {
        ThreadContext.clearAll();
    }
}

