/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.RangeOfValues;
import fr.ifremer.isisfish.types.TimeUnit;
import fr.ifremer.isisfish.util.matrix.EntitySemanticsDecorator;
import fr.ifremer.isisfish.util.matrix.MatrixCSVHelper;
import java.awt.FlowLayout;
import java.io.IOException;
import java.io.Reader;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaId;

public class RegionImportJson {
    private static Log log = LogFactory.getLog(RegionImportJson.class);
    protected RegionMerge merge;
    protected JsonNode json;
    protected Map<String, TopiaEntity> entities;
    protected JsonNode jsonEntities;

    public RegionImportJson(Reader r, RegionMerge merge) {
        try {
            this.merge = merge != null ? merge : new RegionMergeImportAll();
            this.entities = new LinkedHashMap<String, TopiaEntity>();
            this.merge.setEntities(this.entities);
            ObjectMapper m = new ObjectMapper();
            this.json = m.readTree(r);
            this.jsonEntities = this.json.get("#entities");
        }
        catch (IOException eee) {
            throw new RuntimeException(eee);
        }
    }

    protected boolean canImportCell() {
        return false;
    }

    public Collection<TopiaEntity> getEntities() {
        try {
            JsonNode info = this.json.with("#info");
            boolean isRegion = info.get("region").asBoolean(false);
            if (!isRegion) {
                String rootId = info.get("rootId").asText();
                RegionVisitor v = new RegionVisitor(this.merge, null, null, rootId, this.entities, this.jsonEntities, this.canImportCell());
                v.loadEntity();
            } else {
                Iterator i = this.json.fields();
                while (i.hasNext()) {
                    Map.Entry field = (Map.Entry)i.next();
                    if (((String)field.getKey()).startsWith("#")) continue;
                    for (JsonNode id : (JsonNode)field.getValue()) {
                        RegionVisitor v = new RegionVisitor(this.merge, null, null, id.asText(), this.entities, this.jsonEntities, this.canImportCell());
                        v.loadEntity();
                    }
                }
            }
            return this.entities.values();
        }
        catch (Exception eee) {
            throw new RuntimeException(eee);
        }
    }

    public static class RegionMergeImportAll
    implements RegionMerge {
        protected RegionMerge.Answer lastAnswer;
        protected Map<String, TopiaEntity> entities;

        @Override
        public boolean isAbort() {
            return false;
        }

        @Override
        public void setEntities(Map<String, TopiaEntity> entities) {
            this.entities = entities;
        }

        @Override
        public RegionMerge.Answer choice(String id, String toString, Map<String, Object> details, RegionMerge.AnswerType ... disallow) {
            this.lastAnswer = new RegionMerge.Answer(RegionMerge.AnswerType.CREATE, null);
            return this.lastAnswer;
        }
    }

    public static interface RegionMerge {
        public void setEntities(Map<String, TopiaEntity> var1);

        public Answer choice(String var1, String var2, Map<String, Object> var3, AnswerType ... var4);

        public boolean isAbort();

        public static class Answer {
            public AnswerType type;
            public TopiaEntity entity;

            public Answer(AnswerType type, TopiaEntity entity) {
                this.type = type;
                this.entity = entity;
            }
        }

        public static enum AnswerType {
            NONE(I18n.t((String)"isisfish.import.json.merge.option.none", (Object[])new Object[0]), I18n.t((String)"isisfish.import.json.merge.option.none.desc", (Object[])new Object[0])),
            USE(I18n.t((String)"isisfish.import.json.merge.option.use", (Object[])new Object[0]), I18n.t((String)"isisfish.import.json.merge.option.use.desc", (Object[])new Object[0])),
            REPLACE(I18n.t((String)"isisfish.import.json.merge.option.replace", (Object[])new Object[0]), I18n.t((String)"isisfish.import.json.merge.option.replace.desc", (Object[])new Object[0])),
            CREATE(I18n.t((String)"isisfish.import.json.merge.option.create", (Object[])new Object[0]), I18n.t((String)"isisfish.import.json.merge.option.create.desc", (Object[])new Object[0])),
            ABORT(I18n.t((String)"isisfish.import.json.merge.option.abort", (Object[])new Object[0]), I18n.t((String)"isisfish.import.json.merge.option.abort.desc", (Object[])new Object[0]));

            private final String toString;
            private final String description;

            private AnswerType(String toString, String description) {
                this.toString = toString;
                this.description = description;
            }

            public String getDescription() {
                return this.description;
            }

            public String toString() {
                return this.toString;
            }
        }

        public static enum AutoAnswerType {
            ONCE(I18n.t((String)"isisfish.import.json.merge.autoanswer.once", (Object[])new Object[0])),
            TYPE(I18n.t((String)"isisfish.import.json.merge.autoanswer.type", (Object[])new Object[0])),
            ALL(I18n.t((String)"isisfish.import.json.merge.autoanswer.all", (Object[])new Object[0]));

            private final String toString;

            private AutoAnswerType(String toString) {
                this.toString = toString;
            }

            public String toString() {
                return this.toString;
            }
        }
    }

    protected static class RegionVisitor
    implements EntityVisitor {
        protected RegionMerge merge;
        protected JsonNode nodeEntity;
        protected TopiaEntity parentEntity;
        protected String propertyName;
        protected TopiaEntity currentEntity;
        protected Map<String, TopiaEntity> entities;
        protected JsonNode jsonEntities;
        protected boolean canImportCell;

        public RegionVisitor(RegionMerge merge, TopiaEntity parentEntity, String propertyName, String idEntity, Map<String, TopiaEntity> entities, JsonNode jsonEntities, boolean canImportCell) {
            this.merge = merge;
            this.parentEntity = parentEntity;
            this.propertyName = propertyName;
            this.nodeEntity = jsonEntities.get(idEntity);
            this.entities = entities;
            this.jsonEntities = jsonEntities;
            this.canImportCell = canImportCell;
        }

        public TopiaEntity loadEntity() {
            String id = this.nodeEntity.get("#id").asText();
            this.currentEntity = this.entities.get(id);
            if (this.currentEntity == null) {
                this.currentEntity = this.ask(id);
            }
            return this.currentEntity;
        }

        protected TopiaEntity convertJsonToEntity(JsonNode node, TopiaEntity result) {
            String id = node.get("#id").asText();
            String className = node.get("#class").asText();
            try {
                if (result == null) {
                    Class<?> clazz = Class.forName(className);
                    result = (TopiaEntity)clazz.newInstance();
                    result.setTopiaId(TopiaId.create((Class)TopiaId.getClassName((String)id)));
                }
                this.entities.put(id, result);
                result.accept((EntityVisitor)this);
            }
            catch (Exception eee) {
                throw new IsisFishRuntimeException("Can't instanciate entity: " + className, eee);
            }
            return result;
        }

        public boolean canImportCell() {
            return this.canImportCell;
        }

        protected TopiaEntity ask(String id) {
            JsonNode node = this.jsonEntities.get(id);
            HashMap<String, Object> details = new HashMap<String, Object>();
            Iterator i = node.fields();
            while (i.hasNext()) {
                Map.Entry e = (Map.Entry)i.next();
                if (((String)e.getKey()).startsWith("#")) continue;
                details.put((String)e.getKey(), ((JsonNode)e.getValue()).asText());
            }
            String toString = node.get("#toString").asText();
            EnumSet<RegionMerge.AnswerType> disallow = EnumSet.noneOf(RegionMerge.AnswerType.class);
            Class currentEntityClass = TopiaId.getClassName((String)id);
            if (Species.class.isAssignableFrom(currentEntityClass) && "species".equals(this.propertyName)) {
                disallow.add(RegionMerge.AnswerType.NONE);
            } else if (Cell.class.isAssignableFrom(currentEntityClass) && !this.canImportCell()) {
                disallow.add(RegionMerge.AnswerType.CREATE);
            }
            RegionMerge.Answer answer = this.merge.choice(id, toString, details, disallow.toArray(new RegionMerge.AnswerType[0]));
            return switch (answer.type.ordinal()) {
                case 4 -> throw new IsisFishRuntimeException("Import aborted by user");
                case 0 -> null;
                case 1 -> answer.entity;
                case 2 -> this.convertJsonToEntity(node, answer.entity);
                case 3 -> this.convertJsonToEntity(node, null);
                default -> throw new IsisFishRuntimeException("Unsupported action");
            };
        }

        protected Object readValue(String propertyName, Class<?> type, JsonNode value) {
            Object result;
            block12: {
                try {
                    if (value == null || value.isNull() || value.isMissingNode()) {
                        result = null;
                        break block12;
                    }
                    if (TopiaEntity.class.isAssignableFrom(type)) {
                        String id2 = value.asText();
                        RegionVisitor child = new RegionVisitor(this.merge, this.currentEntity, propertyName, id2, this.entities, this.jsonEntities, this.canImportCell());
                        result = child.loadEntity();
                        break block12;
                    }
                    if (MatrixND.class.isAssignableFrom(type)) {
                        String mat = value.asText();
                        MatrixCSVHelper matrixCSVHelper = new MatrixCSVHelper(new EntitySemanticsDecorator(id -> {
                            RegionVisitor child = new RegionVisitor(this.merge, this.currentEntity, propertyName, id, this.entities, this.jsonEntities, this.canImportCell());
                            TopiaEntity result1 = child.loadEntity();
                            return result1;
                        }));
                        result = matrixCSVHelper.readMatrix(mat);
                        break block12;
                    }
                    if (TimeUnit.class.isAssignableFrom(type)) {
                        result = new TimeUnit(value.asDouble());
                        break block12;
                    }
                    if (RangeOfValues.class.isAssignableFrom(type)) {
                        String v = value.asText();
                        result = new RangeOfValues(v);
                        break block12;
                    }
                    if (Month.class.isAssignableFrom(type)) {
                        int m = value.asInt();
                        result = Month.MONTH[m];
                        break block12;
                    }
                    if (Class.class.isAssignableFrom(type)) {
                        String className = value.asText();
                        result = Class.forName(className);
                        break block12;
                    }
                    if (String.class.isAssignableFrom(type)) {
                        result = value.asText();
                        break block12;
                    }
                    if (Boolean.class.isAssignableFrom(type) || Boolean.TYPE.isAssignableFrom(type)) {
                        result = value.asBoolean();
                        break block12;
                    }
                    if (Number.class.isAssignableFrom(type) || type.isPrimitive()) {
                        result = value.asDouble();
                        break block12;
                    }
                    String message = String.format("Unsupported type: '%s' value class '%s' value '%s'", type, value.getClass().getName(), value);
                    log.error((Object)message);
                    throw new IsisFishRuntimeException(message);
                }
                catch (Exception eee) {
                    throw new IsisFishRuntimeException("Can't convert json value:" + String.valueOf(value), eee);
                }
            }
            return result;
        }

        public void start(TopiaEntity entity) {
        }

        public void end(TopiaEntity entity) {
        }

        public void visit(TopiaEntity entity, String propertyName, Class<?> type, Object value) {
            JsonNode jsonValue = this.nodeEntity.get(propertyName);
            try {
                value = this.readValue(propertyName, type, jsonValue);
                BeanUtils.setProperty((Object)entity, (String)propertyName, (Object)value);
            }
            catch (Exception eee) {
                throw new IsisFishRuntimeException(String.format("Can't set property '%s' from json value: '%s'", propertyName, jsonValue), eee);
            }
        }

        public void visit(TopiaEntity entity, String propertyName, Class<?> collectionType, Class<?> type, Object value) {
            JsonNode jsonValue = this.nodeEntity.get(propertyName);
            try {
                if (jsonValue != null) {
                    AbstractCollection c = Set.class.isAssignableFrom(collectionType) ? new HashSet() : new ArrayList();
                    for (JsonNode currentValue : jsonValue) {
                        Object v = this.readValue(propertyName, type, currentValue);
                        if (v == null) continue;
                        c.add(v);
                    }
                    BeanUtils.setProperty((Object)entity, (String)propertyName, c);
                }
            }
            catch (Exception eee) {
                throw new IsisFishRuntimeException(String.format("Can't set property '%s' from json value: '%s'", propertyName, jsonValue), eee);
            }
        }

        public void visit(TopiaEntity entity, String propertyName, Class<?> collectionType, Class<?> type, int index, Object value) {
            throw new UnsupportedOperationException("FIXME a faire, implantation des properties array");
        }

        public void clear() {
        }
    }

    public static class RegionMergeDatabase
    implements RegionMerge {
        protected TopiaContext tx;
        protected RegionMergeContext context;
        protected RegionMerge.Answer lastAnswer;
        protected Map<String, TopiaEntity> entities;

        public RegionMergeDatabase(TopiaContext tx) {
            this.tx = tx;
        }

        protected boolean isAcceptableAnswer(RegionMerge.AnswerType type, RegionMerge.AnswerType ... disallow) {
            boolean result = type != null && !Arrays.asList(disallow).contains((Object)type);
            return result;
        }

        @Override
        public void setEntities(Map<String, TopiaEntity> entities) {
            this.entities = entities;
        }

        @Override
        public RegionMerge.Answer choice(String id, String toString, Map<String, Object> details, RegionMerge.AnswerType ... disallow) {
            Class type = TopiaId.getClassName((String)id);
            if (this.context == null) {
                this.context = new RegionMergeContext();
            }
            if (!this.isAcceptableAnswer(this.context.initAnswer(type), disallow)) {
                Object dao = IsisFishDAOHelper.getDAO(this.tx, type);
                LinkedHashSet<TopiaEntity> possible = new LinkedHashSet<TopiaEntity>();
                for (TopiaEntity entity : this.entities.values()) {
                    if (!type.isAssignableFrom(entity.getClass())) continue;
                    possible.add(entity);
                }
                TopiaEntity byTopiaIdFromDatabase = dao.findByTopiaId(id);
                if (byTopiaIdFromDatabase != null) {
                    possible.add(byTopiaIdFromDatabase);
                }
                if (Equation.class.isAssignableFrom(this.context.getCurrentType())) {
                    if (details.containsKey("name") && details.containsKey("category")) {
                        possible.addAll(dao.findAllByProperties("name", details.get("name"), new Object[]{"category", details.get("category")}));
                    }
                } else if (details.containsKey("name")) {
                    possible.addAll(dao.findAllByProperty("name", details.get("name")));
                }
                if (!this.isAcceptableAnswer(this.context.initAnswer(type, possible), disallow)) {
                    if (Equation.class.isAssignableFrom(this.context.getCurrentType())) {
                        if (details.containsKey("category")) {
                            possible.addAll(dao.findAllByProperty("category", details.get("category")));
                        }
                    } else {
                        possible.addAll(dao.findAll());
                    }
                    this.ask(this.context, toString, details, possible, disallow);
                }
            }
            this.lastAnswer = this.context.getAnswer();
            return this.lastAnswer;
        }

        protected RegionMerge.AnswerType ask(RegionMergeContext context, String toString, Map<String, Object> details, Collection<TopiaEntity> possible, RegionMerge.AnswerType ... disallow) {
            JPanel radioPanel = new JPanel(new FlowLayout());
            ButtonGroup group = new ButtonGroup();
            for (RegionMerge.AutoAnswerType auto : RegionMerge.AutoAnswerType.values()) {
                JRadioButton radio = new JRadioButton(auto.toString);
                radio.setSelected(RegionMerge.AutoAnswerType.ONCE == auto);
                radio.setActionCommand(auto.name());
                group.add(radio);
                radioPanel.add(radio);
            }
            JComboBox<TopiaEntity> select = new JComboBox<TopiaEntity>(possible.toArray(new TopiaEntity[0]));
            ArrayList<RegionMerge.AnswerType> allowedOptions = new ArrayList<RegionMerge.AnswerType>(Arrays.asList(RegionMerge.AnswerType.values()));
            for (RegionMerge.AnswerType t : disallow) {
                allowedOptions.remove((Object)t);
            }
            Object[] options = allowedOptions.toArray();
            ArrayList<Object> descriptions = new ArrayList<Object>();
            descriptions.add(I18n.t((String)"isisfish.import.json.merge.info", (Object[])new Object[]{toString, ClassUtils.getShortClassName((Class)context.getCurrentType())}));
            descriptions.add(I18n.t((String)"isisfish.import.json.merge.possibleanswers", (Object[])new Object[0]));
            for (RegionMerge.AnswerType t : allowedOptions) {
                descriptions.add(t.toString() + ": " + t.getDescription());
            }
            descriptions.add(select);
            descriptions.add(radioPanel);
            int result = JOptionPane.showOptionDialog(null, descriptions.toArray(), I18n.t((String)"isisfish.import.json.merge.title", (Object[])new Object[0]), -1, 3, null, options, options[0]);
            TopiaEntity selectEntity = (TopiaEntity)select.getSelectedItem();
            if (result >= 0) {
                RegionMerge.AnswerType reply = (RegionMerge.AnswerType)((Object)allowedOptions.get(result));
                RegionMerge.AutoAnswerType auto = RegionMerge.AutoAnswerType.valueOf(group.getSelection().getActionCommand());
                context.setLastAnswer(reply, auto, selectEntity);
            } else {
                this.ask(context, toString, details, possible, new RegionMerge.AnswerType[0]);
            }
            return context.lastAnswerType;
        }

        @Override
        public boolean isAbort() {
            boolean result = this.lastAnswer != null && this.lastAnswer.type == RegionMerge.AnswerType.ABORT;
            return result;
        }

        public static class RegionMergeContext {
            protected boolean abort = false;
            protected EnumSet<RegionMerge.AnswerType> replyAll = EnumSet.noneOf(RegionMerge.AnswerType.class);
            protected HashMap<RegionMerge.AnswerType, Set<Class>> replyType = new HashMap<RegionMerge.AnswerType, Set<Class>>(this){
                final /* synthetic */ RegionMergeContext this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Set<Class> get(Object key) {
                    HashSet result = (HashSet)super.get(key);
                    if (result == null) {
                        result = new HashSet();
                        this.put((RegionMerge.AnswerType)((Object)key), result);
                    }
                    return result;
                }
            };
            protected RegionMerge.AnswerType lastAnswerType = null;
            protected TopiaEntity reuseEntity;
            protected Class currentType;

            public RegionMergeContext() {
            }

            public RegionMergeContext(boolean importAll) {
                this.replyAll.add(RegionMerge.AnswerType.CREATE);
            }

            public RegionMerge.Answer getAnswer() {
                RegionMerge.Answer result = null;
                if (this.lastAnswerType != null) {
                    result = new RegionMerge.Answer(this.lastAnswerType, this.reuseEntity);
                }
                return result;
            }

            public Class getCurrentType() {
                return this.currentType;
            }

            protected void setLastAnswer(RegionMerge.AnswerType lastAnswer, RegionMerge.AutoAnswerType autoType) {
                this.setLastAnswer(lastAnswer, autoType, null);
            }

            protected void setLastAnswer(RegionMerge.AnswerType lastAnswer, RegionMerge.AutoAnswerType autoType, TopiaEntity e) {
                this.reuseEntity = e;
                this.lastAnswerType = lastAnswer;
                if (RegionMerge.AnswerType.ABORT == lastAnswer) {
                    this.abort = true;
                }
                switch (autoType.ordinal()) {
                    case 1: {
                        Set<Class> set = this.replyType.get((Object)lastAnswer);
                        set.add(this.currentType);
                        break;
                    }
                    case 2: {
                        this.replyAll.add(lastAnswer);
                    }
                }
            }

            public RegionMerge.AnswerType initAnswer(Class type) {
                this.lastAnswerType = null;
                this.currentType = type;
                if (this.abort) {
                    this.lastAnswerType = RegionMerge.AnswerType.ABORT;
                } else if (this.replyAll.contains((Object)RegionMerge.AnswerType.NONE) || this.replyType.get((Object)RegionMerge.AnswerType.NONE).contains(type)) {
                    this.lastAnswerType = RegionMerge.AnswerType.NONE;
                } else if (this.replyAll.contains((Object)RegionMerge.AnswerType.CREATE) || this.replyType.get((Object)RegionMerge.AnswerType.CREATE).contains(type)) {
                    this.lastAnswerType = RegionMerge.AnswerType.CREATE;
                }
                return this.lastAnswerType;
            }

            public RegionMerge.AnswerType initAnswer(Class type, Set<TopiaEntity> possible) {
                this.lastAnswerType = null;
                this.currentType = type;
                if (possible != null && possible.size() == 1 && (this.replyAll.contains((Object)RegionMerge.AnswerType.USE) || this.replyType.get((Object)RegionMerge.AnswerType.USE).contains(type))) {
                    this.lastAnswerType = RegionMerge.AnswerType.USE;
                    this.reuseEntity = possible.iterator().next();
                } else if (possible != null && possible.size() == 1 && (this.replyAll.contains((Object)RegionMerge.AnswerType.REPLACE) || this.replyType.get((Object)RegionMerge.AnswerType.REPLACE).contains(type))) {
                    this.lastAnswerType = RegionMerge.AnswerType.REPLACE;
                    this.reuseEntity = possible.iterator().next();
                }
                return this.lastAnswerType;
            }
        }
    }
}

