/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.datastore.StorageChangeListener;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.collections4.map.ReferenceMap;

public class SimulatorStorage
extends JavaSourceStorage {
    public static final String SIMULATOR_PATH = "simulators";
    public static final String SIMULATOR_TEMPLATE = "templates/script/simulator.ftl";
    protected static Map<String, SimulatorStorage> simulatorsCache = new ReferenceMap();
    protected static Set<StorageChangeListener> storageListeners = Collections.newSetFromMap(new WeakHashMap());

    public static void addStorageListener(StorageChangeListener storageListener) {
        storageListeners.add(storageListener);
    }

    protected SimulatorStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name);
    }

    public static void registerWatcher() {
        SimulatorStorage.registerWatcher(storageListeners, SimulatorStorage.getSimulatorDirectory(), SimulatorStorage.getCommunitySimulatorDirectory());
    }

    @Override
    public String getPackage() {
        return SIMULATOR_PATH;
    }

    public static File getSimulatorDirectory() {
        File result = new File(SimulatorStorage.getContextDatabaseDirectory(), SIMULATOR_PATH);
        result.mkdirs();
        return result;
    }

    public static File getCommunitySimulatorDirectory() {
        File result = new File(SimulatorStorage.getCommunityDatabaseDirectory(), SIMULATOR_PATH);
        result.mkdirs();
        return result;
    }

    public static SimulatorStorage getSimulator(String name, CodeSourceStorage.Location ... location) {
        SimulatorStorage result = simulatorsCache.get(name);
        if (result == null) {
            CodeSourceStorage.Location loc = SimulatorStorage.nonEmptyLocation(location);
            for (File dir : loc.getDirectories()) {
                SimulatorStorage storage = new SimulatorStorage(dir, new File(dir, SIMULATOR_PATH), name);
                if (!storage.getFile().isFile()) continue;
                result = storage;
                simulatorsCache.put(name, result);
            }
        }
        return result;
    }

    public static SimulatorStorage createSimulator(String name, CodeSourceStorage.Location location) {
        File dir = location.getDirectories()[0];
        SimulatorStorage storage = new SimulatorStorage(dir, new File(dir, SIMULATOR_PATH), name);
        return storage;
    }

    public static void checkout() throws VCSException {
        SimulatorStorage.checkout(IsisFish.config.getDatabaseDirectory(), SIMULATOR_PATH);
    }

    public static List<String> getSimulatorNames() {
        List<String> result = SimulatorStorage.getStorageNames(SimulatorStorage.getSimulatorDirectory());
        result.addAll(SimulatorStorage.getStorageNames(SimulatorStorage.getCommunitySimulatorDirectory()));
        return result;
    }

    public static List<String> getNewSimulatorNames() {
        List<String> result = SimulatorStorage.getSimulatorNames();
        result.removeAll(SimulatorStorage.getRemoteSimulatorNames());
        return result;
    }

    public static List<String> getRemoteSimulatorNames() {
        File dir = SimulatorStorage.getSimulatorDirectory();
        List<String> result = SimulatorStorage.getRemoteStorageNames(dir);
        return result;
    }

    public static List<String> getNewRemoteSimulatorNames() {
        List<String> result = SimulatorStorage.getRemoteSimulatorNames();
        result.removeAll(SimulatorStorage.getSimulatorNames());
        return result;
    }
}

