/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util.converter;

import java.util.List;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaId;

public class TopiaEntityConverter
implements Converter {
    private static final Log log = LogFactory.getLog(TopiaEntityConverter.class);
    protected TopiaContext context = null;
    protected SharedSessionContractImplementor session = null;

    public TopiaEntityConverter(TopiaContext context) {
        this.context = context;
    }

    public TopiaEntityConverter(SharedSessionContractImplementor session) {
        this.session = session;
    }

    public Object convert(Class type, Object value) {
        Object result;
        if (value == null) {
            result = null;
        } else if (value instanceof TopiaEntity) {
            result = value;
        } else if (value instanceof String) {
            value = StringUtils.substringBefore((String)((String)value), (String)":");
            result = this.getTopiaEntity((String)value);
        } else {
            throw new ConversionException("Can't convert '" + value + "' to " + type.getName());
        }
        return result;
    }

    private TopiaEntity getTopiaEntity(String topiaId) {
        TopiaEntity result;
        block8: {
            result = null;
            if (this.context != null) {
                try {
                    TopiaContext tx = this.context.beginTransaction();
                    result = tx.findByTopiaId(topiaId);
                    tx.commitTransaction();
                    tx.closeContext();
                }
                catch (TopiaException eee) {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Can't find Entity from TopiaId " + topiaId), (Throwable)eee);
                    }
                    break block8;
                }
            }
            if (this.session != null) {
                String entityClass = TopiaId.getClassNameAsString((String)topiaId);
                try {
                    String hql = "from " + entityClass + " where topiaId=:id";
                    List results = this.session.createQuery(hql).setParameter("id", (Object)topiaId).list();
                    result = (TopiaEntity)results.get(0);
                }
                catch (HibernateException eee) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Can't find TopiaEntity: " + topiaId), (Throwable)eee);
                    }
                    throw eee;
                }
            }
        }
        return result;
    }
}

