/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util.cache;

import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.util.cache.IsisCacheBackend;
import java.util.Map;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IsisCacheBackendOnReferenceMap
implements IsisCacheBackend {
    private static Log log = LogFactory.getLog(IsisCacheBackendOnReferenceMap.class);
    public static IsisCacheBackend.Factory factory = new IsisCacheBackendOnReferenceMapFactory();
    private static final int entityPackageLenght = "fr.ifremer.isisfish.entities.".length();
    private static final Object NULL = new Object();
    protected Map cache = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.WEAK, AbstractReferenceMap.ReferenceStrength.HARD);

    protected Map getCacheTimeStep(TimeStep step) {
        Map result;
        Object key = step;
        if (step == null) {
            key = NULL;
        }
        if ((result = (Map)this.cache.get(key)) == null) {
            result = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.SOFT);
            this.cache.put(key, result);
        }
        return result;
    }

    @Override
    public Object get(TimeStep step, String key) {
        Object result = null;
        Map cacheTimeStep = this.getCacheTimeStep(step);
        if (cacheTimeStep != null) {
            result = cacheTimeStep.get(key);
        }
        return result;
    }

    @Override
    public void put(TimeStep step, String key, Object value) {
        this.getCacheTimeStep(step).put(key, value);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void removeStep(Object o) {
        this.cache.remove(o);
    }

    @Override
    public String getStat() {
        return String.format("%s - no specific stat\n", this.getClass().getSimpleName());
    }

    public static class IsisCacheBackendOnReferenceMapFactory
    implements IsisCacheBackend.Factory {
        @Override
        public IsisCacheBackend createNew() {
            return new IsisCacheBackendOnReferenceMap();
        }
    }
}

