/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import java.awt.Component;
import java.awt.Desktop;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.error.ErrorReporter;
import org.nuiton.i18n.I18n;

public class ErrorHelper
implements ErrorReporter {
    public static void showErrorDialog(Component parent, String message, Throwable cause) {
        JXErrorPane pane = new JXErrorPane();
        String details = "<pre>\n" + ErrorHelper.getDetails(cause) + "\n</pre>";
        ErrorInfo info = new ErrorInfo(I18n.t((String)"isisfish.error.errorpane.title", (Object[])new Object[0]), I18n.t((String)"isisfish.error.errorpane.htmlmessage", (Object[])new Object[]{message}), details, null, cause, null, null);
        pane.setErrorInfo(info);
        if (cause != null) {
            pane.setErrorReporter((ErrorReporter)new ErrorHelper());
        }
        JXErrorPane.showDialog((Component)parent, (JXErrorPane)pane);
    }

    public static void showErrorDialog(String message) {
        ErrorHelper.showErrorDialog(message, null);
    }

    public static void showErrorDialog(String message, Throwable cause) {
        ErrorHelper.showErrorDialog(null, message, cause);
    }

    private static String getDetails(Throwable cause) {
        String result = "";
        if (cause != null) {
            StringWriter out = new StringWriter();
            PrintWriter writer = new PrintWriter(out);
            cause.printStackTrace(writer);
            out.flush();
            result = out.toString();
        }
        return result;
    }

    public void reportError(ErrorInfo errorInfo) throws NullPointerException {
        try {
            Throwable rootCause = errorInfo.getErrorException();
            String details = null;
            do {
                if (rootCause == null && details == null) {
                    details = "[Please, copy/paste JAVA stacktrace here]";
                    details = URLEncoder.encode(details, StandardCharsets.UTF_8.name());
                    continue;
                }
                if (rootCause == null) {
                    details = StringUtils.truncate((String)details, (int)1900);
                    continue;
                }
                details = "[...]\n" + ErrorHelper.getDetails(rootCause);
                details = URLEncoder.encode(details, StandardCharsets.UTF_8.name());
                rootCause = rootCause.getCause();
            } while (details.length() > 1900);
            String urlString = IsisFish.config.getBugReportUrl() + "?issue[description]=" + details;
            URI uri = new URI(urlString);
            Desktop.getDesktop().browse(uri);
        }
        catch (IOException | URISyntaxException e) {
            throw new IsisFishRuntimeException("Can't open desktop", e);
        }
    }
}

