/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.widget.interval;

import fr.ifremer.isisfish.ui.widget.interval.Interval;
import fr.ifremer.isisfish.ui.widget.interval.IntervalGraphic;
import fr.ifremer.isisfish.ui.widget.interval.IntervalLabel;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;

public class IntervalPanel
extends JPanel
implements Observer {
    private static final long serialVersionUID = 4245022583233407638L;
    private static final int DEFAULT_WIDTH = 110;
    private static final int DEFAULT_HEIGHT = 50;
    private Interval model = null;
    private IntervalGraphic graph;
    private IntervalLabel label;

    public IntervalPanel() {
        this((Interval)null);
    }

    public IntervalPanel(Interval model) {
        this(model, 110, 50);
    }

    public IntervalPanel(Interval model, int width, int height) {
        if (model == null) {
            model = new Interval(0, 0);
        }
        this.model = model;
        this.setPreferredSize(new Dimension(width, height));
        this.setLayout(new GridLayout(2, 1));
        this.graph = new IntervalGraphic(this.model);
        this.label = new IntervalLabel(this.model);
        this.label.setVisible(true);
        this.graph.setVisible(true);
        this.add(this.label);
        this.add(this.graph);
    }

    public Interval getModel() {
        return this.model;
    }

    public void setModel(Interval model) {
        if (this.model != null) {
            this.model.deleteObserver(this);
        }
        this.model = model;
        model.addObserver(this);
        this.graph.setModel(model);
        this.label.setModel(model);
    }

    @Override
    public void setEnabled(boolean enable) {
        this.graph.setEnabled(enable);
        this.label.setEnabled(enable);
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof String) {
            String props = (String)arg;
            if (props.contains("min")) {
                this.firePropertyChange("min", null, (Object)this.getModel().getMin());
            }
            if (props.contains("max")) {
                this.firePropertyChange("max", null, (Object)this.getModel().getMax());
            }
            if (props.contains("first")) {
                this.firePropertyChange("first", null, (Object)this.getModel().getFirst());
            }
            if (props.contains("last")) {
                this.firePropertyChange("last", null, (Object)this.getModel().getLast());
            }
        }
    }

    public void setLabelRenderer(Object[] renderArray) {
        this.label.setLabelRenderer(renderArray);
    }
}

