/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.script.model;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.FormuleStorage;
import fr.ifremer.isisfish.datastore.ObjectiveStorage;
import fr.ifremer.isisfish.datastore.OptimizationStorage;
import fr.ifremer.isisfish.datastore.ResultInfoStorage;
import fr.ifremer.isisfish.datastore.RuleStorage;
import fr.ifremer.isisfish.datastore.ScriptStorage;
import fr.ifremer.isisfish.datastore.SensitivityAnalysisStorage;
import fr.ifremer.isisfish.datastore.SensitivityExportStorage;
import fr.ifremer.isisfish.datastore.SimulationPlanStorage;
import fr.ifremer.isisfish.datastore.SimulatorStorage;
import fr.ifremer.isisfish.vcs.VCS;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.tree.TreeModelSupport;

public class ScriptTreeModel
implements TreeModel {
    private static Log log = LogFactory.getLog(ScriptTreeModel.class);
    protected TreeModelSupport modelSupport;
    protected List<VCS> vcsList = new ArrayList<VCS>();
    protected Map<VCS, List<File>> rootFiles;
    public static final int OPERATION_ADD = 0;
    public static final int OPERATION_MODIFY = 1;
    public static final int OPERATION_DELETE = 2;

    public ScriptTreeModel() {
        this.modelSupport = new TreeModelSupport((TreeModel)this);
        this.rootFiles = new HashMap<VCS, List<File>>();
        ArrayList<File> offFiles = new ArrayList<File>();
        offFiles.add(ExportStorage.getExportDirectory());
        offFiles.add(FormuleStorage.getFormuleDirectory());
        offFiles.add(ObjectiveStorage.getObjectiveDirectory());
        offFiles.add(OptimizationStorage.getOptimizationDirectory());
        offFiles.add(ResultInfoStorage.getResultInfoDirectory());
        offFiles.add(RuleStorage.getRuleDirectory());
        offFiles.add(ScriptStorage.getScriptDirectory());
        offFiles.add(SensitivityAnalysisStorage.getSensitivityAnalysisDirectory());
        offFiles.add(SensitivityExportStorage.getSensitivityExportDirectory());
        offFiles.add(SimulationPlanStorage.getSimulationPlanDirectory());
        offFiles.add(SimulatorStorage.getSimulatorDirectory());
        ArrayList<File> comFiles = new ArrayList<File>();
        comFiles.add(ExportStorage.getCommunityExportDirectory());
        comFiles.add(FormuleStorage.getCommunityFormuleDirectory());
        comFiles.add(ObjectiveStorage.getCommunityObjectiveDirectory());
        comFiles.add(OptimizationStorage.getCommunityOptimizationDirectory());
        comFiles.add(ResultInfoStorage.getCommunityResultInfoDirectory());
        comFiles.add(RuleStorage.getCommunityRuleDirectory());
        comFiles.add(ScriptStorage.getCommunityScriptDirectory());
        comFiles.add(SensitivityAnalysisStorage.getCommunitySensitivityAnalysisDirectory());
        comFiles.add(SensitivityExportStorage.getCommunitySensitivityExportDirectory());
        comFiles.add(SimulationPlanStorage.getCommunitySimulationPlanDirectory());
        comFiles.add(SimulatorStorage.getCommunitySimulatorDirectory());
        this.rootFiles.put(IsisFish.vcs, offFiles);
        this.rootFiles.put(IsisFish.communityVcs, comFiles);
        this.vcsList.add(IsisFish.vcs);
        this.vcsList.add(IsisFish.communityVcs);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.modelSupport.addTreeModelListener(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        Object result;
        if (parent == this.vcsList) {
            result = this.vcsList.get(index);
        } else if (parent instanceof VCS) {
            result = this.rootFiles.get(parent).get(index);
        } else {
            File parentFile = (File)parent;
            File[] filesArray = parentFile.listFiles();
            List<File> files = this.getVersionnableSortedFiles(filesArray);
            result = files.get(index);
        }
        return result;
    }

    @Override
    public int getChildCount(Object parent) {
        int count = 0;
        if (parent == this.vcsList) {
            count = this.vcsList.size();
        } else if (parent instanceof VCS) {
            count = this.rootFiles.get(parent).size();
        } else {
            File parentFile = (File)parent;
            File[] filesArray = parentFile.listFiles();
            if (filesArray != null) {
                List<File> files = this.getVersionnableSortedFiles(filesArray);
                count = files.size();
            }
        }
        return count;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int index;
        if (parent == this.vcsList) {
            index = this.vcsList.indexOf(child);
        } else if (parent instanceof VCS) {
            index = this.rootFiles.get(parent).indexOf(child);
        } else {
            File parentFile = (File)parent;
            File[] filesArray = parentFile.listFiles();
            List<File> files = this.getVersionnableSortedFiles(filesArray);
            index = files.indexOf(child);
        }
        return index;
    }

    @Override
    public Object getRoot() {
        return this.vcsList;
    }

    @Override
    public boolean isLeaf(Object node) {
        boolean result = false;
        if (node instanceof File) {
            result = ((File)node).isFile();
        }
        return result;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.modelSupport.removeTreeModelListener(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    protected List<File> getVersionnableSortedFiles(File[] filesArray) {
        ArrayList<File> files = new ArrayList<File>();
        for (File fileArray : filesArray) {
            if (IsisFish.vcs.isVersionnableFile(fileArray)) {
                files.add(fileArray);
                continue;
            }
            if (!IsisFish.communityVcs.isVersionnableFile(fileArray)) continue;
            files.add(fileArray);
        }
        Collections.sort(files);
        return files;
    }

    public void fileAdded(File file) {
        TreePath path = new TreePath(this.getRoot());
        this.updateChildren(file, path, 0);
    }

    public void fileModified(File file) {
        TreePath path = new TreePath(this.getRoot());
        this.updateChildren(file, path, 1);
    }

    public void fileDeleted(File file) {
        TreePath path = new TreePath(this.getRoot());
        this.updateChildren(file, path, 2);
    }

    protected boolean updateChildren(File file, TreePath path, int operation) {
        Object pathLastComponent = path.getLastPathComponent();
        boolean updated = false;
        int childCount = this.getChildCount(pathLastComponent);
        for (int childIndex = 0; !updated && childIndex < childCount; ++childIndex) {
            Object child = this.getChild(pathLastComponent, childIndex);
            TreePath childTreePath = path.pathByAddingChild(child);
            if (file.equals(child)) {
                switch (operation) {
                    case 0: {
                        this.modelSupport.fireChildAdded(path, childIndex, child);
                        break;
                    }
                    case 2: {
                        this.modelSupport.fireChildRemoved(path, childIndex, child);
                        break;
                    }
                    case 1: {
                        this.modelSupport.fireChildChanged(path, childIndex, child);
                        break;
                    }
                    default: {
                        if (!log.isErrorEnabled()) break;
                        log.error((Object)("Unknow operation : " + operation));
                    }
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)(" updated : " + childTreePath));
                }
                updated = true;
                continue;
            }
            updated = this.updateChildren(file, childTreePath, operation);
            if (!updated) continue;
            this.modelSupport.firePathChanged(path);
        }
        return updated;
    }

    public TreePath getTreePathFor(File file) {
        TreePath path = new TreePath(this.vcsList);
        path = this.getRecursiveTreePath(file, path);
        return path;
    }

    protected TreePath getRecursiveTreePath(File file, TreePath path) {
        Object pathLastComponent = path.getLastPathComponent();
        TreePath resultTreePath = null;
        int childCount = this.getChildCount(pathLastComponent);
        for (int childIndex = 0; resultTreePath == null && childIndex < childCount; ++childIndex) {
            Object child = this.getChild(pathLastComponent, childIndex);
            TreePath childTreePath = path.pathByAddingChild(child);
            resultTreePath = file.equals(child) ? childTreePath : this.getRecursiveTreePath(file, childTreePath);
        }
        return resultTreePath;
    }
}

