/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.keystore;

import fr.ifremer.isisfish.util.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import jaxx.runtime.SwingUtil;
import org.nuiton.i18n.I18n;

public class PasswordUI
extends JDialog
implements WindowListener {
    protected JLabel accountLabel;
    protected JPasswordField accountPassword;
    protected JCheckBox rememberPassword;
    protected boolean canceled;

    public PasswordUI(Frame owner) {
        super(owner, true);
        this.setTitle(I18n.t((String)"isisfish.ui.keystore.title", (Object[])new Object[0]));
        this.buildUI();
        this.setResizable(false);
        UIUtil.setIconImage(this);
        this.addWindowListener(this);
    }

    protected void buildUI() {
        this.setLayout(new GridBagLayout());
        this.setMinimumSize(new Dimension(400, 0));
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(SwingUtil.createIcon((String)"/icons/fatcow/key.png"));
        this.add((Component)iconLabel, new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 11, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.accountLabel = new JLabel();
        this.add((Component)this.accountLabel, new GridBagConstraints(1, 0, 2, 1, 1.0, 1.0, 11, 2, new Insets(10, 3, 3, 10), 0, 0));
        this.accountPassword = new JPasswordField();
        this.add((Component)this.accountPassword, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 11, 2, new Insets(3, 3, 3, 10), 0, 0));
        this.rememberPassword = new JCheckBox();
        this.add((Component)this.rememberPassword, new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 11, 2, new Insets(3, 3, 10, 10), 0, 0));
        JButton okButton = new JButton();
        okButton.addActionListener(e -> this.dispose());
        okButton.setText(I18n.t((String)"isisfish.common.ok", (Object[])new Object[0]));
        this.add((Component)okButton, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        JButton cancelButton = new JButton();
        cancelButton.addActionListener(e -> this.cancel());
        cancelButton.setText(I18n.t((String)"isisfish.common.cancel", (Object[])new Object[0]));
        this.add((Component)cancelButton, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
    }

    public String getPassword(String info) {
        this.canceled = false;
        if (info.contains("@")) {
            this.accountLabel.setText(I18n.t((String)"isisfish.ui.keystore.question", (Object[])new Object[]{info}));
            this.rememberPassword.setText(I18n.t((String)"isisfish.ui.keystore.rememberPassword", (Object[])new Object[0]));
        } else {
            this.accountLabel.setText(I18n.t((String)"isisfish.ui.keystore.askPassphrase", (Object[])new Object[]{info}));
            this.rememberPassword.setText(I18n.t((String)"isisfish.ui.keystore.rememberPassphrase", (Object[])new Object[0]));
        }
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        String password = null;
        if (!this.canceled) {
            password = new String(this.accountPassword.getPassword());
        }
        return password;
    }

    public boolean isRememberPassword() {
        return this.rememberPassword.isSelected();
    }

    protected void cancel() {
        this.canceled = true;
        this.dispose();
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.cancel();
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

