/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.population;

import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.input.population.PopulationSeasonSpacializedUI;
import fr.ifremer.isisfish.ui.input.population.PopulationSeasonsHandler;
import fr.ifremer.isisfish.util.ErrorHelper;
import javax.swing.JOptionPane;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;

public class PopulationSeasonSpacializedHandler
extends InputContentHandler<PopulationSeasonSpacializedUI> {
    private static final Log log = LogFactory.getLog(PopulationSeasonsHandler.class);

    protected PopulationSeasonSpacializedHandler(PopulationSeasonSpacializedUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
    }

    protected void populationSeasonLengthMatrixChanged(MatrixPanelEvent event) {
        if (((PopulationSeasonSpacializedUI)this.inputContentUI).getPopulationSeasonInfo() != null && ((PopulationSeasonSpacializedUI)this.inputContentUI).matrixPanelPopulationSeasonLengthChange.getMatrix() != null) {
            MatrixND lengthChangeMatrix = ((PopulationSeasonSpacializedUI)this.inputContentUI).matrixPanelPopulationSeasonLengthChange.getMatrix().copy();
            ((PopulationSeasonSpacializedUI)this.inputContentUI).getPopulationSeasonInfo().setLengthChangeMatrix(lengthChangeMatrix);
        }
    }

    protected void spacializedActionPerformed() {
        PopulationSeasonInfo popInfo = ((PopulationSeasonSpacializedUI)this.inputContentUI).getPopulationSeasonInfo();
        boolean spacializedSelection = ((PopulationSeasonSpacializedUI)this.inputContentUI).radioPopulationSeasonGroupChangeLengthNoSpacialized.isSelected();
        popInfo.setSimpleLengthChangeMatrix(spacializedSelection);
        try {
            MatrixND lengthChangeMatrix = popInfo.getLengthChangeMatrix();
            if (lengthChangeMatrix != null) {
                lengthChangeMatrix = popInfo.isSimpleLengthChangeMatrix() ? popInfo.unspacializeLengthChangeMatrix(lengthChangeMatrix) : popInfo.spacializeLengthChangeMatrix(lengthChangeMatrix);
                popInfo.setLengthChangeMatrix(lengthChangeMatrix);
                ((PopulationSeasonSpacializedUI)this.inputContentUI).matrixPanelPopulationSeasonLengthChange.setMatrix(lengthChangeMatrix);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't (un)spacialize Matrix Change Of Group", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.spacializematrix", (Object[])new Object[0]), eee);
        }
    }

    protected void computeMatrixChangeOfGroup() {
        PopulationSeasonInfo popInfo = ((PopulationSeasonSpacializedUI)this.inputContentUI).getPopulationSeasonInfo();
        MatrixND lengthChangeMatrix = popInfo.computeLengthChangeMatrix();
        if (!popInfo.isSimpleLengthChangeMatrix()) {
            lengthChangeMatrix = popInfo.spacializeLengthChangeMatrix(lengthChangeMatrix);
        }
        popInfo.setLengthChangeMatrix(lengthChangeMatrix);
    }

    protected void showSpacializedMatrixChangeOfGroup() {
        PopulationSeasonInfo popInfo = ((PopulationSeasonSpacializedUI)this.inputContentUI).getPopulationSeasonInfo();
        MatrixND lengthChangeMatrix = popInfo.getLengthChangeMatrix();
        if (popInfo.isSimpleLengthChangeMatrix()) {
            lengthChangeMatrix = popInfo.spacializeLengthChangeMatrix(lengthChangeMatrix);
        }
        MatrixPanelEditor panel = new MatrixPanelEditor(false, 800, 300);
        panel.setMatrix(lengthChangeMatrix);
        JOptionPane.showMessageDialog(this.inputContentUI, panel, I18n.t((String)"isisfish.populationSeasons.spacialized.visualisation", (Object[])new Object[0]), 1);
    }
}

