/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.equation;

import fr.ifremer.isisfish.ui.input.equation.EquationEditorPaneUI;
import fr.ifremer.isisfish.util.CompileHelper;
import fr.ifremer.isisfish.util.EvaluatorHelper;
import fr.ifremer.isisfish.util.IsisFileUtil;
import java.awt.Color;
import java.awt.Desktop;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLFrameHyperlinkEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EquationEditorPaneHandler {
    private static final Log log = LogFactory.getLog(EquationEditorPaneHandler.class);
    protected EquationEditorPaneUI equationUI;
    protected Class javaInterface = null;

    public EquationEditorPaneHandler(EquationEditorPaneUI equationUI) {
        this.equationUI = equationUI;
    }

    protected void afterInit() {
        this.equationUI.split.setDividerLocation(0.8);
    }

    public void setEquation(String category, String name, Class javaInterface, String content) throws Exception {
        this.javaInterface = javaInterface;
        this.equationUI.getDoc().setText(CompileHelper.extractDoc(category, name, javaInterface));
        this.equationUI.getEditor().open(IsisFileUtil.getTempFile(content, ".java"));
    }

    public void docEditorHyperlinkUpdate(HyperlinkEvent e) {
        block7: {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                if (e instanceof HTMLFrameHyperlinkEvent) {
                    ((HTMLDocument)this.equationUI.doc.getDocument()).processHTMLFrameHyperlinkEvent((HTMLFrameHyperlinkEvent)e);
                } else {
                    try {
                        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                            Desktop.getDesktop().browse(e.getURL().toURI());
                        } else {
                            this.equationUI.doc.setPage(e.getURL());
                        }
                    }
                    catch (Exception ex) {
                        if (!log.isErrorEnabled()) break block7;
                        log.error((Object)("Error for : " + e.getURL()), (Throwable)ex);
                    }
                }
            }
        }
    }

    public void check() {
        try {
            int compileResult;
            String content = this.equationUI.editor.getText();
            StringWriter result = new StringWriter();
            PrintWriter out = new PrintWriter(result);
            try {
                compileResult = EvaluatorHelper.check(this.javaInterface, content, out);
            }
            catch (Exception eee) {
                compileResult = -1;
            }
            out.flush();
            if (compileResult != 0) {
                this.equationUI.checkWindow.setText(result.toString());
                this.equationUI.checkWindow.setBackground(Color.RED);
            } else {
                this.equationUI.checkWindow.setText("Compilation Ok");
                this.equationUI.checkWindow.setBackground(Color.WHITE);
            }
        }
        catch (Exception e) {
            log.error((Object)"Can't check script", (Throwable)e);
        }
    }
}

