/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.CommonHandler;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.input.InputUI;
import fr.ifremer.isisfish.ui.sensitivity.wizard.FactorWizardHandler;
import fr.ifremer.isisfish.ui.sensitivity.wizard.FactorWizardUI;
import fr.ifremer.isisfish.util.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.BlockingLayerUI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.jxlayer.plaf.LayerUI;
import org.nuiton.topia.persistence.TopiaEntityContextable;

public abstract class InputContentHandler<T extends InputContentUI<? extends TopiaEntityContextable>>
extends CommonHandler
implements PropertyChangeListener {
    private static final Log log = LogFactory.getLog(InputContentHandler.class);
    protected T inputContentUI;
    protected JButton nextButton;

    protected InputContentHandler(T inputContentUI) {
        this.inputContentUI = inputContentUI;
        ((Container)this.inputContentUI).addPropertyChangeListener(this);
    }

    public void accept(InputContentUI<?> inputContentUI, ActionEvent e) {
        JComponent source = (JComponent)e.getSource();
        Class sensitivityBeanClass = (Class)source.getClientProperty("sensitivityBean");
        String sensitivityBeanID = (String)source.getClientProperty("sensitivityBeanID");
        String sensitivityMethod = (String)source.getClientProperty("sensitivityMethod");
        if (log.isDebugEnabled()) {
            log.debug((Object)("Event intercepted " + source));
            log.debug((Object)(" client property (bean) : " + sensitivityBeanClass));
            log.debug((Object)(" client property (beanID) : " + sensitivityBeanID));
            log.debug((Object)(" client property (method) : " + sensitivityMethod));
        }
        this.displayFactorWizard(inputContentUI, sensitivityBeanClass, sensitivityBeanID, sensitivityMethod);
    }

    public void displayFactorWizard(InputContentUI<?> inputContentUI, Class<? extends TopiaEntityContextable> sensitivityBeanClass, String sensitivityBeanID, String sensitivityMethod) {
        TopiaEntityContextable bean = sensitivityBeanID == null ? inputContentUI.getSaveVerifier().getEntity(sensitivityBeanClass) : inputContentUI.getSaveVerifier().getEntity(sensitivityBeanClass, sensitivityBeanID);
        if (bean != null) {
            FactorWizardUI factorWizardUI = new FactorWizardUI((JAXXContext)inputContentUI);
            FactorWizardHandler handler = factorWizardUI.getHandler();
            handler.initNewFactor(factorWizardUI, bean, sensitivityMethod);
            factorWizardUI.pack();
            factorWizardUI.setLocationRelativeTo(inputContentUI);
            UIUtil.setIconImage(factorWizardUI);
            factorWizardUI.setVisible(true);
        } else if (log.isErrorEnabled()) {
            log.error((Object)("Can't find bean in current verifier (sensitivityBeanClass = " + sensitivityBeanClass + ", sensitivityBeanID = " + sensitivityBeanID + ")"));
        }
    }

    protected void setupGotoNextPath(String nextTitle, String nextPath) {
        this.nextButton = new JButton(nextTitle);
        this.nextButton.addActionListener(e -> this.goTo(nextPath));
        this.nextButton.setIcon(SwingUtil.createImageIcon((String)"fatcow/page_white_go.png"));
        ((Container)this.inputContentUI).add((Component)SwingUtil.boxComponentWithJxLayer((JComponent)this.nextButton), "South");
    }

    protected void goTo(String nextPath) {
        InputUI inputUI = ((InputContentUI)this.inputContentUI).getParentContainer(InputUI.class);
        if (inputUI != null) {
            inputUI.getHandler().setTreeSelection((InputContentUI<?>)this.inputContentUI, nextPath);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (this.nextButton != null && evt.getPropertyName().equals("sensitivity") && ((Boolean)evt.getNewValue()).booleanValue()) {
            BlockingLayerUI clone = ((InputContentUI)this.inputContentUI).getLayerUI().clone();
            clone.setBlock(true);
            SwingUtil.getLayer((JComponent)this.nextButton).setUI((LayerUI)clone);
        }
    }
}

