/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.sensitivity.domain;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.simulator.sensitivity.Distribution;
import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.visitor.DomainVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;

public class ContinuousDomain
implements Domain {
    private static Log log = LogFactory.getLog(ContinuousDomain.class);
    private static final long serialVersionUID = -2037768174807839046L;
    protected Distribution distribution;
    protected Map<String, Object> distributionParameters = new HashMap<String, Object>();

    public ContinuousDomain() {
    }

    public ContinuousDomain(Distribution distribution) {
        this();
        this.distribution = distribution;
    }

    public ContinuousDomain(Distribution distribution, SortedMap<String, Object> distributionParameters) {
        this(distribution);
        this.setDistributionParams(distributionParameters);
    }

    public Distribution getDistribution() {
        return this.distribution;
    }

    public Map<String, Object> getDistributionParameters() {
        return this.distributionParameters;
    }

    public Object getDistributionParameter(String name) {
        return this.distributionParameters.get(name);
    }

    public void setDistributionParams(SortedMap<String, Object> distributionParameters) {
        distributionParameters.clear();
        this.addDistributionParams(distributionParameters);
    }

    public void addDistributionParams(SortedMap<String, Object> distributionParameters) {
        for (Map.Entry<String, Object> entry : distributionParameters.entrySet()) {
            this.addDistributionParam(entry.getKey(), entry.getValue());
        }
    }

    public void addDistributionParam(String name, Object value) {
        Distribution.DistributionParam[] defDistribParams;
        if (this.distribution == null) {
            throw new IllegalStateException("Distribution not set");
        }
        boolean found = false;
        for (Distribution.DistributionParam defDistribParam : defDistribParams = this.distribution.getDistibutionParams()) {
            if (!defDistribParam.getName().equals(name)) continue;
            found = true;
            break;
        }
        if (!found) {
            throw new IllegalArgumentException(String.format("Wrong parameter name, %s not supported by distribution", name));
        }
        this.distributionParameters.put(name, value);
    }

    @Override
    public Object getValueForIdentifier(Object identifier) {
        Object reference;
        Object result;
        block8: {
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(identifier);
            if (this.distribution == Distribution.QUNIFPC) {
                Object object = this.distributionParameters.get(Distribution.QUNIFPC.getDistibutionParams()[0].getName());
                double coef = (Double)this.distributionParameters.get(Distribution.QUNIFPC.getDistibutionParams()[1].getName());
                if (object instanceof MatrixND) {
                    args.add(1.0 - coef);
                    args.add(1.0 + coef);
                } else {
                    double ref = (Double)object;
                    args.add(ref - coef * Math.abs(ref));
                    args.add(ref + coef * Math.abs(ref));
                }
            } else {
                for (Distribution.DistributionParam param : this.distribution.getDistibutionParams()) {
                    String name = param.getName();
                    Object value = this.distributionParameters.get(name);
                    args.add(value);
                }
            }
            args.add(true);
            args.add(false);
            Class clazz = this.distribution.getDistClass();
            result = null;
            try {
                result = MethodUtils.invokeStaticMethod((Class)clazz, (String)"quantile", (Object[])args.toArray());
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) break block8;
                log.error((Object)("Can't invoke quantile method : args was " + args), (Throwable)ex);
            }
        }
        if (this.distribution == Distribution.QUNIFPC && (reference = this.distributionParameters.get(Distribution.QUNIFPC.getDistibutionParams()[0].getName())) instanceof MatrixND) {
            MatrixND ref = ((MatrixND)reference).copy();
            result = ref.mults(((Double)result).doubleValue());
        }
        return result;
    }

    @Override
    public void accept(DomainVisitor visitor) {
        visitor.start(this);
        visitor.end(this);
    }

    @Override
    public ContinuousDomain clone() {
        ContinuousDomain cloned;
        try {
            cloned = (ContinuousDomain)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IsisFishRuntimeException("Can't clone domain", e);
        }
        return cloned;
    }
}

