/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.sensitivity;

import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.rule.RuleHelper;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.simulator.sensitivity.Scenario;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationDiscreteDomain;
import fr.ifremer.isisfish.util.converter.ConverterUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;

public class FactorHelper {
    private static final Log log = LogFactory.getLog(FactorHelper.class);

    public static String generatePreScript(Scenario scenario) {
        return FactorHelper.generatePreScript(scenario.getFactors());
    }

    public static String generatePreScript(Collection<Factor> factors) {
        ConvertUtilsBean beanUtils = ConverterUtil.getConverter(null);
        StringBuffer buffer = new StringBuffer();
        buffer.append("import org.apache.commons.beanutils.BeanUtils;\n");
        buffer.append("import org.apache.commons.beanutils.ConvertUtilsBean;\n");
        buffer.append("import " + ConverterUtil.class.getName() + ";\n");
        buffer.append("import " + SimulationParameter.class.getName() + ";\n");
        buffer.append("import org.nuiton.topia.persistence.TopiaEntity;\n");
        buffer.append("ConvertUtilsBean beanUtils = ConverterUtil.getConverter(db);\n");
        buffer.append("SimulationParameter params = context.getSimulationStorage().getParameter();\n");
        FactorHelper.generatePreScript(beanUtils, buffer, new AtomicInteger(), factors);
        String scriptContent = buffer.toString();
        if (log.isTraceEnabled()) {
            log.trace((Object)("Simulation prescript content = " + scriptContent));
        }
        return scriptContent;
    }

    protected static void generatePreScript(ConvertUtilsBean beanUtils, StringBuffer buffer, AtomicInteger counter, Collection<Factor> factors) {
        for (Factor factor : factors) {
            if (factor instanceof FactorGroup) {
                buffer.append("/* factor group : ").append(factor.getName()).append(" */\n");
                FactorGroup factorGroup = (FactorGroup)factor;
                FactorHelper.generatePreScript(beanUtils, buffer, counter, factorGroup.getFactors());
            } else {
                int factorIndex = counter.get();
                buffer.append("/* factor : ").append(factor.getName()).append(" */\n");
                if (factor.getPath().matches("parameters.population\\.\\w+\\.number")) {
                    String paramName = StringUtils.removeStart((String)factor.getPath(), (String)"parameters.");
                    MatrixND matrix = (MatrixND)factor.getValue();
                    String stringValue = String.valueOf(matrix.toList());
                    buffer.append("params.setProperty(\"").append(paramName).append("\",\"").append((Object)stringValue).append("\");\n");
                } else if (factor.getPath().equals("parameters.rules")) {
                    List rules = (List)factor.getValue();
                    ArrayList<String> rulesNames = new ArrayList<String>();
                    int ruleIndex = 0;
                    for (Rule rule : rules) {
                        rulesNames.add(rule.getClass().getSimpleName());
                        Properties rulesProps = RuleHelper.getRuleAsProperties(ruleIndex++, null, rule);
                        for (String rulesProp : rulesProps.stringPropertyNames()) {
                            String value = rulesProps.getProperty(rulesProp);
                            buffer.append("params.setProperty(\"").append(rulesProp).append("\",\"").append(value).append("\");\n");
                        }
                    }
                    buffer.append("params.setProperty(\"rules\",\"").append(StringUtils.join(rulesNames, (String)",")).append("\");\n");
                } else if (factor.getPath().startsWith("parameters.rule.")) {
                    Pattern pattern = Pattern.compile("^parameters\\.(rule\\.\\d+\\.parameter\\.\\w+)(\\..+)?$");
                    Matcher matcher = pattern.matcher(factor.getPath());
                    String paramName = matcher.matches() ? matcher.group(1) : StringUtils.removeStart((String)factor.getPath(), (String)"parameters.");
                    String stringValue = ConvertUtils.convert((Object)factor.getValue());
                    buffer.append("params.setProperty(\"").append(paramName).append("\",\"").append(stringValue).append("\");\n");
                } else if (StringUtils.isNotBlank((CharSequence)factor.getEquationVariableName())) {
                    buffer.append("context.setComputeValue(\"").append(factor.getName() + "." + factor.getEquationVariableName());
                    buffer.append("\",").append(factor.getValue()).append(");\n");
                } else {
                    String stringValue;
                    Object value = factor.getValue();
                    String escValue = stringValue = beanUtils.convert(value);
                    if (factor.getDomain() instanceof EquationDiscreteDomain) {
                        escValue = StringUtils.replace((String)escValue, (String)"\n", (String)"");
                        escValue = StringUtils.replace((String)escValue, (String)"\r", (String)"");
                        escValue = StringUtils.replace((String)escValue, (String)"\"", (String)"\\\"");
                    }
                    String path = factor.getPath();
                    String topiaId = path.substring(0, path.lastIndexOf(35));
                    String property = path.substring(path.lastIndexOf(35) + 1);
                    buffer.append(value.getClass().getName()).append(" value");
                    buffer.append(factorIndex).append(" = (").append(value.getClass().getName()).append(")beanUtils.convert(\"");
                    buffer.append(escValue).append("\", ").append(value.getClass().getName());
                    buffer.append(".class);\n");
                    buffer.append("TopiaEntity entity").append(factorIndex);
                    buffer.append(" = db.findByTopiaId(\"").append(topiaId);
                    buffer.append("\");\n");
                    if (factor.getDomain() instanceof EquationDiscreteDomain) {
                        buffer.append("BeanUtils.setProperty(entity").append(factorIndex);
                        buffer.append(", \"").append(property).append("Content\", ");
                        buffer.append("value").append(factorIndex).append(");\n");
                    } else {
                        buffer.append("BeanUtils.setProperty(entity").append(factorIndex);
                        buffer.append(", \"").append(property).append("\", ");
                        buffer.append("value").append(factorIndex).append(");\n");
                    }
                }
            }
            counter.incrementAndGet();
        }
    }
}

