/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.sensitivity;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.simulator.sensitivity.DesignPlan;
import fr.ifremer.isisfish.simulator.sensitivity.Distribution;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.FactorGroup;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityAnalysis;
import fr.ifremer.isisfish.simulator.sensitivity.SensitivityException;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.DiscreteDomain;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.j2r.REngine;
import org.nuiton.j2r.RException;
import org.nuiton.j2r.RProxy;
import org.nuiton.math.matrix.MatrixND;

public abstract class AbstractSensitivityAnalysis
implements SensitivityAnalysis {
    private static Log log = LogFactory.getLog(AbstractSensitivityAnalysis.class);

    public void setIsisFactorsR(DesignPlan plan, File outputdirectory) throws SensitivityException {
        String nomFacteur = "nomFacteur<-c(%s)";
        String factorNames = "";
        String nominal = "Nominal<-c(%s)";
        String nominalValues = "";
        String continu = "Continu<-c(%s)";
        String continuValues = "";
        String binf = "Binf<-c(%s)";
        String binfValues = "";
        String bsup = "Bsup<-c(%s)";
        String bsupValues = "";
        String attribute = "attr(isis.factors,\"%s\")<-\"%s\"";
        String isisfactors = "isis.factors<-data.frame(\"nomFacteur\"=nomFacteur,\"Nominal\"=Nominal,\"Continu\"=Continu,\"Binf\"=Binf,\"Bsup\"=Bsup)";
        List<Factor> factors = plan.getFactors();
        for (Factor factor : factors) {
            if (!(factor instanceof FactorGroup) || !((FactorGroup)factor).isDiscrete()) continue;
            List<Factor> subfactors = ((FactorGroup)factor).getFactors();
            int cardinality = subfactors.get(0).getCardinality();
            for (Factor subfactor : subfactors) {
                if (subfactor.getCardinality() == cardinality) continue;
                throw new SensitivityException("All the factors of group " + factor.getName() + " do not have the same cardinality");
            }
        }
        for (int i = 0; i < factors.size(); ++i) {
            Factor factor;
            factor = factors.get(i);
            if (i != 0) {
                factorNames = factorNames + ",";
                nominalValues = nominalValues + ",";
                continuValues = continuValues + ",";
                binfValues = binfValues + ",";
                bsupValues = bsupValues + ",";
            }
            factorNames = factorNames + "\"" + factor.getName() + "\"";
            if (factor.getDomain() instanceof ContinuousDomain) {
                nominalValues = nominalValues + "\"" + factor.getNominalValue() + "\"";
                continuValues = continuValues + "TRUE";
                binfValues = binfValues + "0.0";
                bsupValues = bsupValues + "0.0";
                continue;
            }
            nominalValues = nominalValues + "\"" + factor.getNominalValue() + "\"";
            continuValues = continuValues + "FALSE";
            binfValues = binfValues + "0.0";
            bsupValues = bsupValues + ((DiscreteDomain)factor.getDomain()).getValues().size();
        }
        try {
            RProxy engine = new RProxy();
            engine.clearSession();
            String Rcall = String.format(nomFacteur, factorNames);
            engine.voidEval(Rcall);
            Rcall = String.format(nominal, nominalValues);
            engine.voidEval(Rcall);
            Rcall = String.format(continu, continuValues);
            engine.voidEval(Rcall);
            Rcall = String.format(binf, binfValues);
            engine.voidEval(Rcall);
            Rcall = String.format(bsup, bsupValues);
            engine.voidEval(Rcall);
            engine.voidEval(isisfactors);
            Rcall = String.format(attribute, "nomModel", "isis-fish-externeR");
            engine.voidEval(Rcall);
            for (Factor factor : factors) {
                if (!(factor.getDomain() instanceof DiscreteDomain)) continue;
                String attributeValues = "list(";
                Collection<Object> values = ((DiscreteDomain)factor.getDomain()).getValues().values();
                for (Object j : values) {
                    attributeValues = attributeValues + j + ",";
                }
                attributeValues = attributeValues.substring(0, attributeValues.length() - 1);
                attributeValues = attributeValues + ")";
                Rcall = String.format(attribute, factor.getName(), attributeValues);
                engine.voidEval(Rcall);
            }
            engine.saveRData(outputdirectory.getParentFile(), outputdirectory.getName());
        }
        catch (RException eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"R evaluation failed", (Throwable)eee);
            }
            throw new SensitivityException("R evaluation failed", eee);
        }
    }

    protected REngine openEngine(File outputDirectory) throws RException {
        RProxy engine = new RProxy();
        engine.clearSession();
        String sensitivityAnalysisName = outputDirectory.getName();
        engine.loadRData(outputDirectory.getParentFile(), sensitivityAnalysisName);
        String prefixName = sensitivityAnalysisName.replaceAll("-", "");
        String renameIsisSimule = "if (exists(\"%1$s.isis.simule\")) isis.simule<-%1$s.isis.simule";
        String renameIsisFactorDistribution = "if (exists(\"%1$s.isis.factor.distribution\")) isis.factor.distribution<-%1$s.isis.factor.distribution";
        String renameIsisFactor = "if (exists(\"%1$s.isis.factors\")) isis.factors<-%1$s.isis.factors";
        String renameIsisMethodExp = "if (exists(\"%1$s.isis.methodExp\")) isis.methodExp<-%1$s.isis.methodExp";
        String renameIsisMethodAnalyse = "if (exists(\"%1$s.isis.methodAnalyse\")) isis.methodAnalyse<-%1$s.isis.methodAnalyse";
        engine.voidEval(String.format(renameIsisSimule, prefixName));
        engine.voidEval(String.format(renameIsisFactorDistribution, prefixName));
        engine.voidEval(String.format(renameIsisFactor, prefixName));
        engine.voidEval(String.format(renameIsisMethodExp, prefixName));
        engine.voidEval(String.format(renameIsisMethodAnalyse, prefixName));
        return engine;
    }

    protected void closeEngine(REngine engine, File outputDirectory) throws RException {
        String sensitivityAnalysisName = outputDirectory.getName();
        String prefixName = sensitivityAnalysisName.replaceAll("-", "");
        String renameIsisSimule = "%s.isis.simule<-isis.simule";
        String renameIsisFactorDistribution = "%s.isis.factor.distribution<-isis.factor.distribution";
        String renameIsisFactor = "%s.isis.factors<-isis.factors";
        String renameIsisMethodExp = "%s.isis.methodExp<-isis.methodExp";
        String renameIsisMethodAnalyse = "%s.isis.methodAnalyse<-isis.methodAnalyse";
        engine.voidEval(String.format(renameIsisSimule, prefixName));
        engine.voidEval(String.format(renameIsisFactorDistribution, prefixName));
        engine.voidEval(String.format(renameIsisFactor, prefixName));
        engine.voidEval(String.format(renameIsisMethodExp, prefixName));
        engine.voidEval(String.format(renameIsisMethodAnalyse, prefixName));
        for (String object : engine.ls()) {
            if (object.startsWith(prefixName)) continue;
            engine.remove(object);
        }
        engine.saveRData(outputDirectory.getParentFile(), sensitivityAnalysisName);
        engine.terminate();
    }

    protected String editRInstruction(String rCall) {
        JLabel label = new JLabel(I18n.t((String)"Modifier le code R envoy\u00e9 si vous le souhaitez", (Object[])new Object[0]));
        JTextPane text = new JTextPane();
        text.setText(rCall);
        text.setSize(400, 400);
        text.setPreferredSize(text.getSize());
        Box box = Box.createVerticalBox();
        box.add(label);
        box.add(new JScrollPane(text));
        JOptionPane.showMessageDialog(null, box, I18n.t((String)"R modif", (Object[])new Object[0]), 3);
        return text.getText();
    }

    protected void checkAllFactorContinuous(List<Factor> factors) throws SensitivityException {
        for (Factor factor : factors) {
            if (!(factor.getDomain() instanceof DiscreteDomain)) continue;
            throw new SensitivityException(I18n.t((String)"%s has a discrete domain, this is not acceptable for this method.", (Object[])new Object[]{factor.getName()}));
        }
    }

    protected void checkAllUniformDistribution(List<Factor> factors) throws SensitivityException {
        for (Factor factor : factors) {
            if (factor.getDomain() instanceof ContinuousDomain) {
                ContinuousDomain domain = (ContinuousDomain)factor.getDomain();
                Distribution distribution = domain.getDistribution();
                if (distribution == Distribution.QUNIFPC || distribution == Distribution.QUNIFMM) continue;
                throw new SensitivityException(I18n.t((String)"%s has a non uniform distribution, this is not acceptable for this method.", (Object[])new Object[]{factor.getName()}));
            }
            throw new SensitivityException(I18n.t((String)"%s has a discrete domain, this is not acceptable for this method.", (Object[])new Object[]{factor.getName()}));
        }
    }

    protected String createImportInstruction(SensitivityExport export, List<SimulationStorage> simulationStorages) {
        String name = export.getExportFilename();
        String extension = export.getExtensionFilename();
        String rInstruction = name + "<-c(";
        for (int l = 0; l < simulationStorages.size(); ++l) {
            SimulationStorage simulationStorage = simulationStorages.get(l);
            File directory = simulationStorage.getDirectory();
            String directoryPath = directory.toString() + File.separator + "resultExports";
            File importFile = new File(directoryPath, name + extension);
            String simulResult = "";
            try {
                simulResult = FileUtils.readFileToString((File)importFile, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException ioe) {
                log.error((Object)"An error occured trying to read a result file : ", (Throwable)ioe);
            }
            double simulationResult = Double.parseDouble(simulResult);
            rInstruction = l < simulationStorages.size() - 1 ? rInstruction + simulationResult + "," : rInstruction + simulationResult;
        }
        rInstruction = rInstruction + ")";
        return rInstruction;
    }

    protected double getMinBound(Factor factor) {
        return this.getBound(factor, true);
    }

    protected double getMaxBound(Factor factor) {
        return this.getBound(factor, false);
    }

    protected double getBound(Factor factor, boolean min) {
        ContinuousDomain domain = (ContinuousDomain)factor.getDomain();
        Distribution distribution = domain.getDistribution();
        double result = 0.0;
        if (distribution == Distribution.QUNIFPC) {
            Object reference = domain.getDistributionParameter(Distribution.QUNIFPC.getDistibutionParams()[0].getName());
            if (reference instanceof MatrixND) {
                result = min ? 0.0 : 1.0;
            } else {
                Double coefficient = (Double)domain.getDistributionParameter(Distribution.QUNIFPC.getDistibutionParams()[1].getName());
                result = min ? (Double)reference - (Double)reference * coefficient : (Double)reference + (Double)reference * coefficient;
            }
        } else if (distribution == Distribution.QUNIFMM) {
            Object value = domain.getDistributionParameter(Distribution.QUNIFMM.getDistibutionParams()[min ? 0 : 1].getName());
            result = value instanceof MatrixND ? (min ? 0.0 : 1.0) : (Double)value;
        } else if (log.isWarnEnabled()) {
            log.warn((Object)("Can't call getBound for distribution " + (Object)((Object)distribution)));
        }
        return result;
    }

    protected String getIsisFactorDistribution(List<Factor> factors) {
        String isisFactorDistribution = "isis.factor.distribution<-data.frame(NomFacteur=c(%s),NomDistribution=c(%s),ParametreDistribution=c(%s))";
        String distribution = "";
        String parameters = "";
        String factorNames = "";
        for (int i = 0; i < factors.size(); ++i) {
            Factor factor = factors.get(i);
            ContinuousDomain domain = (ContinuousDomain)factor.getDomain();
            if (i != 0) {
                distribution = distribution + ",";
                parameters = parameters + ",";
                factorNames = factorNames + ",";
            }
            Distribution r_distribution = domain.getDistribution();
            distribution = distribution + "\"" + r_distribution.getInstruction() + "\"";
            parameters = parameters + "\"[";
            for (Map.Entry<String, Object> param : domain.getDistributionParameters().entrySet()) {
                parameters = parameters + param.getKey() + "=" + param.getValue() + ";";
            }
            parameters = StringUtils.removeEnd((String)parameters, (String)";");
            parameters = parameters + "]\"";
            factorNames = factorNames + "\"" + factor.getName() + "\"";
        }
        return String.format(isisFactorDistribution, factorNames, distribution, parameters);
    }
}

