/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.datastore.SimulationStorage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SimulationProperties {
    private static final Log log = LogFactory.getLog(SimulationProperties.class);
    protected String name;
    protected Properties data;

    public SimulationProperties(String name) throws IOException {
        File simulationDirectory = SimulationStorage.getSimulationDirectory(name);
        this.name = simulationDirectory.getName();
        this.data = new Properties();
        this.data.put("simulationName", this.name);
        this.loadProperties(SimulationStorage.getSimulationParametersFile(simulationDirectory));
        this.loadProperties(SimulationStorage.getSimulationInformationFile(simulationDirectory));
    }

    private void loadProperties(File file) {
        block8: {
            if (file.exists()) {
                try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                    this.data.load(reader);
                    this.data.remove("preScript");
                }
                catch (IOException e) {
                    if (!log.isWarnEnabled()) break block8;
                    log.warn((Object)I18n.t((String)"isisfish.error.load.file", (Object[])new Object[]{file}));
                }
            }
        }
    }

    public Properties getData() {
        return this.data;
    }

    public String getName() {
        return this.name;
    }
}

