/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.map;

import com.bbn.openmap.event.MapMouseListener;
import com.bbn.openmap.event.ProjectionEvent;
import com.bbn.openmap.layer.OMGraphicHandlerLayer;
import com.bbn.openmap.omGraphics.OMGraphicList;
import com.bbn.openmap.proj.Projection;
import com.bbn.openmap.proj.coords.LatLonPoint;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.map.Coordinate;
import fr.ifremer.isisfish.map.DataMap;
import fr.ifremer.isisfish.map.DataMapInfo;
import fr.ifremer.isisfish.map.DataMapList;
import fr.ifremer.isisfish.map.DefaultDataMap;
import fr.ifremer.isisfish.map.Motif;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Random;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;

public class ResultatLayer
extends OMGraphicHandlerLayer
implements MapMouseListener {
    private static final long serialVersionUID = 387094105186421164L;
    private static Log log = LogFactory.getLog(ResultatLayer.class);
    protected DataMapList dataMapList = new DataMapList();
    protected JPanel palette = null;
    protected Projection proj = null;
    protected OMGraphicList graphics = new OMGraphicList();

    public void addDataMap(DataMap data) {
        this.dataMapList.addDataMap(data);
        this.generateGraphics();
    }

    public void setDataMapList(DataMapList list) {
        this.dataMapList = list;
        this.generateGraphics();
    }

    public DataMapList getDataMapList() {
        return this.dataMapList;
    }

    public void setMatriceInfo(MatrixND matInfo) {
        DataMapList dml = new DataMapList();
        List vzone = null;
        int position = -1;
        for (int i = 0; i < matInfo.getDimCount(); ++i) {
            List sem = matInfo.getSemantic(i);
            if (sem.size() <= 0 || !(sem.get(0) instanceof Zone)) continue;
            position = i;
            vzone = sem;
            break;
        }
        if (position == -1 || vzone == null || vzone.size() == 0) {
            this.setDataMapList(dml);
            return;
        }
        Vector<float[]> latitude = new Vector<float[]>();
        Vector<float[]> longitude = new Vector<float[]>();
        float pasMailleLatitude = 0.0f;
        float pasMailleLongitude = 0.0f;
        try {
            for (Object aVzone : vzone) {
                Zone sect = (Zone)aVzone;
                List<Cell> cells = sect.getCell();
                float[] lat = new float[cells.size()];
                float[] lon = new float[cells.size()];
                for (int j = 0; j < cells.size(); ++j) {
                    Cell cell = cells.get(j);
                    lat[j] = cell.getLatitude();
                    lon[j] = cell.getLongitude();
                    if (pasMailleLatitude != 0.0f || pasMailleLongitude != 0.0f) continue;
                    pasMailleLatitude = cell.getFisheryRegion().getCellLengthLatitude();
                    pasMailleLongitude = cell.getFisheryRegion().getCellLengthLongitude();
                }
                latitude.add(lat);
                longitude.add(lon);
            }
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Erreur dans la creation du datamaplist", (Throwable)eee);
            }
            this.setDataMapList(dml);
            return;
        }
        for (int i = 0; i < matInfo.getDim(0); ++i) {
            for (int j = 0; j < matInfo.getDim(1); ++j) {
                double elem = matInfo.getValue(i, j);
                DefaultDataMap data = new DefaultDataMap();
                data.setValue(elem);
                String itemx = matInfo.getSemantic(0).get(i).toString();
                String itemy = matInfo.getSemantic(1).get(j).toString();
                if (position == 0) {
                    data.setCoordinates((float[])latitude.get(i), (float[])longitude.get(i));
                    data.setInfo(new DataMapInfo(itemx + " - " + itemy));
                } else {
                    data.setCoordinates((float[])latitude.get(j), (float[])longitude.get(j));
                    data.setInfo(new DataMapInfo(itemy + " - " + itemx));
                }
                dml.addDataMap(data);
            }
        }
        Random ran = new Random(System.currentTimeMillis());
        Color color = new Color(ran.nextInt() & 0xFFFFFF);
        Motif motif = new Motif(color);
        motif.setHeight(pasMailleLatitude);
        motif.setWidth(pasMailleLongitude);
        dml.setMotif(motif);
        this.setDataMapList(dml);
    }

    public void setProjection(Projection proj) {
        this.proj = proj;
    }

    public Projection getProjection() {
        return this.proj;
    }

    public void renderDataForProjection(Projection proj, Graphics g) {
        if (proj == null) {
            return;
        }
        this.generateGraphics();
        this.setProjection(proj.makeClone());
        this.paint(g);
    }

    public void projectionChanged(ProjectionEvent e) {
        this.setProjection(e.getProjection());
        this.repaint();
    }

    protected void generateGraphics() {
        this.graphics = this.dataMapList.createOMGraphicList(this.getProjection());
        this.graphics.generate(this.getProjection());
    }

    public Component getGUI() {
        return this.palette;
    }

    public void paint(Graphics g) {
        this.generateGraphics();
        this.graphics.generate(this.getProjection());
        this.graphics.render(g);
    }

    public void showPalette() {
    }

    public void hidePalette() {
    }

    public String[] getMouseModeServiceList() {
        return new String[]{"Gestures"};
    }

    public synchronized MapMouseListener getMapMouseListener() {
        return this;
    }

    public boolean mousePressed(MouseEvent e) {
        return false;
    }

    public boolean mouseReleased(MouseEvent e) {
        return false;
    }

    public boolean mouseClicked(MouseEvent e) {
        LatLonPoint llp = (LatLonPoint)this.getProjection().inverse((double)e.getX(), (double)e.getY());
        List<DataMap> datamaps = this.getDataMapList().getDataMaps(new Coordinate(llp.getLatitude(), llp.getLongitude()));
        if (datamaps != null && datamaps.size() != 0) {
            String info = "";
            for (DataMap datamap : datamaps) {
                DefaultDataMap dataMap = (DefaultDataMap)datamap;
                if (dataMap.getInfo() != null) {
                    info = info + I18n.t((String)"Info", (Object[])new Object[0]) + ": " + dataMap.getInfo().getLabels() + " " + I18n.t((String)"isisfish.common.value", (Object[])new Object[0]) + ":" + dataMap.getValue() + "\n";
                    continue;
                }
                info = info + " " + I18n.t((String)"isisfish.common.value", (Object[])new Object[0]) + ":" + dataMap.getValue() + "\n";
            }
            JOptionPane.showMessageDialog((Component)((Object)this), info, this.getName(), 1);
            return true;
        }
        return false;
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public boolean mouseDragged(MouseEvent e) {
        return false;
    }

    public boolean mouseMoved(MouseEvent e) {
        return false;
    }

    public void mouseMoved() {
    }
}

