/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.map;

import fr.ifremer.isisfish.map.Coordinate;
import fr.ifremer.isisfish.map.DataMap;
import fr.ifremer.isisfish.map.DataMapInfo;

public class DefaultDataMap
implements DataMap {
    private static final long serialVersionUID = 3277576798583867731L;
    protected double value;
    protected DataMapInfo info;
    protected Coordinate[] coordinates;

    public DefaultDataMap() {
    }

    public DefaultDataMap(Coordinate[] coordinates, double value, DataMapInfo info) {
        this.coordinates = coordinates;
        this.value = value;
        this.info = info;
    }

    public DefaultDataMap(Coordinate[] coordinates, double value) {
        this(coordinates, value, null);
    }

    public DefaultDataMap(double value) {
        this.value = value;
    }

    public DefaultDataMap(String latitudes, String longitudes, double value) {
        this(value);
        this.setCoordinates(latitudes, longitudes);
    }

    public DefaultDataMap(float[] latitudes, float[] longitudes, double value) {
        this(value);
        this.setCoordinates(latitudes, longitudes);
    }

    public void setCoordinates(String latitudes, String longitudes) {
        String[] lat = latitudes.trim().split(" ");
        String[] lon = longitudes.trim().split(" ");
        this.coordinates = new Coordinate[lat.length];
        for (int i = 0; i < lat.length; ++i) {
            this.coordinates[i] = new Coordinate(Float.parseFloat(lat[i]), Float.parseFloat(lon[i]));
        }
    }

    public void setCoordinates(float[] latitudes, float[] longitudes) {
        this.coordinates = new Coordinate[latitudes.length];
        for (int i = 0; i < latitudes.length; ++i) {
            this.coordinates[i] = new Coordinate(latitudes[i], longitudes[i]);
        }
    }

    public void setCoordinates(Coordinate[] coordinates) {
        this.coordinates = coordinates;
    }

    @Override
    public Coordinate[] getCoordinates() {
        return this.coordinates;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    public void setValue(double v) {
        this.value = v;
    }

    @Override
    public DataMapInfo getInfo() {
        return this.info;
    }

    public void setInfo(DataMapInfo v) {
        this.info = v;
    }

    public String toString() {
        String str = "[";
        for (Coordinate coordinate : this.coordinates) {
            str = str + " " + coordinate;
        }
        str = str + " value:" + this.value + "]";
        return str;
    }
}

