/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.entities.EquationAbstract;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.EvaluatorHelper;
import org.nuiton.i18n.I18n;

public class EquationImpl
extends EquationAbstract {
    private static final long serialVersionUID = -2195404062556810283L;

    @Override
    public double evaluate(Object ... args) {
        String eq = this.getContent();
        try {
            if ("java".equals(this.getLanguage()) || this.getJavaInterface() != null) {
                Object[] params = new Object[args.length / 2 + 1];
                params[0] = SimulationContext.get();
                for (int i = 0; i < args.length / 2; ++i) {
                    params[i + 1] = args[i * 2 + 1];
                }
                Object val = EvaluatorHelper.evaluate("formules", this.getTopiaId(), this.getJavaInterface(), eq, params);
                if (val instanceof Number) {
                    double result = ((Number)val).doubleValue();
                    return result;
                }
                throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.equation.return.number", (Object[])new Object[]{eq}));
            }
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.unsupported.equation.langage", (Object[])new Object[]{this.getLanguage(), eq}));
        }
        catch (Exception eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.evaluate.equation", (Object[])new Object[]{eq}), eee);
        }
    }

    @Override
    public String[] evaluateNecessaryResult() {
        String eq = this.getContent();
        try {
            if ("java".equals(this.getLanguage()) || this.getJavaInterface() != null) {
                String[] result = EvaluatorHelper.evaluateNecessaryResult("formules", this.getTopiaId(), this.getJavaInterface(), this.getContent());
                return result;
            }
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.unsupported.equation.langage", (Object[])new Object[]{this.getLanguage(), eq}));
        }
        catch (Exception eee) {
            String message = "Can't evaluate equation";
            if (this.getJavaInterface() != null) {
                message = message + " (" + this.getJavaInterface().getSimpleName() + ")";
            }
            throw new IsisFishRuntimeException(message + " : " + eq, eee);
        }
    }

    @Override
    public String toString() {
        String result = this.getName() + "(" + this.getCategory() + ")";
        return result;
    }
}

