/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.datastore;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import fr.ifremer.isisfish.datastore.StorageChangeListener;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class RuleStorage
extends JavaSourceStorage {
    private static Log log = LogFactory.getLog(RuleStorage.class);
    public static final String RULE_PATH = "rules";
    public static final String RULE_TEMPLATE = "templates/script/rule.ftl";
    protected static Map<String, RuleStorage> rulesCache = new ReferenceMap();
    protected static Set<StorageChangeListener> storageListeners = Collections.newSetFromMap(new WeakHashMap());

    public static void addStorageListener(StorageChangeListener storageListener) {
        storageListeners.add(storageListener);
    }

    protected RuleStorage(File rootSrc, File directory, String name) {
        super(rootSrc, directory, name);
    }

    public static void registerWatcher() {
        RuleStorage.registerWatcher(storageListeners, RuleStorage.getRuleDirectory(), RuleStorage.getCommunityRuleDirectory());
    }

    @Override
    public String getPackage() {
        return RULE_PATH;
    }

    public static File getRuleDirectory() {
        File result = new File(RuleStorage.getContextDatabaseDirectory(), RULE_PATH);
        result.mkdirs();
        return result;
    }

    public static File getCommunityRuleDirectory() {
        File result = new File(RuleStorage.getCommunityDatabaseDirectory(), RULE_PATH);
        result.mkdirs();
        return result;
    }

    public static List<String> getRuleNames() {
        List<String> rules = RuleStorage.getStorageNames(RuleStorage.getRuleDirectory());
        rules.addAll(RuleStorage.getStorageNames(RuleStorage.getCommunityRuleDirectory()));
        return rules;
    }

    public static RuleStorage getRule(String name, CodeSourceStorage.Location ... location) {
        RuleStorage result = rulesCache.get(name);
        if (result == null) {
            CodeSourceStorage.Location loc = RuleStorage.nonEmptyLocation(location);
            for (File dir : loc.getDirectories()) {
                RuleStorage storage = new RuleStorage(dir, new File(dir, RULE_PATH), name);
                File sFile = storage.getFile();
                if (!sFile.isFile()) continue;
                result = storage;
                rulesCache.put(name, result);
            }
        }
        return result;
    }

    public static RuleStorage createRule(String name, CodeSourceStorage.Location location) {
        File dir = location.getDirectories()[0];
        RuleStorage storage = new RuleStorage(dir, new File(dir, RULE_PATH), name);
        return storage;
    }

    public static void checkout() throws VCSException {
        RuleStorage.checkout(IsisFish.config.getDatabaseDirectory(), RULE_PATH);
    }

    public static List<String> getNewRuleNames() {
        List<String> result = RuleStorage.getRuleNames();
        result.removeAll(RuleStorage.getRemoteRuleNames());
        return result;
    }

    public static List<String> getRemoteRuleNames() {
        File dir = RuleStorage.getRuleDirectory();
        return RuleStorage.getRemoteStorageNames(dir);
    }

    public static List<String> getNewRemoteRuleNames() {
        List<String> result = RuleStorage.getRemoteRuleNames();
        result.removeAll(RuleStorage.getRuleNames());
        return result;
    }

    @Override
    public String getDescription() {
        String result = null;
        try {
            Rule rule = (Rule)this.getNewInstance();
            result = rule == null ? null : rule.getDescription();
        }
        catch (Exception e) {
            log.warn((Object)I18n.t((String)"isisfish.error.not.found.description", (Object[])new Object[]{this}));
        }
        return result;
    }
}

