/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util.ssh;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.KeyPair;
import fr.ifremer.isisfish.ui.keystore.PasswordManager;
import fr.ifremer.isisfish.util.ssh.InvalidPassphraseException;
import java.io.File;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class SSHAgent {
    protected JSch jsch = new JSch();
    protected Map<String, char[]> passphraseForKeys = new HashMap<String, char[]>();
    private static SSHAgent agent = new SSHAgent();

    private SSHAgent() {
    }

    public static SSHAgent getAgent() {
        return agent;
    }

    public char[] getPassphrase(File privatekeyFile) throws InvalidPassphraseException {
        char[] passphrase = this.getPassphrase(privatekeyFile.getAbsolutePath());
        return passphrase;
    }

    public char[] getPassphrase(String privatekeyFile) throws InvalidPassphraseException {
        char[] passphrase = this.passphraseForKeys.get(privatekeyFile);
        if (passphrase == null) {
            try {
                KeyPair kpair = KeyPair.load((JSch)this.jsch, (String)privatekeyFile);
                if (kpair.isEncrypted()) {
                    boolean isValid = false;
                    boolean forceNew = false;
                    do {
                        String passphraseStr = PasswordManager.getInstance().getPassword(privatekeyFile, forceNew);
                        forceNew = true;
                        if (passphraseStr == null) {
                            throw new InvalidPassphraseException("User cancel passphrase ask");
                        }
                        if (!kpair.decrypt(SSHAgent.toBytes(passphraseStr.toCharArray()))) continue;
                        isValid = true;
                        this.passphraseForKeys.put(privatekeyFile, passphrase);
                    } while (!isValid);
                }
            }
            catch (JSchException e) {
                throw new RuntimeException("Can't find key : " + privatekeyFile);
            }
        }
        return passphrase;
    }

    protected static byte[] toBytes(char[] chars) {
        CharBuffer charBuffer = CharBuffer.wrap(chars);
        ByteBuffer byteBuffer = StandardCharsets.UTF_8.encode(charBuffer);
        byte[] bytes = Arrays.copyOfRange(byteBuffer.array(), byteBuffer.position(), byteBuffer.limit());
        Arrays.fill(byteBuffer.array(), (byte)0);
        return bytes;
    }
}

