/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util.converter;

import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.RangeOfValues;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.types.TimeUnit;
import fr.ifremer.isisfish.util.converter.CollectionConverter;
import fr.ifremer.isisfish.util.converter.MatrixConverter;
import fr.ifremer.isisfish.util.converter.MonthConverter;
import fr.ifremer.isisfish.util.converter.RangeOfValuesConverter;
import fr.ifremer.isisfish.util.converter.StringConverter;
import fr.ifremer.isisfish.util.converter.TimeStepConverter;
import fr.ifremer.isisfish.util.converter.TimeUnitConverter;
import fr.ifremer.isisfish.util.converter.TopiaEntityConverter;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.MatrixNDImpl;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;

public class ConverterUtil {
    protected static ConvertUtilsBean nullConverter = ConverterUtil.getConverterNoCache(null);

    public static ConvertUtilsBean getConverter(TopiaContext context) {
        ConvertUtilsBean result = context == null ? nullConverter : ConverterUtil.getConverterNoCache(context);
        return result;
    }

    protected static ConvertUtilsBean getConverterNoCache(TopiaContext context) {
        BeanUtilsBean bub = BeanUtilsBean.getInstance();
        ConvertUtilsBean result = bub.getConvertUtils();
        result.register((Converter)new TopiaEntityConverter(context), TopiaEntity.class);
        result.register((Converter)new TimeStepConverter(), TimeStep.class);
        result.register((Converter)new MonthConverter(), Month.class);
        result.register((Converter)new TimeUnitConverter(), TimeUnit.class);
        result.register((Converter)new RangeOfValuesConverter(), RangeOfValues.class);
        CollectionConverter collectionConverter = new CollectionConverter(result);
        result.register((Converter)collectionConverter, Collection.class);
        result.register((Converter)collectionConverter, List.class);
        result.register((Converter)collectionConverter, Set.class);
        MatrixConverter matrixConverter = new MatrixConverter();
        result.register((Converter)matrixConverter, MatrixND.class);
        result.register((Converter)matrixConverter, MatrixNDImpl.class);
        result.register((Converter)new StringConverter(result), String.class);
        return result;
    }
}

