/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RUtil {
    private static final Log log = LogFactory.getLog(RUtil.class);
    public static final String R_TYPE_PROPERTY = "R.type";

    public static void initJri() {
        System.setProperty(R_TYPE_PROPERTY, "jni");
    }

    public static String parseRscriptOutput(InputStream is) throws IOException {
        List output = IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8);
        String location = null;
        if (output.size() == 1) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Can't locate rJava package using Rscript (probably not installed)");
            }
        } else if (output.size() == 2) {
            String repository = ((String)output.get(1)).trim();
            repository = StringUtils.removeStart((String)repository, (String)"\"");
            repository = StringUtils.removeEnd((String)repository, (String)"\"");
            repository = repository.replace('/', File.separatorChar);
            location = RUtil.getArchLibraryPath(repository);
        } else if (log.isErrorEnabled()) {
            log.error((Object)"Can't analyze Rscript output. was: ");
            for (String line : output) {
                log.error((Object)line);
            }
        }
        return location;
    }

    protected static String getArchLibraryPath(String libraryRepository) {
        String archLibraryPath = libraryRepository + File.separator + "rJava" + File.separator + "jri";
        String arch = SystemUtils.OS_ARCH;
        if ("x86_64".equals(arch) || "amd64".equals(arch)) {
            String x64LibraryPath = archLibraryPath + File.separator + "x64";
            if (new File(x64LibraryPath).isDirectory()) {
                archLibraryPath = x64LibraryPath;
            }
        } else {
            String i386LibraryPath = archLibraryPath + File.separator + "i386";
            if (new File(i386LibraryPath).isDirectory()) {
                archLibraryPath = i386LibraryPath;
            }
        }
        return archLibraryPath;
    }
}

