/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.annotations.Args;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.result.NecessaryResult;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.util.CompileHelper;
import fr.ifremer.isisfish.util.ForceLoadCurrentClassLoader;
import fr.ifremer.isisfish.util.IsisFileUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class EvaluatorHelper {
    private static Log log = LogFactory.getLog(EvaluatorHelper.class);
    protected static Pattern grepImportPattern = Pattern.compile("(?:^\\s*|(?<=;)\\s*)(import[^;]+;)", 40);
    private static final String HASH_CACHE_KEY = "__hashCache__";

    protected static String getHashCache(File fileCheckSum) {
        String result = "";
        SimulationContext context = SimulationContext.get();
        SimulationStorage simulationStorage = context.getSimulationStorage();
        if (simulationStorage == null) {
            if (fileCheckSum.exists()) {
                try {
                    result = FileUtils.readFileToString((File)fileCheckSum, (Charset)StandardCharsets.UTF_8);
                }
                catch (IOException eee) {
                    log.info((Object)("Can't read old checkSum:  " + fileCheckSum), (Throwable)eee);
                }
            }
        } else {
            Map cache = (Map)context.getValue(HASH_CACHE_KEY);
            if (cache != null) {
                result = StringUtils.defaultString((String)((String)cache.get(fileCheckSum.getPath())));
            }
        }
        return result;
    }

    protected static void setHashCache(File fileCheckSum, String hashcode) {
        SimulationContext context = SimulationContext.get();
        SimulationStorage simulationStorage = context.getSimulationStorage();
        if (simulationStorage == null) {
            try {
                FileUtils.writeStringToFile((File)fileCheckSum, (String)hashcode, (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException eee) {
                log.info((Object)("Can't write checkSum:  " + fileCheckSum), (Throwable)eee);
            }
        } else {
            HashMap<String, String> cache = (HashMap<String, String>)context.getValue(HASH_CACHE_KEY);
            if (cache == null) {
                cache = new HashMap<String, String>();
                context.setValue(HASH_CACHE_KEY, cache);
            }
            cache.put(fileCheckSum.getPath(), hashcode);
        }
    }

    protected static String normalizeClassName(String name) {
        StringBuilder result = new StringBuilder(name);
        for (int i = 0; i < result.length(); ++i) {
            char c = result.charAt(i);
            if (Character.isJavaIdentifierPart(c)) continue;
            result.setCharAt(i, '_');
        }
        return result.toString();
    }

    public static int check(Class javaInterface, String script, PrintWriter out) {
        try {
            File src = IsisFileUtil.createTempFile("check" + javaInterface.getSimpleName(), "Equation");
            src.delete();
            String packageName = null;
            String className = EvaluatorHelper.normalizeClassName(src.getName());
            src = new File(src.getParentFile(), className + ".java");
            Method[] methods = javaInterface.getDeclaredMethods();
            Method interfaceMethod = methods[0];
            String content = EvaluatorHelper.generateContent(packageName, className, interfaceMethod, script);
            FileUtils.writeStringToFile((File)src, (String)content, (String)"utf-8");
            int compileResult = CompileHelper.compile(src.getParentFile(), src, src.getParentFile(), out);
            File dest = new File(src.getParentFile(), className + ".class");
            src.delete();
            dest.delete();
            return compileResult;
        }
        catch (Exception eee) {
            log.warn((Object)"Can't check equation", (Throwable)eee);
            return -10000;
        }
    }

    protected static Class compileAndGetClass(String packageName, String className, Class javaInterface, String script) {
        Class<?> clazz;
        ClassLoader cl;
        className = javaInterface.getSimpleName() + EvaluatorHelper.normalizeClassName(className);
        Method[] methods = javaInterface.getDeclaredMethods();
        Method interfaceMethod = methods[0];
        String classFQN = packageName + "." + className;
        File fileRootSrc = IsisFish.config.getCompileDirectory();
        File fileCheckSum = new File(fileRootSrc, packageName + File.separator + className + ".hashCode");
        File fileSrc = new File(fileRootSrc, packageName + File.separator + className + ".java");
        if (StringUtils.isBlank((CharSequence)script)) {
            try {
                Field defaultContentField = javaInterface.getDeclaredField("DEFAULT_CONTENT");
                script = (String)defaultContentField.get(null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException ex) {
                throw new IsisFishRuntimeException(I18n.t((String)"Can't get default content", (Object[])new Object[]{fileSrc}), ex);
            }
        }
        String oldCheckSum = EvaluatorHelper.getHashCache(fileCheckSum);
        String newCheckSum = Integer.toString(script.hashCode());
        boolean checkSumEquals = newCheckSum.equals(oldCheckSum);
        SimulationContext context = SimulationContext.get();
        Map<String, ClassLoader> classLoaderMap = context.getEquationClassLoaders();
        if (checkSumEquals) {
            if (classLoaderMap.get(classFQN) == null) {
                cl = IsisFish.config.getScriptClassLoader();
                classLoaderMap.put(classFQN, cl);
            }
        } else {
            String content = EvaluatorHelper.generateContent(packageName, className, interfaceMethod, script);
            try {
                FileUtils.writeStringToFile((File)fileSrc, (String)content, (Charset)StandardCharsets.UTF_8);
                EvaluatorHelper.setHashCache(fileCheckSum, Integer.toString(script.hashCode()));
            }
            catch (IOException zzz) {
                throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.save.script.compilation", (Object[])new Object[]{fileSrc}), zzz);
            }
            EvaluatorHelper.compile(fileRootSrc, fileSrc);
            ClassLoader cl2 = IsisFish.config.getScriptClassLoader();
            if (classLoaderMap.get(classFQN) == null) {
                classLoaderMap.put(classFQN, cl2);
            } else {
                URL[] cp = IsisFish.config.getScriptDirectoryURLs();
                ForceLoadCurrentClassLoader forceLoadCurrentClassLoader = new ForceLoadCurrentClassLoader(cp, cl2);
                forceLoadCurrentClassLoader.forceReloadClass(classFQN);
                classLoaderMap.put(classFQN, forceLoadCurrentClassLoader);
            }
        }
        cl = classLoaderMap.get(classFQN);
        try {
            clazz = cl.loadClass(classFQN);
        }
        catch (Exception ex) {
            EvaluatorHelper.compile(fileRootSrc, fileSrc);
            try {
                clazz = cl.loadClass(classFQN);
            }
            catch (Exception ex2) {
                throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.compile.script", (Object[])new Object[]{fileSrc}), ex2);
            }
        }
        return clazz;
    }

    public static void catchEvaluateException(Exception ex, Log log) {
        if (SimulationContext.get().getSimulationStorage() == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Error in equation");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"StackTrace", (Throwable)ex);
            }
        } else {
            throw new IsisFishRuntimeException("Can't evaluate equation", ex);
        }
    }

    public static Object evaluate(String packageName, String className, Class javaInterface, String script, Object ... args) {
        Class clazz = EvaluatorHelper.compileAndGetClass(packageName, className, javaInterface, script);
        Method[] methods = javaInterface.getDeclaredMethods();
        Method interfaceMethod = methods[0];
        Object result = EvaluatorHelper.invoke(clazz, interfaceMethod, args);
        return result;
    }

    public static String[] evaluateNecessaryResult(String packageName, String className, Class javaInterface, String script) {
        try {
            Class clazz = EvaluatorHelper.compileAndGetClass(packageName, className, javaInterface, script);
            Method interfaceMethod = javaInterface.getMethod("getNecessaryResult", new Class[0]);
            String[] result = (String[])EvaluatorHelper.invoke(clazz, interfaceMethod, new Object[0]);
            return result;
        }
        catch (NoSuchMethodException eee) {
            log.debug((Object)("Can't get necessary result for equation: " + script));
            return NecessaryResult.EMPTY_STRING_ARRAY;
        }
    }

    protected static void compile(File fileRootSrc, File fileSrc) {
        try {
            ArrayList<File> classpath = new ArrayList<File>();
            classpath.add(fileRootSrc.getAbsoluteFile());
            classpath.add(IsisFish.config.getContextDatabaseDirectory().getAbsoluteFile());
            int compileResult = CompileHelper.compile(classpath, Collections.singletonList(fileSrc), fileRootSrc, null);
            if (compileResult != 0) {
                throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.compile.script", (Object[])new Object[]{compileResult, fileSrc}));
            }
        }
        catch (Exception zzz) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.compile.script", (Object[])new Object[]{fileSrc}), zzz);
        }
    }

    protected static String generateContent(String packageName, String className, Method interfaceMethod, String script) {
        int i;
        StringBuilder necessaryResultContent = new StringBuilder();
        StringBuilder contentWithoutResult = new StringBuilder();
        EvaluatorHelper.generateNecessaryResult(script, necessaryResultContent, contentWithoutResult);
        StringBuilder imports = new StringBuilder();
        StringBuilder contentWithoutImport = new StringBuilder();
        EvaluatorHelper.grepImport(contentWithoutResult.toString(), imports, contentWithoutImport);
        String content = "";
        if (packageName != null && !"".equals(packageName)) {
            content = content + "package " + packageName + ";";
        }
        content = content + "import java.util.*;";
        content = content + "import java.io.*;";
        content = content + "import fr.ifremer.isisfish.entities.*;";
        content = content + "import fr.ifremer.isisfish.types.*;";
        content = content + "import org.nuiton.math.matrix.*;";
        content = content + "import org.apache.commons.logging.*;";
        content = content + "import resultinfos.*;";
        content = content + imports.toString();
        content = content + "public class " + className + " implements " + interfaceMethod.getDeclaringClass().getName() + " {";
        content = content + "private static Log log = LogFactory.getLog(" + className + ".class);";
        content = content + necessaryResultContent.toString();
        content = content + "public " + interfaceMethod.getReturnType().getName() + " " + interfaceMethod.getName() + "(";
        Args args = interfaceMethod.getAnnotation(Args.class);
        String[] names = args.value();
        String[] stringTypes = new String[names.length];
        Type[] types = interfaceMethod.getGenericParameterTypes();
        for (i = 0; i < types.length; ++i) {
            stringTypes[i] = types[i].getTypeName();
        }
        for (i = 0; i < names.length; ++i) {
            content = content + stringTypes[i] + " " + names[i];
            if (i + 1 >= names.length) continue;
            content = content + ", ";
        }
        content = content + ") throws Exception {";
        content = content + contentWithoutImport.toString();
        content = content + "\n}}\n";
        return content;
    }

    protected static void grepImport(String code, StringBuilder imports, StringBuilder others) {
        Matcher matches = grepImportPattern.matcher(code);
        int pos = 0;
        while (matches.find()) {
            int begin = matches.start(1);
            int end = matches.end(1);
            others.append(code, pos, begin);
            imports.append(code, begin, end);
            pos = end;
        }
        others.append(code.substring(pos));
    }

    protected static void generateNecessaryResult(String code, StringBuilder necessaryResultContent, StringBuilder equationContent) {
        Pattern p = Pattern.compile("(String\\[\\]\\s+necessaryResult\\s*=.*?;)", 32);
        Matcher m = p.matcher(code);
        if (m.find()) {
            necessaryResultContent.append("private ").append(m.group(1));
            necessaryResultContent.append("@Override public String[] getNecessaryResult () {return necessaryResult;}");
            equationContent.append(m.replaceFirst(""));
        } else {
            equationContent.append(code);
        }
    }

    protected static Object invoke(Class clazz, Method interfaceMethod, Object ... args) {
        Object result;
        try {
            Object eq = clazz.newInstance();
            result = interfaceMethod.invoke(eq, args);
        }
        catch (Exception eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.invoke.method", (Object[])new Object[]{interfaceMethod, clazz.getName()}), eee);
        }
        return result;
    }
}

