/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.widget.text;

import fr.ifremer.isisfish.ui.widget.text.SyntaxTokenManagerFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.fife.rsta.ui.CollapsibleSectionPanel;
import org.fife.rsta.ui.GoToDialog;
import org.fife.rsta.ui.search.FindDialog;
import org.fife.rsta.ui.search.ReplaceDialog;
import org.fife.rsta.ui.search.SearchEvent;
import org.fife.rsta.ui.search.SearchListener;
import org.fife.ui.rsyntaxtextarea.ErrorStrip;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxScheme;
import org.fife.ui.rsyntaxtextarea.TokenMakerFactory;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.fife.ui.rtextarea.SearchContext;
import org.fife.ui.rtextarea.SearchEngine;
import org.fife.ui.rtextarea.SearchResult;
import org.nuiton.i18n.I18n;

public class SyntaxEditorUI
extends CollapsibleSectionPanel
implements SearchListener,
CaretListener {
    private static final long serialVersionUID = 1427883892685276516L;
    protected RTextScrollPane textScrollpane;
    protected RSyntaxTextArea textArea = new RSyntaxTextArea();
    protected JLabel noFileLabel;
    protected FindDialog findDialog;
    protected ReplaceDialog replaceDialog;
    protected Action findAction;
    protected Action replaceAction;
    protected Action gotoAction;
    protected Action cutAction;
    protected Action pasteAction;
    protected Action copyAction;

    public SyntaxEditorUI() {
        super(true);
        this.textScrollpane = new RTextScrollPane((RTextArea)this.textArea);
        this.noFileLabel = new JLabel(I18n.t((String)"isisfish.editor.noselectedfile", (Object[])new Object[0]), 0);
        this.noFileLabel.setEnabled(false);
        ErrorStrip errorStrip = new ErrorStrip(this.textArea);
        this.add((Component)errorStrip, "After");
        this.textArea.setMarkOccurrences(true);
        this.textScrollpane.setLineNumbersEnabled(true);
        this.textArea.setTabsEmulated(true);
        this.textArea.setTabSize(4);
        this.initActions();
        this.setEnabled(false);
    }

    protected void initActions() {
        Frame parent = null;
        this.findDialog = new FindDialog(parent, (SearchListener)this);
        this.replaceDialog = new ReplaceDialog(parent, (SearchListener)this);
        this.findAction = new ShowFindDialogAction();
        this.replaceAction = new ShowReplaceDialogAction();
        this.gotoAction = new GoToLineAction(parent);
        int c = this.getToolkit().getMenuShortcutKeyMask();
        this.textArea.addCaretListener((CaretListener)this);
        this.cutAction = new AbstractAction(I18n.t((String)"isisfish.editor.cut", (Object[])new Object[0]), new ImageIcon(this.getClass().getResource("/icons/fatcow/cut.png"))){

            @Override
            public void actionPerformed(ActionEvent e) {
                SyntaxEditorUI.this.textArea.cut();
            }
        };
        this.cutAction.setEnabled(false);
        this.cutAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, c));
        this.pasteAction = new AbstractAction(I18n.t((String)"isisfish.editor.paste", (Object[])new Object[0]), new ImageIcon(this.getClass().getResource("/icons/fatcow/paste_plain.png"))){

            @Override
            public void actionPerformed(ActionEvent e) {
                SyntaxEditorUI.this.textArea.paste();
            }
        };
        this.pasteAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(86, c));
        this.copyAction = new AbstractAction(I18n.t((String)"isisfish.editor.copy", (Object[])new Object[0]), new ImageIcon(this.getClass().getResource("/icons/fatcow/page_copy.png"))){

            @Override
            public void actionPerformed(ActionEvent e) {
                SyntaxEditorUI.this.textArea.copy();
            }
        };
        this.copyAction.setEnabled(false);
        this.copyAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(67, c));
    }

    public void setStyle(String style) {
        RSyntaxDocument doc = new RSyntaxDocument((TokenMakerFactory)new SyntaxTokenManagerFactory(), style);
        this.textArea.setDocument((Document)doc);
        if ("isisfish-log".equals(style)) {
            SyntaxScheme scheme = this.textArea.getSyntaxScheme();
            scheme.getStyle((int)7).foreground = Color.RED;
        }
    }

    public void setText(String text) {
        this.textArea.setText(text);
        this.textArea.invalidate();
    }

    public void setRows(int rows) {
        this.textArea.setRows(rows);
    }

    public void setColumns(int columns) {
        this.textArea.setColumns(columns);
    }

    public void setEnabled(boolean enabled) {
        if (enabled) {
            this.remove(this.noFileLabel);
            this.add((Component)this.textScrollpane);
        } else {
            this.remove((Component)this.textScrollpane);
            this.add(this.noFileLabel);
            this.cutAction.setEnabled(false);
            this.copyAction.setEnabled(false);
        }
        this.pasteAction.setEnabled(enabled);
        this.findAction.setEnabled(enabled);
        this.replaceAction.setEnabled(enabled);
        this.gotoAction.setEnabled(enabled);
        this.revalidate();
        this.repaint();
    }

    public Action getFindAction() {
        return this.findAction;
    }

    public Action getReplaceAction() {
        return this.replaceAction;
    }

    public Action getGotoAction() {
        return this.gotoAction;
    }

    public Action getPasteAction() {
        return this.pasteAction;
    }

    public Action getCopyAction() {
        return this.copyAction;
    }

    public Action getCutAction() {
        return this.cutAction;
    }

    public String getSelectedText() {
        return this.textArea.getSelectedText();
    }

    public void searchEvent(SearchEvent e) {
        SearchEvent.Type type = e.getType();
        SearchContext context = e.getSearchContext();
        switch (type) {
            default: {
                SearchResult result = SearchEngine.markAll((RTextArea)this.textArea, (SearchContext)context);
                break;
            }
            case FIND: {
                SearchResult result = SearchEngine.find((JTextArea)this.textArea, (SearchContext)context);
                if (result.wasFound()) break;
                UIManager.getLookAndFeel().provideErrorFeedback((Component)this.textArea);
                break;
            }
            case REPLACE: {
                SearchResult result = SearchEngine.replace((RTextArea)this.textArea, (SearchContext)context);
                if (result.wasFound()) break;
                UIManager.getLookAndFeel().provideErrorFeedback((Component)this.textArea);
                break;
            }
            case REPLACE_ALL: {
                SearchResult result = SearchEngine.replaceAll((RTextArea)this.textArea, (SearchContext)context);
                JOptionPane.showMessageDialog(null, result.getCount() + " occurrences replaced.");
            }
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        boolean selected = e.getDot() != e.getMark();
        this.cutAction.setEnabled(selected);
        this.copyAction.setEnabled(selected);
    }

    private class ShowFindDialogAction
    extends AbstractAction {
        public ShowFindDialogAction() {
            super(I18n.t((String)"isisfish.script.find", (Object[])new Object[0]), new ImageIcon(ShowFindDialogAction.class.getResource("/icons/fatcow/find.png")));
            int c = SyntaxEditorUI.this.getToolkit().getMenuShortcutKeyMask();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(70, c));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SyntaxEditorUI.this.replaceDialog.isVisible()) {
                SyntaxEditorUI.this.replaceDialog.setVisible(false);
            }
            SyntaxEditorUI.this.findDialog.setVisible(true);
        }
    }

    private class ShowReplaceDialogAction
    extends AbstractAction {
        public ShowReplaceDialogAction() {
            super(I18n.t((String)"isisfish.script.replace", (Object[])new Object[0]), new ImageIcon(ShowReplaceDialogAction.class.getResource("/icons/fatcow/text_replace.png")));
            int c = SyntaxEditorUI.this.getToolkit().getMenuShortcutKeyMask();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(72, c));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SyntaxEditorUI.this.findDialog.isVisible()) {
                SyntaxEditorUI.this.findDialog.setVisible(false);
            }
            SyntaxEditorUI.this.replaceDialog.setVisible(true);
        }
    }

    private class GoToLineAction
    extends AbstractAction {
        protected Frame parent;

        public GoToLineAction(Frame parent) {
            super(I18n.t((String)"isisfish.script.gotoline", (Object[])new Object[0]));
            this.parent = parent;
            int c = SyntaxEditorUI.this.getToolkit().getMenuShortcutKeyMask();
            this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(76, c));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SyntaxEditorUI.this.findDialog.isVisible()) {
                SyntaxEditorUI.this.findDialog.setVisible(false);
            }
            if (SyntaxEditorUI.this.replaceDialog.isVisible()) {
                SyntaxEditorUI.this.replaceDialog.setVisible(false);
            }
            GoToDialog dialog = new GoToDialog(this.parent);
            dialog.setMaxLineNumberAllowed(SyntaxEditorUI.this.textArea.getLineCount());
            dialog.setVisible(true);
            int line = dialog.getLineNumber();
            if (line > 0) {
                try {
                    SyntaxEditorUI.this.textArea.setCaretPosition(SyntaxEditorUI.this.textArea.getLineStartOffset(line - 1));
                }
                catch (BadLocationException ble) {
                    UIManager.getLookAndFeel().provideErrorFeedback((Component)SyntaxEditorUI.this.textArea);
                    ble.printStackTrace();
                }
            }
        }
    }
}

