/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.result;

import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.ResultStorage;
import fr.ifremer.isisfish.datastore.SensitivityExportStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.datastore.StorageException;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.export.ExportHelper;
import fr.ifremer.isisfish.export.ExportInfo;
import fr.ifremer.isisfish.simulator.launcher.SimulationServiceListener;
import fr.ifremer.isisfish.ui.CommonHandler;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import fr.ifremer.isisfish.ui.result.MatrixMapRenderer;
import fr.ifremer.isisfish.ui.result.MatrixSummaryRenderer;
import fr.ifremer.isisfish.ui.result.ResultFrameUI;
import fr.ifremer.isisfish.ui.result.YearSumDimensionAction;
import fr.ifremer.isisfish.ui.widget.editor.ScriptParameterDialog;
import fr.ifremer.isisfish.util.IsisFileUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JMenuItem;
import jaxx.runtime.JAXXContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.viewer.MatrixDimensionAction;
import org.nuiton.math.matrix.viewer.MatrixRenderer;
import org.nuiton.math.matrix.viewer.MatrixViewerPanel;
import org.nuiton.math.matrix.viewer.renderer.MatrixChartRenderer;
import org.nuiton.math.matrix.viewer.renderer.MatrixPanelRenderer;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

public class ResultFrameHandler
extends CommonHandler {
    private static Log log = LogFactory.getLog(ResultFrameHandler.class);
    protected SimulationServiceListener listener = null;
    protected ResultFrameUI resultFrameUI;
    protected SimulationStorage simulationStorage;
    protected TopiaContext topiaContext;

    public ResultFrameHandler(ResultFrameUI resultFrameUI) {
        this.resultFrameUI = resultFrameUI;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.topiaContext != null) {
            this.topiaContext.closeContext();
        }
    }

    public void afterInit(SimulationStorage simulation) {
        this.simulationStorage = simulation;
        try {
            JMenuItem item;
            for (String exportName : ExportStorage.getExportNames()) {
                item = new JMenuItem(I18n.t((String)exportName, (Object[])new Object[0]));
                item.addActionListener(new ExportActionListener(exportName, false));
                this.resultFrameUI.getExportMenu().add(item);
            }
            for (String sensitivityExportName : SensitivityExportStorage.getSensitivityExportNames()) {
                item = new JMenuItem(I18n.t((String)sensitivityExportName, (Object[])new Object[0]));
                item.addActionListener(new ExportActionListener(sensitivityExportName, true));
                this.resultFrameUI.getSensitivityMenu().add(item);
            }
            this.topiaContext = simulation.getStorage().beginTransaction();
            ResultStorage resultStorage = simulation.getResultStorage();
            FisheryRegion fisheryRegion = SimulationStorage.getFisheryRegion(this.topiaContext);
            MatrixViewerPanel matrixViewerPanel = new MatrixViewerPanel();
            matrixViewerPanel.addMatrixDimentionAction((MatrixDimensionAction)new YearSumDimensionAction());
            matrixViewerPanel.addMatrixRenderer((MatrixRenderer)new MatrixSummaryRenderer(simulation, resultStorage, this.topiaContext), true);
            matrixViewerPanel.addMatrixRenderer((MatrixRenderer)new MatrixChartRenderer());
            matrixViewerPanel.addMatrixRenderer((MatrixRenderer)new MatrixMapRenderer(fisheryRegion));
            matrixViewerPanel.addMatrixRenderer((MatrixRenderer)new MatrixPanelRenderer());
            GenericComboModel<String> model = new GenericComboModel<String>(resultStorage.getResultName());
            this.resultFrameUI.getResultsComboBox().setModel(model);
            this.resultFrameUI.getResultsComboBox().addItemListener(e -> {
                if (e.getStateChange() == 1) {
                    String selectedMatrixName = (String)e.getItem();
                    MatrixND matrix = resultStorage.getMatrix(selectedMatrixName, this.topiaContext);
                    matrixViewerPanel.setMatrix(matrix);
                }
            });
            matrixViewerPanel.updateSelectedRenderingComponent();
            this.resultFrameUI.getMatrixViewerContainer().add((Component)matrixViewerPanel, "Center");
            if (model.getSize() > 0) {
                model.setSelectedItem(model.getElementAt(0));
            }
        }
        catch (StorageException | TopiaException ex) {
            throw new IsisFishRuntimeException("Can't open simulation", ex);
        }
    }

    public void exportSimulation() {
        File file = IsisFileUtil.getFile(".+\\.zip", I18n.t((String)"isisfish.result.export.simulation.file", (Object[])new Object[0]));
        if (file != null) {
            try {
                this.simulationStorage.createZip(file);
            }
            catch (IOException ex) {
                throw new IsisFishRuntimeException("Can't export simulation", ex);
            }
        }
    }

    public void exportSimulationReference() {
        File file = IsisFileUtil.getFile(".+\\.zip", I18n.t((String)"isisfish.result.export.simulation.file", (Object[])new Object[0]));
        if (file != null) {
            try {
                this.simulationStorage.createReferenceZip(file);
            }
            catch (IOException ex) {
                throw new IsisFishRuntimeException("Can't export simulation", ex);
            }
        }
    }

    protected class ExportActionListener
    implements ActionListener {
        protected String exportName;
        protected boolean sensitivity;

        public ExportActionListener(String exportName, boolean sensitivity) {
            this.exportName = exportName;
            this.sensitivity = sensitivity;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            block7: {
                try {
                    File file = IsisFileUtil.getFile(".+\\.csv(\\.gz)?", I18n.t((String)"isisfish.result.export.file", (Object[])new Object[0]));
                    if (file != null) {
                        ExportInfo exportInfo;
                        if (!file.getName().matches(".+\\.csv(\\.gz)?")) {
                            file = new File(file.getAbsolutePath() + ".csv.gz");
                        }
                        if (this.sensitivity) {
                            SensitivityExportStorage exportStorage = SensitivityExportStorage.getSensitivityExport(this.exportName, new CodeSourceStorage.Location[0]);
                            exportInfo = (ExportInfo)exportStorage.getNewInstance();
                        } else {
                            ExportStorage exportStorage = ExportStorage.getExport(this.exportName, new CodeSourceStorage.Location[0]);
                            exportInfo = (ExportInfo)exportStorage.getNewInstance();
                        }
                        exportInfo = (ExportInfo)ScriptParameterDialog.displayConfigurationFrame((JAXXContext)ResultFrameHandler.this.resultFrameUI, ResultFrameHandler.this.topiaContext, exportInfo);
                        if (exportInfo != null) {
                            ExportHelper.exportToFile(ResultFrameHandler.this.simulationStorage, exportInfo, file);
                        }
                    }
                }
                catch (Exception eee) {
                    if (!log.isWarnEnabled()) break block7;
                    log.warn((Object)"Erreur lors de l'export ", (Throwable)eee);
                }
            }
        }
    }
}

