/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.models;

import org.apache.commons.lang3.StringUtils;
import org.nuiton.i18n.I18n;

public class RendererHelper {
    protected static final String DOCUMENTATION_SUBTITLE = "<html><b>%s</b>%s<font color='gray'>%s</font></html>";
    protected static final String COMPILATION_SUBTITLE = "<html><b color='red'>%s</b>%s<font color='red'>%s</font></html>";

    public static String docToString(String annotationDoc) {
        String tooltip = null;
        if (StringUtils.isNotBlank((CharSequence)annotationDoc)) {
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            sb.append("<p>" + annotationDoc + "</p>");
            sb.append("</html>");
            tooltip = sb.toString();
            tooltip = tooltip.replace("\n", "<br/>");
        }
        return tooltip;
    }

    public static String getNameAndDocListString(String name, String documentation) {
        String result = String.format(DOCUMENTATION_SUBTITLE, name, "<br />", documentation);
        return result;
    }

    public static String getNameAndCompListString(String name) {
        String result = String.format(COMPILATION_SUBTITLE, name, "<br />", I18n.t((String)"isisfish.error.compile.documentationerror", (Object[])new Object[0]));
        return result;
    }

    public static String getNameAndDocComboString(String name, String documentation) {
        String result = String.format(DOCUMENTATION_SUBTITLE, name, " - ", documentation);
        return result;
    }

    public static String getNameAndCompComboString(String name) {
        String result = String.format(COMPILATION_SUBTITLE, name, " - ", I18n.t((String)"isisfish.error.compile.documentationerror", (Object[])new Object[0]));
        return result;
    }
}

