/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.population;

import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.Zone;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.input.population.PopulationMigrationImmigrationUI;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import fr.ifremer.isisfish.util.ErrorHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;

public class PopulationMigrationImmigrationHandler
extends InputContentHandler<PopulationMigrationImmigrationUI> {
    private static final Log log = LogFactory.getLog(PopulationMigrationImmigrationHandler.class);

    protected PopulationMigrationImmigrationHandler(PopulationMigrationImmigrationUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        ((PopulationMigrationImmigrationUI)this.inputContentUI).addPropertyChangeListener("bean", evt -> {
            if (evt.getNewValue() == null) {
                ((PopulationMigrationImmigrationUI)this.inputContentUI).fieldPopulationMigrationImmigrationCoefficient.setText("");
                ((PopulationMigrationImmigrationUI)this.inputContentUI).populationMigrationImmigrationTable.setMatrix(null);
            }
            if (evt.getNewValue() != null) {
                // empty if block
            }
            this.setFieldPopulationMigrationMigrationGroupChooserModel();
            this.setFieldPopulationMigrationMigrationArrivalZoneChooserModel();
            this.setAddButton();
        });
    }

    protected void populationMigrationImmigrationMatrixChanged(MatrixPanelEvent event) {
        if (((PopulationMigrationImmigrationUI)this.inputContentUI).getPopInfo() != null) {
            ((PopulationMigrationImmigrationUI)this.inputContentUI).getPopInfo().setImmigrationMatrix(((PopulationMigrationImmigrationUI)this.inputContentUI).populationMigrationImmigrationTable.getMatrix().clone());
        }
    }

    public void init(PopulationSeasonInfo populationSeasonInfo) {
        ((PopulationMigrationImmigrationUI)this.inputContentUI).populationMigrationImmigrationTable.setMatrix(((PopulationMigrationImmigrationUI)this.inputContentUI).getPopInfo().getImmigrationMatrix().copy());
    }

    protected void setFieldPopulationMigrationMigrationGroupChooserModel() {
        GenericComboModel<PopulationGroup> groups = new GenericComboModel<PopulationGroup>();
        if (((PopulationMigrationImmigrationUI)this.inputContentUI).getBean() != null && ((PopulationMigrationImmigrationUI)this.inputContentUI).getBean().getPopulationGroup() != null) {
            groups.setElementList(((PopulationMigrationImmigrationUI)this.inputContentUI).getBean().getPopulationGroup());
        }
        ((PopulationMigrationImmigrationUI)this.inputContentUI).fieldPopulationMigrationImmigrationGroupChooser.setModel(groups);
    }

    protected void setFieldPopulationMigrationMigrationArrivalZoneChooserModel() {
        GenericComboModel<Zone> zones = new GenericComboModel<Zone>();
        if (((PopulationMigrationImmigrationUI)this.inputContentUI).getBean() != null && ((PopulationMigrationImmigrationUI)this.inputContentUI).getBean().getPopulationZone() != null) {
            zones.setElementList(((PopulationMigrationImmigrationUI)this.inputContentUI).getBean().getPopulationZone());
        }
        ((PopulationMigrationImmigrationUI)this.inputContentUI).fieldPopulationMigrationImmigrationArrivalZoneChooser.setModel(zones);
    }

    protected void add() {
        this.addImmigration(((PopulationMigrationImmigrationUI)this.inputContentUI).getPopInfo(), (PopulationGroup)((PopulationMigrationImmigrationUI)this.inputContentUI).fieldPopulationMigrationImmigrationGroupChooser.getSelectedItem(), (Zone)((PopulationMigrationImmigrationUI)this.inputContentUI).fieldPopulationMigrationImmigrationArrivalZoneChooser.getSelectedItem(), Double.parseDouble(((PopulationMigrationImmigrationUI)this.inputContentUI).fieldPopulationMigrationImmigrationCoefficient.getText()));
        ((PopulationMigrationImmigrationUI)this.inputContentUI).populationMigrationImmigrationTable.setMatrix(((PopulationMigrationImmigrationUI)this.inputContentUI).getPopInfo().getImmigrationMatrix().clone());
    }

    public Object addImmigration(PopulationSeasonInfo info, PopulationGroup group, Zone arrival, double coeff) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"addImmigration called");
        }
        try {
            MatrixND mat = info.getImmigrationMatrix().copy();
            mat.setValue((Object)group, (Object)arrival, coeff);
            info.setImmigrationMatrix(mat);
        }
        catch (Exception eee) {
            if (log.isErrorEnabled()) {
                log.error((Object)"Can't add immigration", (Throwable)eee);
            }
            ErrorHelper.showErrorDialog(I18n.t((String)"isisfish.error.input.addentity", (Object[])new Object[]{"Immigration"}), eee);
        }
        return null;
    }

    protected void remove() {
        int row = ((PopulationMigrationImmigrationUI)this.inputContentUI).populationMigrationImmigrationTable.getTable().getSelectedRow();
        if (row != -1) {
            Object group = ((PopulationMigrationImmigrationUI)this.inputContentUI).populationMigrationImmigrationTable.getTable().getValueAt(row, 0);
            Object departure = ((PopulationMigrationImmigrationUI)this.inputContentUI).populationMigrationImmigrationTable.getTable().getValueAt(row, 1);
            MatrixND mat = ((PopulationMigrationImmigrationUI)this.inputContentUI).getPopInfo().getImmigrationMatrix().clone();
            mat.setValue(group, departure, 0.0);
            ((PopulationMigrationImmigrationUI)this.inputContentUI).getPopInfo().setImmigrationMatrix(mat);
            ((PopulationMigrationImmigrationUI)this.inputContentUI).populationMigrationImmigrationTable.setMatrix(((PopulationMigrationImmigrationUI)this.inputContentUI).getPopInfo().getImmigrationMatrix().copy());
        }
    }

    protected void setAddButton() {
        ((PopulationMigrationImmigrationUI)this.inputContentUI).add.setEnabled(((PopulationMigrationImmigrationUI)this.inputContentUI).isActive() != false && ((PopulationMigrationImmigrationUI)this.inputContentUI).fieldPopulationMigrationImmigrationGroupChooser.getSelectedItem() != null && !((PopulationMigrationImmigrationUI)this.inputContentUI).fieldPopulationMigrationImmigrationCoefficient.getText().equals("") && ((PopulationMigrationImmigrationUI)this.inputContentUI).fieldPopulationMigrationImmigrationArrivalZoneChooser.getSelectedItem() != null);
    }
}

