/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input;

import cern.colt.Arrays;
import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.IsisFishRuntimeException;
import fr.ifremer.isisfish.datastore.RegionAlreadyExistException;
import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.datastore.StorageChangeEvent;
import fr.ifremer.isisfish.datastore.StorageChangeListener;
import fr.ifremer.isisfish.datastore.StorageException;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.entities.FisheryRegionImpl;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.RegionExportJson;
import fr.ifremer.isisfish.entities.RegionImportJson;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.SpeciesDAO;
import fr.ifremer.isisfish.logging.RegionChangeLogger;
import fr.ifremer.isisfish.mexico.export.RegionExplorer;
import fr.ifremer.isisfish.mexico.export.RegionExportFactorXML;
import fr.ifremer.isisfish.ui.NavigationHandler;
import fr.ifremer.isisfish.ui.input.InputContentUI;
import fr.ifremer.isisfish.ui.input.InputContext;
import fr.ifremer.isisfish.ui.input.InputSaveVerifier;
import fr.ifremer.isisfish.ui.input.InputUI;
import fr.ifremer.isisfish.ui.input.spatial.AskNewSpatialUI;
import fr.ifremer.isisfish.ui.input.tree.FisheryDataProvider;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeHelper;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeNode;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeRenderer;
import fr.ifremer.isisfish.ui.input.tree.FisheryTreeSelectionModel;
import fr.ifremer.isisfish.ui.input.tree.loadors.PopulationsNodeLoador;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import fr.ifremer.isisfish.ui.widget.filterable.FilterableComboBox;
import fr.ifremer.isisfish.util.IsisFileUtil;
import fr.ifremer.isisfish.vcs.VCSException;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.event.ItemEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import jaxx.runtime.JAXXContext;
import jaxx.runtime.swing.nav.NavNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.prompt.PromptSupport;
import org.nuiton.i18n.I18n;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.event.TopiaEntityListener;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityContextable;
import org.nuiton.util.DesktopUtil;

public class InputHandler
extends NavigationHandler {
    private static final Log log = LogFactory.getLog(InputHandler.class);
    protected InputUI inputUI;
    protected StorageChangeListener regionListStorageListener;

    public InputHandler(InputUI inputUI) {
        this.inputUI = inputUI;
    }

    protected void initRegionListModel(StorageChangeEvent evt) {
        SwingUtilities.invokeLater(() -> this.inputUI.fieldCurrentRegionModel.setElementList(RegionStorage.getRegionNames()));
    }

    public void afterInit() {
        this.regionListStorageListener = this::initRegionListModel;
        RegionStorage.addStorageListener(this.regionListStorageListener);
        this.initRegionListModel(null);
        PromptSupport.setPrompt((String)I18n.t((String)"isisfish.input.newRegion", (Object[])new Object[0]), (JTextComponent)this.inputUI.getFieldNewRegion());
    }

    public void loadRegion(String name) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Load region " + name));
        }
        if (name == null) {
            InputContext.setStorage(null);
            InputContext.setDb(null);
            this.inputUI.getCardlayoutPrincipal().show(this.inputUI.getInputPanePrincipal(), "none");
            DefaultTreeModel model = new DefaultTreeModel(null);
            this.inputUI.getFisheryRegionTree().setModel(model);
        } else {
            FisheryRegion fisheryRegion;
            RegionChangeLogger regionChangeLogger;
            TopiaContext topiaContext;
            RegionStorage regionStorage;
            try {
                regionStorage = RegionStorage.getRegion(name);
                topiaContext = regionStorage.getStorage().beginTransaction();
                regionChangeLogger = new RegionChangeLogger(regionStorage, topiaContext);
                topiaContext.addTopiaEntityListener((TopiaEntityListener)regionChangeLogger);
                fisheryRegion = RegionStorage.getFisheryRegion(topiaContext);
                InputContext.setStorage(regionStorage);
                InputContext.setDb(topiaContext);
            }
            catch (StorageException | TopiaException ex) {
                throw new IsisFishRuntimeException("Can't load region", ex);
            }
            this.inputUI.setRegionLoaded(fisheryRegion != null);
            FisheryTreeHelper fisheryTreeHelper = new FisheryTreeHelper();
            FisheryDataProvider dataProvider = new FisheryDataProvider(fisheryRegion);
            fisheryTreeHelper.setDataProvider(dataProvider);
            TreeModel fisheryTreeModel = fisheryTreeHelper.createTreeModel(fisheryRegion);
            this.inputUI.getFisheryRegionTree().setCellRenderer(null);
            this.inputUI.getFisheryRegionTree().setModel(fisheryTreeModel);
            this.inputUI.getFisheryRegionTree().setCellRenderer(new FisheryTreeRenderer(dataProvider));
            this.inputUI.getFisheryRegionTree().setSelectionModel(new FisheryTreeSelectionModel(this.inputUI));
            fisheryTreeHelper.setUI(this.inputUI.getFisheryRegionTree(), true, false, null);
            this.inputUI.setContextValue(fisheryRegion);
            this.inputUI.setContextValue(regionStorage);
            this.inputUI.setContextValue(fisheryTreeHelper);
            this.inputUI.setContextValue(fisheryTreeModel);
            this.inputUI.setContextValue(topiaContext);
            this.inputUI.setContextValue(regionChangeLogger);
            this.inputUI.getCardlayoutPrincipal().show(this.inputUI.getInputPanePrincipal(), "normale");
            fisheryTreeHelper.selectNode((NavNode)((FisheryTreeNode)((Object)fisheryTreeModel.getRoot())));
        }
    }

    public void reloadFisheryTree() {
        FisheryTreeHelper fisheryTreeHelper = this.inputUI.getContextValue(FisheryTreeHelper.class);
        TreeModel fisheryTreeModel = this.inputUI.getContextValue(TreeModel.class);
        fisheryTreeHelper.refreshNode((NavNode)((FisheryTreeNode)((Object)fisheryTreeModel.getRoot())), true);
    }

    public void regionChange(ItemEvent e) {
        if (e.getStateChange() == 1) {
            String name = (String)this.inputUI.getFieldCurrentRegion().getSelectedItem();
            if (log.isDebugEnabled()) {
                log.debug((Object)("New region selected " + name));
            }
            this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.loading.region", (Object[])new Object[]{name}), true);
            this.inputUI.setCursor(Cursor.getPredefinedCursor(3));
            SwingUtilities.invokeLater(() -> {
                this.loadRegion(name);
                this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.load.finished", (Object[])new Object[0]));
                this.inputUI.setCursor(Cursor.getDefaultCursor());
            });
        }
    }

    public void createNewRegion() {
        String name = this.inputUI.getFieldNewRegion().getText();
        this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.creating.region", (Object[])new Object[]{name}), true);
        if (RegionStorage.getRegionNames().contains(name)) {
            JOptionPane.showMessageDialog(this.inputUI, I18n.t((String)"isisfish.error.region.already.exists", (Object[])new Object[0]));
        } else {
            try {
                RegionStorage.create(name);
            }
            catch (StorageException ex) {
                throw new IsisFishRuntimeException("Can't create region", ex);
            }
            this.inputUI.getFieldNewRegion().setText("");
            this.inputUI.getFieldCurrentRegion().setSelectedItem(name);
        }
        this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.creation.finished", (Object[])new Object[0]));
    }

    public void importRegion() {
        block11: {
            this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.import.zip", (Object[])new Object[0]), true);
            File file = IsisFileUtil.getFile(".*.zip$", I18n.t((String)"isisfish.message.import.region.zipped", (Object[])new Object[0]));
            if (file != null) {
                try {
                    RegionStorage.importZip(file);
                }
                catch (RegionAlreadyExistException eee) {
                    String regionName = eee.getRegionName();
                    Object[] options = new String[]{I18n.t((String)"isisfish.message.import.region.delete", (Object[])new Object[0]), I18n.t((String)"isisfish.message.import.region.rename", (Object[])new Object[0]), I18n.t((String)"isisfish.message.import.region.cancel", (Object[])new Object[0])};
                    int select = JOptionPane.showOptionDialog(this.inputUI, I18n.t((String)"isisfish.message.import.region.exists", (Object[])new Object[]{regionName}), I18n.t((String)"isisfish.message.import.region.select.option", (Object[])new Object[0]), -1, 1, null, options, options[2]);
                    if (select == 1) {
                        String newRegionName = JOptionPane.showInputDialog(I18n.t((String)"isisfish.message.import.region.name", (Object[])new Object[0]), (Object)regionName);
                        if (!StringUtils.isNotBlank((CharSequence)newRegionName)) break block11;
                        if (RegionStorage.getRegionNames().contains(newRegionName)) {
                            JOptionPane.showMessageDialog(this.inputUI, I18n.t((String)"isisfish.error.region.already.exists", (Object[])new Object[0]));
                        }
                        try {
                            RegionStorage.importAndRenameZip(file, newRegionName);
                        }
                        catch (Exception exception) {
                            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.region.import", (Object[])new Object[0]), exception);
                        }
                    }
                    if (select != 0) break block11;
                    try {
                        RegionStorage previousRegion = RegionStorage.getRegion(regionName);
                        if (previousRegion != null) {
                            previousRegion.delete(false);
                        }
                        RegionStorage.importZip(file);
                    }
                    catch (Exception exception) {
                        throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.region.import", (Object[])new Object[0]), exception);
                    }
                }
                catch (Exception eee) {
                    throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.region.import", (Object[])new Object[0]), eee);
                }
            }
        }
        this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.import.finished", (Object[])new Object[0]));
    }

    public void importRegionAndRename() {
        this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.import.zip", (Object[])new Object[0]), true);
        try {
            File file = IsisFileUtil.getFile(".*.zip$", I18n.t((String)"isisfish.message.import.region.zipped", (Object[])new Object[0]));
            if (file != null) {
                String newName = JOptionPane.showInputDialog(I18n.t((String)"isisfish.message.name.imported.region", (Object[])new Object[0]));
                RegionStorage.importAndRenameZip(file, newName);
            }
        }
        catch (Exception eee) {
            throw new IsisFishRuntimeException(I18n.t((String)"isisfish.error.region.import", (Object[])new Object[0]), eee);
        }
        this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.import.finished", (Object[])new Object[0]));
    }

    public void importRegionFromSimulation() {
        this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.import", (Object[])new Object[0]), true);
        try {
            List<String> simulationNames = SimulationStorage.getSimulationNames();
            JPanel panel = new JPanel();
            panel.setLayout(new BorderLayout());
            JLabel label = new JLabel(I18n.t((String)"isisfish.message.import.selectSimulation", (Object[])new Object[0]));
            panel.add((Component)label, "North");
            FilterableComboBox<String> comboBox = new FilterableComboBox<String>();
            comboBox.setModel(new GenericComboModel<String>(simulationNames));
            panel.add(comboBox, "South");
            int response = JOptionPane.showConfirmDialog(this.inputUI, panel, I18n.t((String)"isisfish.message.import", (Object[])new Object[0]), 2, 3);
            String simulationName = (String)comboBox.getSelectedItem();
            if (response == 0 && simulationName != null) {
                String regionName;
                if (log.isInfoEnabled()) {
                    log.info((Object)("simulation used " + simulationName));
                }
                if (StringUtils.isNotBlank((CharSequence)(regionName = (String)JOptionPane.showInputDialog(this.inputUI, I18n.t((String)"isisfish.message.import.region.name", (Object[])new Object[0]), I18n.t((String)"isisfish.message.import", (Object[])new Object[0]), 3, null, null, "region from " + simulationName)))) {
                    if (RegionStorage.getRegionNames().contains(regionName)) {
                        JOptionPane.showMessageDialog(this.inputUI, I18n.t((String)"isisfish.error.region.already.exists", (Object[])new Object[0]));
                    } else {
                        SimulationStorage.getSimulation(simulationName).extractRegion(regionName);
                    }
                }
            }
        }
        catch (Exception eee) {
            throw new IsisFishRuntimeException("Can't import region from simulation", eee);
        }
        this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.export.done", (Object[])new Object[0]));
    }

    public void exportRegion() {
        try {
            File file = IsisFileUtil.getFile(".*.zip$", I18n.t((String)"isisfish.message.import.region.zipped", (Object[])new Object[0]));
            if (file != null) {
                file = IsisFileUtil.addExtensionIfNeeded(file, "zip");
                int resp = 0;
                if (file.exists()) {
                    resp = JOptionPane.showConfirmDialog(this.inputUI, I18n.t((String)"isisfish.message.file.overwrite", (Object[])new Object[0]));
                }
                if (resp == 0) {
                    RegionStorage regionStorage = this.inputUI.getContextValue(RegionStorage.class);
                    regionStorage.createZip(file);
                }
            }
        }
        catch (IOException eee) {
            throw new IsisFishRuntimeException("Can't export region", eee);
        }
    }

    protected void exportJson(TopiaEntity e) {
        block8: {
            try {
                File file = IsisFileUtil.getFile(I18n.t((String)"isisfish.input.menu.exportJson", (Object[])new Object[0]), I18n.t((String)"isisfish.common.export", (Object[])new Object[0]), (Component)null, ".*.isis.json.gz$", I18n.t((String)"isisfish.message.import.json.zipped", (Object[])new Object[0]));
                if (file == null) break block8;
                file = IsisFileUtil.addExtensionIfNeeded(file, ".isis.json.gz");
                int resp = 0;
                if (file.exists()) {
                    resp = JOptionPane.showConfirmDialog(this.inputUI, I18n.t((String)"isisfish.message.file.overwrite", (Object[])new Object[0]));
                }
                if (resp != 0) break block8;
                try (BufferedOutputStream out = new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(file)));){
                    RegionExportJson json = new RegionExportJson(new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8));
                    json.export(e);
                }
            }
            catch (Exception eee) {
                throw new IsisFishRuntimeException("Can't export region", eee);
            }
        }
    }

    public void exportEntityJson() {
        Object[] cs = this.inputUI.getInputPane().getComponents();
        if (cs != null && cs.length == 1 && cs[0] instanceof InputContentUI) {
            InputContentUI inputContentUI = (InputContentUI)cs[0];
            Object e = inputContentUI.getBean();
            if (e != null) {
                log.info((Object)("try to export json version of: " + e));
                this.exportJson((TopiaEntity)e);
            } else {
                log.error((Object)("Can't find entity in : " + inputContentUI));
            }
        } else {
            log.error((Object)("Can't find InputContentUI in : " + Arrays.toString((Object[])cs)));
        }
    }

    public void importEntityJson() {
        block11: {
            this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.import.zip", (Object[])new Object[0]), true);
            try {
                File file;
                InputSaveVerifier inputSaveVerifier = this.inputUI.getContextValue(InputSaveVerifier.class);
                if (inputSaveVerifier.checkEdit() == 2 || (file = IsisFileUtil.getFile(I18n.t((String)"isisfish.input.menu.importJson", (Object[])new Object[0]), I18n.t((String)"isisfish.common.import", (Object[])new Object[0]), (Component)null, ".*.isis.json.gz$", I18n.t((String)"isisfish.message.import.json.zipped", (Object[])new Object[0]))) == null) break block11;
                file = IsisFileUtil.addExtensionIfNeeded(file, ".isis.json.gz");
                FisheryRegion fisheryRegion = this.inputUI.getContextValue(FisheryRegion.class);
                TopiaContext tx = fisheryRegion.getTopiaContext();
                RegionImportJson.RegionMergeDatabase merge = new RegionImportJson.RegionMergeDatabase(tx);
                try (BufferedInputStream in = new BufferedInputStream(new GZIPInputStream(new FileInputStream(file)));){
                    RegionImportJson json = new RegionImportJson(new InputStreamReader((InputStream)in, StandardCharsets.UTF_8), merge);
                    Collection<TopiaEntity> entities = json.getEntities();
                    log.info((Object)("Entities to import: " + entities.size()));
                    for (TopiaEntity e : entities) {
                        tx.add(e);
                    }
                    tx.commitTransaction();
                    log.info((Object)"Import merged");
                }
                catch (Exception eee) {
                    tx.rollbackTransaction();
                    if (!merge.isAbort()) {
                        throw eee;
                    }
                    log.info((Object)"Import aborted");
                }
                inputSaveVerifier.cancel();
                this.loadRegion(fisheryRegion.getName());
            }
            catch (Exception eee) {
                throw new IsisFishRuntimeException("Can't import region", eee);
            }
        }
        this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.import.finished", (Object[])new Object[0]));
    }

    public void removeRegion(boolean vcsDelete) {
        try {
            RegionStorage regionStorage = this.inputUI.getContextValue(RegionStorage.class);
            int resp = JOptionPane.showConfirmDialog(this.inputUI, I18n.t((String)"isisfish.message.confirm.remove.region", (Object[])new Object[]{regionStorage.getName()}));
            if (resp == 0) {
                this.loadRegion(null);
                regionStorage.delete(vcsDelete);
            }
        }
        catch (StorageException eee) {
            throw new IsisFishRuntimeException("Can't delete region", eee);
        }
    }

    public void copyRegion() {
        try {
            String newName = JOptionPane.showInputDialog(I18n.t((String)"isisfish.message.new.region.name", (Object[])new Object[0]));
            if (StringUtils.isNotEmpty((CharSequence)newName)) {
                RegionStorage regionStorage = this.inputUI.getContextValue(RegionStorage.class);
                File zip = regionStorage.createZip();
                RegionStorage.importAndRenameZip(zip, newName);
            }
        }
        catch (RegionAlreadyExistException | StorageException | IOException eee) {
            throw new IsisFishRuntimeException("Can't copy region", eee);
        }
    }

    public void commitRegionInCVS() {
        try {
            RegionStorage regionStorage = this.inputUI.getContextValue(RegionStorage.class);
            this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.commiting.region", (Object[])new Object[]{regionStorage.getName()}), true);
            String msg = regionStorage.getCommentForNextCommit();
            JTextArea text = new JTextArea(msg);
            int resp = JOptionPane.showOptionDialog(null, new JScrollPane(text), I18n.t((String)"isisfish.commit.message", (Object[])new Object[0]), 2, 3, null, null, null);
            if (resp == 0) {
                regionStorage.commit(text.getText());
                regionStorage.clearCommentForNextCommit();
                this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.region.commited", (Object[])new Object[0]));
            } else {
                this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.commit.region.canceled", (Object[])new Object[0]));
            }
        }
        catch (VCSException | IOException eee) {
            throw new IsisFishRuntimeException("Can't commit region", eee);
        }
        this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.message.export.done", (Object[])new Object[0]));
    }

    public void exportRegionSensitivityFactors() {
        try {
            File exportFile = IsisFileUtil.getFile(I18n.t((String)"isisfish.input.sensitivity.export.title", (Object[])new Object[0]), I18n.t((String)"isisfish.common.ok", (Object[])new Object[0]), (Component)this.inputUI, ".*\\.xml", "XML Files");
            if (exportFile != null) {
                if (!exportFile.getAbsolutePath().endsWith(".xml")) {
                    exportFile = new File(exportFile.getAbsolutePath() + ".xml");
                }
                FisheryRegion fisheryRegion = this.inputUI.getContextValue(FisheryRegion.class);
                this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.input.sensitivity.export.running", (Object[])new Object[0]), true);
                RegionExplorer explorer = new RegionExplorer();
                RegionExportFactorXML exportXML = new RegionExportFactorXML(exportFile);
                explorer.explore(fisheryRegion, exportXML);
                this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.input.sensitivity.export.complete", (Object[])new Object[0]), true);
            } else {
                this.setStatusMessage((JAXXContext)this.inputUI, I18n.t((String)"isisfish.input.sensitivity.export.cancel", (Object[])new Object[0]), true);
            }
        }
        catch (TopiaException eee) {
            throw new IsisFishRuntimeException("Can't export sensitivity factors", eee);
        }
    }

    public void nodeSelectionChanged(TreeSelectionEvent event) {
        Object lastTreePath;
        TreePath newTreePath = event.getNewLeadSelectionPath();
        if (newTreePath != null && (lastTreePath = newTreePath.getLastPathComponent()) instanceof FisheryTreeNode) {
            FisheryTreeNode isisTreeNode = (FisheryTreeNode)((Object)lastTreePath);
            Class internalClass = isisTreeNode.getInternalClass();
            TopiaEntityContextable topiaEntity = null;
            String topiaId = isisTreeNode.getId();
            try {
                if (isisTreeNode.isStaticNode()) {
                    FisheryRegion fisheryRegion = this.inputUI.getContextValue(FisheryRegion.class);
                    TopiaContext topiaContext = fisheryRegion.getTopiaContext();
                    topiaEntity = (TopiaEntityContextable)topiaContext.findByTopiaId(topiaId);
                }
                InputContentUI<?> inputContentUI = this.getUIInstanceForBeanClass(internalClass, this.inputUI);
                inputContentUI.getSaveVerifier().setInputContentUI(inputContentUI);
                inputContentUI.getSaveVerifier().reset();
                if (topiaEntity != null) {
                    inputContentUI.getSaveVerifier().addCurrentEntity(topiaEntity);
                }
                inputContentUI.setBean(topiaEntity);
                inputContentUI.setActive(topiaEntity != null);
                this.inputUI.getCardlayoutPrincipal().show(this.inputUI.getInputPanePrincipal(), "normale");
                this.inputUI.getInputPane().removeAll();
                this.inputUI.getInputPane().add(inputContentUI, "Center");
                this.inputUI.getInputPane().repaint();
                this.inputUI.getInputPane().validate();
            }
            catch (Exception ex) {
                throw new IsisFishRuntimeException("Can't display bean " + topiaId, ex);
            }
        }
    }

    public void deleteTreeNode(String topiaId) {
        FisheryTreeHelper fisheryTreeHelper = this.inputUI.getContextValue(FisheryTreeHelper.class);
        TreeModel fisheryTreeModel = this.inputUI.getContextValue(TreeModel.class);
        FisheryTreeNode newSelectNode = (FisheryTreeNode)fisheryTreeHelper.findNode((NavNode)((FisheryTreeNode)((Object)fisheryTreeModel.getRoot())), new String[]{topiaId});
        FisheryTreeNode parentNode = (FisheryTreeNode)newSelectNode.getParent();
        fisheryTreeHelper.selectNode((NavNode)parentNode);
        fisheryTreeHelper.removeNode((NavNode)newSelectNode);
    }

    public void insertTreeNode(Class nodeClass, TopiaEntityContextable topiaEntity) {
        FisheryTreeHelper fisheryTreeHelper = this.inputUI.getContextValue(FisheryTreeHelper.class);
        FisheryTreeNode selectedNode = (FisheryTreeNode)fisheryTreeHelper.getSelectedNode();
        if (selectedNode.isStaticNode()) {
            selectedNode = (FisheryTreeNode)selectedNode.getParent();
        }
        FisheryTreeNode newNode = new FisheryTreeNode(nodeClass, topiaEntity.getTopiaId(), null, null);
        fisheryTreeHelper.insertNode((NavNode)selectedNode, (NavNode)newNode);
        if (nodeClass.equals(Species.class)) {
            FisheryTreeNode newPopNode = new FisheryTreeNode(Population.class, I18n.n((String)"isisfish.input.tree.populations", (Object[])new Object[0]), null, new PopulationsNodeLoador((Species)topiaEntity));
            fisheryTreeHelper.insertNode((NavNode)newNode, (NavNode)newPopNode);
        }
        fisheryTreeHelper.selectNode((NavNode)newNode);
    }

    public void updateTreeNode(String topiaId) {
        FisheryTreeHelper fisheryTreeHelper = this.inputUI.getContextValue(FisheryTreeHelper.class);
        TreeModel fisheryTreeModel = this.inputUI.getContextValue(TreeModel.class);
        FisheryTreeNode newSelectNode = (FisheryTreeNode)fisheryTreeHelper.findNode((NavNode)((FisheryTreeNode)((Object)fisheryTreeModel.getRoot())), new String[]{topiaId});
        fisheryTreeHelper.refreshNode((NavNode)newSelectNode, false);
    }

    public Species findSpecies() {
        Species result;
        String speciesId;
        FisheryTreeHelper treeHelper = this.inputUI.getContextValue(FisheryTreeHelper.class);
        FisheryTreeNode selectedNode = (FisheryTreeNode)treeHelper.getSelectedNode();
        if (selectedNode == null) {
            throw new IsisFishRuntimeException("Not selected tree node");
        }
        FisheryTreeNode parentNode = (FisheryTreeNode)selectedNode.getParent();
        if (parentNode.getInternalClass().equals(Species.class)) {
            speciesId = parentNode.getId();
        } else if (((FisheryTreeNode)parentNode.getParent()).getInternalClass().equals(Species.class)) {
            speciesId = ((FisheryTreeNode)parentNode.getParent()).getId();
        } else {
            throw new IsisFishRuntimeException("Not selected tree node");
        }
        TopiaContext topiaContext = this.inputUI.getContextValue(TopiaContext.class);
        try {
            SpeciesDAO dao = IsisFishDAOHelper.getSpeciesDAO(topiaContext);
            result = (Species)dao.findByTopiaId(speciesId);
        }
        catch (TopiaException e) {
            throw new IsisFishRuntimeException("Can't find ");
        }
        return result;
    }

    public void changeSpatialResolution() {
        InputSaveVerifier inputSaveVerifier = this.inputUI.getContextValue(InputSaveVerifier.class);
        if (inputSaveVerifier.checkEdit() != 2) {
            AskNewSpatialUI askNewSpatialUI = new AskNewSpatialUI((JAXXContext)this.inputUI);
            FisheryRegion fisheryRegion = this.inputUI.getContextValue(FisheryRegion.class);
            FisheryRegionImpl newFisheryRegion = new FisheryRegionImpl();
            newFisheryRegion.setName(fisheryRegion.getName());
            newFisheryRegion.setCellLengthLatitude(fisheryRegion.getCellLengthLatitude());
            newFisheryRegion.setCellLengthLongitude(fisheryRegion.getCellLengthLongitude());
            newFisheryRegion.setMaxLatitude(fisheryRegion.getMaxLatitude());
            newFisheryRegion.setMaxLongitude(fisheryRegion.getMaxLongitude());
            newFisheryRegion.setMinLatitude(fisheryRegion.getMinLatitude());
            newFisheryRegion.setMinLongitude(fisheryRegion.getMinLongitude());
            newFisheryRegion.setMapFileList(fisheryRegion.getMapFileList());
            askNewSpatialUI.setContextValue(newFisheryRegion, "newFisheryRegion");
            askNewSpatialUI.setBean(newFisheryRegion);
            askNewSpatialUI.pack();
            askNewSpatialUI.setLocationRelativeTo(this.inputUI);
            askNewSpatialUI.setVisible(true);
        }
    }

    public void exportWeb() {
        try {
            StringWriter outJson = new StringWriter();
            RegionExportJson json = new RegionExportJson(outJson);
            FisheryRegion fisheryRegion = this.inputUI.getContextValue(FisheryRegion.class);
            json.export(fisheryRegion);
            Configuration freemarkerConfiguration = new Configuration(Configuration.VERSION_2_3_25);
            freemarkerConfiguration.setDefaultEncoding("utf-8");
            ClassTemplateLoader templateLoader = new ClassTemplateLoader(InputHandler.class, "/");
            freemarkerConfiguration.setTemplateLoader((TemplateLoader)templateLoader);
            freemarkerConfiguration.setObjectWrapper((ObjectWrapper)new BeansWrapper(Configuration.VERSION_2_3_25));
            Template template = freemarkerConfiguration.getTemplate("templates/web/region-web.html");
            HashMap<String, Object> root = new HashMap<String, Object>();
            root.put("fisheryRegion", fisheryRegion);
            root.put("jsonExport", "\nvar jsonExport = " + outJson.toString() + ";");
            File outFile = IsisFileUtil.createTempFile("isis-export-", ".html");
            outFile.deleteOnExit();
            OutputStreamWriter outWriter = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outFile)), StandardCharsets.UTF_8);
            template.process(root, (Writer)outWriter);
            ((Writer)outWriter).flush();
            DesktopUtil.browse((URI)outFile.toURI());
        }
        catch (TemplateException | IOException ex) {
            throw new IsisFishRuntimeException("Can't export web", ex);
        }
    }
}

