/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.config;

import fr.ifremer.isisfish.ui.config.RConfigUI;
import fr.ifremer.isisfish.ui.config.SubProcessLogThread;
import fr.ifremer.isisfish.ui.script.ScriptHandler;
import fr.ifremer.isisfish.util.RUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.text.DefaultCaret;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.j2r.RException;
import org.nuiton.j2r.RProxy;

public class RConfigHandler
implements Runnable {
    private static final Log log = LogFactory.getLog(RConfigHandler.class);
    protected RConfigUI rconfigUI;
    protected File rDirectory;

    public RConfigHandler(RConfigUI rconfigUI) {
        this.rconfigUI = rconfigUI;
    }

    public void afterInit() {
        String systemPath = System.getProperty("java.library.path");
        this.rconfigUI.getLibraryPathField().setText(systemPath);
        DefaultCaret caret = (DefaultCaret)this.rconfigUI.getInformationField().getCaret();
        caret.setUpdatePolicy(2);
    }

    public void testRConfiguration() {
        this.testREngine();
    }

    public void testREngine() {
        block2: {
            this.rconfigUI.getInformationField().setBackground(null);
            try {
                this.rconfigUI.getInformationField().setText(I18n.t((String)"isisfish.simulator.configuration.r.testing", (Object[])new Object[0]));
                RProxy engine = new RProxy();
                engine.eval("library('lhs')");
                engine.eval("library('sensitivity')");
                this.rconfigUI.getInformationField().setBackground(ScriptHandler.COLOR_SUCCESS);
                this.rconfigUI.getInformationField().setText(I18n.t((String)"isisfish.simulator.configuration.r.testedok", (Object[])new Object[0]));
            }
            catch (RException ex) {
                this.rconfigUI.getInformationField().setBackground(ScriptHandler.COLOR_FAILURE);
                this.rconfigUI.getInformationField().setText(I18n.t((String)"isisfish.simulator.configuration.r.testedincomplete", (Object[])new Object[0]) + "\n\n");
                JOptionPane.showMessageDialog(this.rconfigUI, I18n.t((String)"isisfish.simulator.configuration.r.cantinit", (Object[])new Object[]{ex.getMessage()}), I18n.t((String)"isisfish.simulator.configuration.r.title", (Object[])new Object[0]), 0);
                JFileChooser jfc = new JFileChooser();
                jfc.setFileSelectionMode(1);
                int option = jfc.showOpenDialog(this.rconfigUI);
                if (option != 0) break block2;
                this.rDirectory = jfc.getSelectedFile();
                new Thread(this).start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.rconfigUI.setRunning(false);
        try {
            this.rconfigUI.getInformationField().append(I18n.t((String)"isisfish.simulator.configuration.r.installing", (Object[])new Object[0]) + "\n");
            this.rconfigUI.getInformationField().setBackground(null);
            File rBin = new File(this.rDirectory, "bin");
            File rScript = new File(rBin, "Rscript");
            boolean result = this.installPackages(rScript);
            if (result &= this.configureJriPath(rScript)) {
                this.rconfigUI.getInformationField().setBackground(ScriptHandler.COLOR_SUCCESS);
                this.rconfigUI.getInformationField().append("****************************\n");
                this.rconfigUI.getInformationField().append(I18n.t((String)"isisfish.simulator.configuration.r.installed", (Object[])new Object[0]) + "\n");
                this.rconfigUI.getInformationField().append(I18n.t((String)"isisfish.simulator.configuration.r.restart", (Object[])new Object[0]) + "\n");
                this.rconfigUI.getInformationField().append("****************************\n");
            } else {
                this.rconfigUI.getInformationField().setBackground(ScriptHandler.COLOR_FAILURE);
                this.rconfigUI.getInformationField().append(I18n.t((String)"isisfish.simulator.configuration.r.failure", (Object[])new Object[0]) + "\n");
            }
        }
        finally {
            this.rconfigUI.setRunning(false);
        }
    }

    protected boolean installPackages(File rScript) {
        boolean result = false;
        String script = "dir.create(path = Sys.getenv(\"R_LIBS_USER\"), showWarnings = FALSE, recursive = TRUE)\nif(!require(rJava)){\n    install.packages(\"rJava\", lib = Sys.getenv(\"R_LIBS_USER\"), repos=\"https://cran.irsn.fr/\")\n}\nif(!require(lhs)){\n    install.packages(\"lhs\", lib = Sys.getenv(\"R_LIBS_USER\"), repos=\"https://cran.irsn.fr/\")\n}\nif(!require(sensitivity)){\n    install.packages(\"sensitivity\", lib = Sys.getenv(\"R_LIBS_USER\"), repos=\"https://cran.irsn.fr/\")\n}";
        try {
            File scriptFile = File.createTempFile("isis-r-script-", ".R");
            scriptFile.deleteOnExit();
            FileUtils.writeStringToFile((File)scriptFile, (String)script, (Charset)StandardCharsets.UTF_8);
            ProcessBuilder pb = new ProcessBuilder(rScript.getAbsolutePath(), scriptFile.getAbsolutePath());
            pb.redirectErrorStream(true);
            Process process = pb.start();
            SubProcessLogThread logThread = new SubProcessLogThread(process, this.rconfigUI.getInformationField());
            logThread.start();
            int errorCode = process.waitFor();
            if (errorCode == 0) {
                result = true;
            } else {
                log.error((Object)("Can't call Rscript : " + errorCode));
            }
        }
        catch (IOException | InterruptedException ex) {
            this.rconfigUI.getInformationField().append(ex.getMessage() + "\n");
            log.error((Object)"Can't install r libraries", (Throwable)ex);
        }
        File isisRConfigFile = new File("isisfish.jri");
        try {
            FileUtils.writeStringToFile((File)isisRConfigFile, (String)this.rDirectory.getAbsolutePath(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            log.error((Object)"Can't write isis configuration", (Throwable)ex);
        }
        return result;
    }

    protected boolean configureJriPath(File rScript) {
        boolean result;
        block10: {
            result = false;
            try {
                String script = "installed.packages()[which(installed.packages()[,1]=='rJava'),]['LibPath']";
                ProcessBuilder pb = new ProcessBuilder(rScript.getAbsolutePath(), "-e", script);
                Process process = pb.start();
                int exitValue = process.waitFor();
                if (exitValue == 0) {
                    String jriDirectory = RUtil.parseRscriptOutput(process.getInputStream());
                    if (StringUtils.isNotBlank((CharSequence)jriDirectory)) {
                        File isisRConfigFile = new File("isisfish.jri");
                        try {
                            FileUtils.writeStringToFile((File)isisRConfigFile, (String)jriDirectory, (Charset)StandardCharsets.UTF_8);
                            result = true;
                        }
                        catch (IOException ex) {
                            log.error((Object)"Can't write isis configuration", (Throwable)ex);
                        }
                    } else {
                        this.rconfigUI.getInformationField().setBackground(ScriptHandler.COLOR_FAILURE);
                        this.rconfigUI.getInformationField().append(I18n.t((String)"isisfish.simulator.configuration.r.failurejri", (Object[])new Object[0]) + "\n");
                    }
                } else {
                    InputStream err = process.getErrorStream();
                    this.rconfigUI.getInformationField().setBackground(ScriptHandler.COLOR_FAILURE);
                    this.rconfigUI.getInformationField().append(IOUtils.toString((InputStream)err, (Charset)StandardCharsets.UTF_8) + "\n");
                }
            }
            catch (IOException ex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Can't find R", (Throwable)ex);
                }
            }
            catch (InterruptedException ex) {
                if (!log.isErrorEnabled()) break block10;
                log.error((Object)"Can't find R", (Throwable)ex);
            }
        }
        return result;
    }
}

