/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator.sensitivity;

import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.DiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.visitor.FactorVisitor;
import java.io.Serializable;
import org.jdesktop.beans.AbstractBean;
import org.nuiton.math.matrix.MatrixND;

public class Factor
extends AbstractBean
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1643804268013964453L;
    protected String name;
    protected String comment;
    protected Object identifier;
    protected Domain domain;
    protected Object nominalValue;
    protected Object value;
    protected String path;
    protected int cardinality;
    protected String equationVariableName;

    public Factor(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        String oldValue = this.name;
        this.name = name;
        this.firePropertyChange("name", oldValue, name);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        String oldValue = this.comment;
        this.comment = comment;
        this.firePropertyChange("comment", oldValue, comment);
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        Domain oldValue = this.domain;
        this.domain = domain;
        this.firePropertyChange("domain", oldValue, domain);
    }

    public Object getValue() {
        return this.value;
    }

    public Object getDisplayedValue() {
        Object result;
        if (this.equationVariableName != null) {
            result = "\"" + this.getValue() + "\"";
        } else {
            result = this.getValue();
            if (result instanceof MatrixND) {
                result = this.identifier;
            }
        }
        return result;
    }

    public void setValue(Object value) {
        Object oldValue = this.value;
        this.value = value;
        this.firePropertyChange("value", oldValue, value);
    }

    public void setValueForIdentifier(Object valueIdentifier) {
        this.identifier = valueIdentifier;
        this.value = this.domain.getValueForIdentifier(valueIdentifier);
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        String oldValue = this.path;
        this.path = path;
        this.firePropertyChange("path", oldValue, path);
    }

    public Object getNominalValue() {
        return this.nominalValue;
    }

    public void setNominalValue(Object nominalValue) {
        Object oldValue = this.nominalValue;
        this.nominalValue = nominalValue;
        this.firePropertyChange("nominalValue", oldValue, nominalValue);
    }

    public int getCardinality() {
        int result = this.cardinality;
        if (this.domain instanceof DiscreteDomain) {
            result = ((DiscreteDomain)this.domain).getValues().size();
        }
        return result;
    }

    public void setCardinality(int cardinality) {
        int oldValue = this.cardinality;
        this.cardinality = cardinality;
        this.firePropertyChange("cardinality", oldValue, cardinality);
    }

    public String getEquationVariableName() {
        return this.equationVariableName;
    }

    public void setEquationVariableName(String equationVariableName) {
        String oldValue = this.equationVariableName;
        this.equationVariableName = equationVariableName;
        this.firePropertyChange("equationVariableName", oldValue, equationVariableName);
    }

    public void accept(FactorVisitor visitor) {
        visitor.start(this);
        visitor.visit(this, this.domain);
        visitor.end(this);
    }

    public Object clone() {
        Factor f;
        try {
            f = (Factor)super.clone();
            if (this.domain != null) {
                f.domain = this.domain.clone();
            }
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error on clone()", e);
        }
        return f;
    }

    public String toString() {
        return "Factor : " + this.name + "(" + this.comment + ")";
    }
}

