/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.simulator;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.export.ExportInfo;
import fr.ifremer.isisfish.export.ExportStep;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.simulator.SimulationControl;
import fr.ifremer.isisfish.simulator.SimulationListener;
import fr.ifremer.isisfish.simulator.SimulationParameter;
import fr.ifremer.isisfish.types.TimeStep;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SimulationExportResultWrapper
implements SimulationListener {
    private static Log log = LogFactory.getLog(SimulationExportResultWrapper.class);
    protected TimeStep lastStep;
    protected Map<ExportInfo, ExportContext> allExports = new HashMap<ExportInfo, ExportContext>();

    @Override
    public void beforeSimulation(SimulationContext context) {
        List<SensitivityExport> sensitivityExports;
        SimulationStorage simulation = context.getSimulationStorage();
        SimulationParameter parameters = simulation.getParameter();
        File rootDirectory = simulation.getDirectory();
        File exportDir = SimulationStorage.getResultExportDirectory(rootDirectory);
        exportDir.mkdirs();
        if (parameters.getExportNames() != null) {
            for (String string : parameters.getExportNames()) {
                try {
                    ExportStorage exportStorage = ExportStorage.getExport(string, new CodeSourceStorage.Location[0]);
                    ExportInfo export = (ExportInfo)exportStorage.getNewInstance();
                    this.allExports.put(export, new ExportContext(export, exportDir));
                }
                catch (IsisFishException isisFishException) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)("Can't get export instance " + string), (Throwable)isisFishException);
                }
            }
        }
        if ((sensitivityExports = parameters.getSensitivityExport()) != null) {
            for (ExportInfo exportInfo : sensitivityExports) {
                this.allExports.put(exportInfo, new ExportContext(exportInfo, exportDir));
            }
        }
        Set<ExportInfo> set = parameters.getOptimizationExportsObservations().keySet();
        for (ExportInfo export : set) {
            String exportName = ExportStorage.getName(export);
            if (parameters.getExportNames() != null && parameters.getExportNames().contains(exportName)) continue;
            this.allExports.put(export, new ExportContext(export, exportDir));
        }
        for (ExportContext e : this.allExports.values()) {
            try {
                e.exportBegin(simulation);
            }
            catch (Exception eee) {
                if (log.isErrorEnabled()) {
                    log.error((Object)"Can't export results", (Throwable)eee);
                }
                e.setException(eee);
            }
        }
    }

    @Override
    public void stepChange(SimulationContext context, TimeStep step) {
        SimulationControl control = context.getSimulationControl();
        this.lastStep = step;
        step = step.previous();
        if (!this.allExports.isEmpty()) {
            control.setText(I18n.t((String)"isisfish.message.export.export", (Object[])new Object[0]));
            SimulationStorage simulation = context.getSimulationStorage();
            for (ExportContext e : this.allExports.values()) {
                try {
                    e.export(simulation, step);
                }
                catch (Exception eee) {
                    e.setException(eee);
                }
            }
        }
    }

    @Override
    public void afterSimulation(SimulationContext context) {
        SimulationControl control = context.getSimulationControl();
        if (!this.allExports.isEmpty()) {
            control.setText(I18n.t((String)"isisfish.message.export.export", (Object[])new Object[0]));
            SimulationStorage simulation = context.getSimulationStorage();
            for (ExportContext e : this.allExports.values()) {
                try {
                    e.export(simulation, this.lastStep);
                    e.export(simulation);
                }
                catch (Exception eee) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Can't export results", (Throwable)eee);
                    }
                    e.setException(eee);
                }
                try {
                    e.exportEnd(simulation);
                }
                catch (Exception eee) {
                    if (log.isErrorEnabled()) {
                        log.error((Object)"Can't export results", (Throwable)eee);
                    }
                    e.setException(eee);
                }
                e.close();
            }
            long writtenAll = 0L;
            long timeAll = 0L;
            for (ExportContext e : this.allExports.values()) {
                String exportName = ExportStorage.getName(e.export);
                writtenAll += e.bytes;
                timeAll += e.time;
                simulation.getInformation().addExportSize(exportName, e.bytes);
                simulation.getInformation().addExportTime(exportName, e.time);
                if (e.exception == null) continue;
                simulation.getInformation().addExportException(exportName, e.exception);
            }
            simulation.getInformation().addAllExportSize(writtenAll);
            simulation.getInformation().addAllExportTime(timeAll);
        }
    }

    private static class ExportContext {
        ExportInfo export;
        File exportDir;
        Writer out;
        CountingOutputStream counter;
        long time = 0L;
        long bytes = 0L;
        Exception exception = null;

        public ExportContext(ExportInfo export, File exportDir) {
            this.export = export;
            this.exportDir = exportDir;
        }

        public void close() {
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.counter != null) {
                this.bytes = this.counter.getByteCount();
            }
        }

        public Writer getOut() throws IOException {
            if (this.out == null) {
                String filename = this.export.getExportFilename();
                String extension = this.export.getExtensionFilename();
                if (!StringUtils.endsWithIgnoreCase((CharSequence)extension, (CharSequence)".gz") && IsisFish.config.getExportForceCompression()) {
                    extension = extension + ".gz";
                }
                File file = new File(this.exportDir, filename + extension);
                int val = 0;
                while (file.exists()) {
                    file = new File(this.exportDir, filename + extension + "_" + ++val);
                }
                OutputStream os = new FileOutputStream(file);
                this.counter = new CountingOutputStream(os);
                os = this.counter;
                if (StringUtils.endsWithIgnoreCase((CharSequence)extension, (CharSequence)".gz")) {
                    os = new GZIPOutputStream(os);
                }
                this.out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8)));
            }
            return this.out;
        }

        public void addTime(long time) {
            this.time += time;
        }

        public void exportBegin(SimulationStorage simulation) throws Exception {
            if (this.export instanceof ExportStep) {
                long timeStart = System.nanoTime();
                ((ExportStep)this.export).exportBegin(simulation, this.getOut());
                this.addTime(System.nanoTime() - timeStart);
            }
        }

        public void export(SimulationStorage simulation, TimeStep step) throws Exception {
            if (this.export instanceof ExportStep) {
                long timeStart = System.nanoTime();
                ((ExportStep)this.export).export(simulation, step, this.getOut());
                this.addTime(System.nanoTime() - timeStart);
            }
        }

        public void exportEnd(SimulationStorage simulation) throws Exception {
            if (this.export instanceof ExportStep) {
                long timeStart = System.nanoTime();
                ((ExportStep)this.export).exportEnd(simulation, this.getOut());
                this.addTime(System.nanoTime() - timeStart);
            }
        }

        public void export(SimulationStorage simulation) throws Exception {
            if (this.export instanceof Export) {
                long timeStart = System.nanoTime();
                ((Export)this.export).export(simulation, this.getOut());
                this.addTime(System.nanoTime() - timeStart);
            }
        }

        public void setException(Exception exception) {
            this.exception = exception;
        }
    }
}

