/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.map;

import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.FisheryRegion;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.IncludeFilter;

public class GeoTools {
    private static Log log = LogFactory.getLog(GeoTools.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<Cell> getCellFromShapefile(FisheryRegion fisheryRegion, Collection<Cell> cells, File mapFile) {
        HashSet<Cell> includedCells = new HashSet<Cell>();
        DataStore dataStore = null;
        try {
            HashMap<String, URL> map = new HashMap<String, URL>();
            map.put("url", mapFile.toURI().toURL());
            dataStore = DataStoreFinder.getDataStore(map);
            String typeName = dataStore.getTypeNames()[0];
            SimpleFeatureSource source = dataStore.getFeatureSource(typeName);
            IncludeFilter filter = Filter.INCLUDE;
            FeatureCollection collection = source.getFeatures((Filter)filter);
            try (FeatureIterator features = collection.features();){
                while (features.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)features.next();
                    Geometry geometry = (Geometry)feature.getDefaultGeometry();
                    GeometryFactory geometryFactory = new GeometryFactory();
                    for (Cell cell : cells) {
                        Coordinate coor1 = new Coordinate((double)cell.getLongitude(), (double)cell.getLatitude());
                        CoordinateArraySequence c = new CoordinateArraySequence(new Coordinate[]{coor1});
                        boolean included = geometry.contains((Geometry)new Point((CoordinateSequence)c, geometryFactory));
                        if (!included) {
                            Coordinate coor2 = new Coordinate((double)(cell.getLongitude() + fisheryRegion.getCellLengthLongitude()), (double)(cell.getLatitude() + fisheryRegion.getCellLengthLatitude()));
                            CoordinateArraySequence c2 = new CoordinateArraySequence(new Coordinate[]{coor2});
                            included = geometry.contains((Geometry)new Point((CoordinateSequence)c2, geometryFactory));
                        }
                        if (!included) {
                            Coordinate coor3 = new Coordinate((double)(cell.getLongitude() + fisheryRegion.getCellLengthLongitude() / 2.0f), (double)(cell.getLatitude() + fisheryRegion.getCellLengthLatitude() / 2.0f));
                            CoordinateArraySequence c3 = new CoordinateArraySequence(new Coordinate[]{coor3});
                            included = geometry.contains((Geometry)new Point((CoordinateSequence)c3, geometryFactory));
                        }
                        if (!included) continue;
                        includedCells.add(cell);
                    }
                }
            }
        }
        catch (IOException ex) {
            log.error((Object)"Can't parce shp file");
        }
        finally {
            if (dataStore != null) {
                dataStore.dispose();
            }
        }
        return includedCells;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setCellToShapefile(FisheryRegion fisheryRegion, List<Cell> cells, String name, File file) {
        try {
            SimpleFeatureType TYPE = DataUtilities.createType((String)name, (String)"the_geom:MultiPolygon:srid=4326");
            ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
            GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
            SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(TYPE);
            for (Cell cell : cells) {
                Polygon polygon = geometryFactory.createPolygon(new Coordinate[]{new Coordinate((double)cell.getLongitude(), (double)cell.getLatitude()), new Coordinate((double)cell.getLongitude(), (double)(cell.getLatitude() + fisheryRegion.getCellLengthLatitude())), new Coordinate((double)(cell.getLongitude() + fisheryRegion.getCellLengthLongitude()), (double)(cell.getLatitude() + fisheryRegion.getCellLengthLatitude())), new Coordinate((double)(cell.getLongitude() + fisheryRegion.getCellLengthLongitude()), (double)cell.getLatitude()), new Coordinate((double)cell.getLongitude(), (double)cell.getLatitude())});
                featureBuilder.add((Object)polygon);
                SimpleFeature feature = featureBuilder.buildFeature(null);
                features.add(feature);
            }
            ShapefileDataStoreFactory dataStoreFactory = new ShapefileDataStoreFactory();
            HashMap<String, Serializable> params = new HashMap<String, Serializable>();
            params.put("url", file.toURI().toURL());
            params.put("create spatial index", Boolean.TRUE);
            ShapefileDataStore newDataStore = (ShapefileDataStore)dataStoreFactory.createNewDataStore(params);
            newDataStore.createSchema(TYPE);
            DefaultTransaction transaction = new DefaultTransaction("create");
            String typeName = newDataStore.getTypeNames()[0];
            ContentFeatureSource featureSource = newDataStore.getFeatureSource(typeName);
            SimpleFeatureType SHAPE_TYPE = (SimpleFeatureType)featureSource.getSchema();
            if (featureSource instanceof SimpleFeatureStore) {
                SimpleFeatureStore featureStore = (SimpleFeatureStore)featureSource;
                ListFeatureCollection collection = new ListFeatureCollection(TYPE, features);
                featureStore.setTransaction((Transaction)transaction);
                try {
                    featureStore.addFeatures((FeatureCollection)collection);
                    transaction.commit();
                }
                catch (Exception problem) {
                    problem.printStackTrace();
                    transaction.rollback();
                }
                finally {
                    transaction.close();
                }
            } else {
                System.out.println(typeName + " does not support read/write access");
            }
            newDataStore.dispose();
        }
        catch (IOException | SchemaException e) {
            e.printStackTrace();
        }
    }
}

