/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.export;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.ExportStorage;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.datastore.StorageHelper;
import fr.ifremer.isisfish.export.Export;
import fr.ifremer.isisfish.export.ExportContext;
import fr.ifremer.isisfish.export.ExportInfo;
import fr.ifremer.isisfish.export.ExportStep;
import fr.ifremer.isisfish.export.SensitivityExport;
import fr.ifremer.isisfish.types.TimeStep;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;

public class ExportHelper
extends StorageHelper {
    private static final Log log = LogFactory.getLog(ExportHelper.class);

    @Deprecated
    public static void doExport(SimulationStorage simulation, File destdir, List<Export> exports, File compileDir) {
        long writtenAll = 0L;
        long timeStart = System.currentTimeMillis();
        for (Export export : exports) {
            long time;
            long written;
            String exportName;
            block3: {
                exportName = ExportStorage.getName(export);
                written = 0L;
                time = System.currentTimeMillis();
                try {
                    written = ExportHelper.exportToFile(simulation, destdir, export);
                    writtenAll += written;
                }
                catch (Exception eee) {
                    if (!log.isWarnEnabled()) break block3;
                    log.warn((Object)("Can't export object: " + exportName), (Throwable)eee);
                }
            }
            simulation.getInformation().addExportSize(exportName, written);
            simulation.getInformation().addExportTime(exportName, System.currentTimeMillis() - time);
        }
        simulation.getInformation().addAllExportSize(writtenAll);
        simulation.getInformation().addAllExportTime(System.currentTimeMillis() - timeStart);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    protected static long exportToFile(SimulationStorage simulation, File destdir, Export export) throws Exception {
        long result = 0L;
        String filename = export.getExportFilename();
        String extension = export.getExtensionFilename();
        if (!StringUtils.endsWithIgnoreCase((CharSequence)extension, (CharSequence)".gz") && IsisFish.config.getExportForceCompression()) {
            extension = extension + ".gz";
        }
        File file = new File(destdir, filename + extension);
        int val = 0;
        while (file.exists()) {
            file = new File(destdir, filename + extension + "_" + ++val);
        }
        PrintWriter out = null;
        CountingOutputStream counter = null;
        try {
            OutputStream os = new FileOutputStream(file);
            counter = new CountingOutputStream(os);
            os = counter;
            if (StringUtils.endsWithIgnoreCase((CharSequence)extension, (CharSequence)".gz")) {
                os = new GZIPOutputStream(os);
            }
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(os, StandardCharsets.UTF_8)));
            export.export(simulation, out);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(out);
            if (counter != null) {
                result = counter.getByteCount();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)out);
        if (counter != null) {
            result = counter.getByteCount();
        }
        return result;
    }

    public static void exportToFile(SimulationStorage simulationStorage, String exportName, File file) throws Exception {
        ExportStorage exportStorage = ExportStorage.getExport(exportName, new CodeSourceStorage.Location[0]);
        ExportInfo exportInfo = (ExportInfo)exportStorage.getNewInstance();
        ExportHelper.exportToFile(simulationStorage, exportInfo, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportToFile(SimulationStorage simulationStorage, ExportInfo exportInfo, File file) throws Exception {
        Writer out = null;
        try {
            ExportContext exportContext = ExportContext.get();
            exportContext.setSimulationStorage(simulationStorage);
            out = StringUtils.endsWithIgnoreCase((CharSequence)file.getName(), (CharSequence)".gz") ? new BufferedWriter(new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(file)), StandardCharsets.UTF_8)) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), StandardCharsets.UTF_8));
            if (exportInfo instanceof ExportStep) {
                ExportStep exportStep = (ExportStep)exportInfo;
                exportStep.exportBegin(simulationStorage, out);
                TimeStep lastStep = simulationStorage.getResultStorage().getLastStep();
                TimeStep step = new TimeStep(0);
                while (!step.after(lastStep)) {
                    exportStep.export(simulationStorage, step, out);
                    step = step.next();
                }
                exportStep.exportEnd(simulationStorage, out);
            } else {
                Export export = (Export)exportInfo;
                export.export(simulationStorage, out);
            }
        }
        finally {
            ExportContext.remove();
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void populateSensitivityExport(int exportIndex, TopiaContext context, SensitivityExport export, Properties props) {
        ExportHelper.populateStorageParams(exportIndex, context, export, props, "sensitivityexport");
    }

    public static Properties getSensitivityExportAsProperties(int sensitivityExportIndex, TopiaContext context, SensitivityExport sensitivityExport) {
        return ExportHelper.getParamsAsProperties(sensitivityExportIndex, context, sensitivityExport, "sensitivityexport");
    }
}

