/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.entities;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import fr.ifremer.isisfish.config.IsisConfig;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.RangeOfValues;
import fr.ifremer.isisfish.types.TimeUnit;
import fr.ifremer.isisfish.util.matrix.EntitySemanticsDecorator;
import fr.ifremer.isisfish.util.matrix.MatrixCSVHelper;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;

public class RegionExportJson
implements EntityVisitor {
    private static Log log = LogFactory.getLog(RegionExportJson.class);
    public static final int FORMAT_VERSION = 1;
    public static final String FORMAT_EXTENSION = ".isis.json.gz";
    protected LinkedList<TopiaEntity> toVisit;
    protected Set<String> visited;
    protected LinkedHashMap<String, List<String>> isisEntities;
    protected boolean doVisit = false;
    protected MatrixCSVHelper matrixCSVHelper;
    protected EntitySemanticsDecorator decorator;
    protected JsonGenerator g;

    public RegionExportJson(Writer w) {
        try {
            JsonFactory f = new JsonFactory();
            this.g = f.createGenerator(w);
            this.toVisit = new LinkedList();
            this.visited = new HashSet<String>();
            this.decorator = new EntitySemanticsDecorator();
            this.matrixCSVHelper = new MatrixCSVHelper(this.decorator);
            this.isisEntities = new LinkedHashMap();
            this.isisEntities.put("FisheryRegion", new ArrayList());
            this.isisEntities.put("Cell", new ArrayList());
            this.isisEntities.put("Zone", new ArrayList());
            this.isisEntities.put("Port", new ArrayList());
            this.isisEntities.put("Species", new ArrayList());
            this.isisEntities.put("Population", new ArrayList());
            this.isisEntities.put("Gear", new ArrayList());
            this.isisEntities.put("Metier", new ArrayList());
            this.isisEntities.put("TripType", new ArrayList());
            this.isisEntities.put("VesselType", new ArrayList());
            this.isisEntities.put("SetOfVessels", new ArrayList());
            this.isisEntities.put("Strategy", new ArrayList());
            this.isisEntities.put("Observation", new ArrayList());
        }
        catch (IOException eee) {
            throw new RuntimeException(eee);
        }
    }

    public void export(FisheryRegion fisheryRegion) {
        this.toVisit.addAll(fisheryRegion.getCell());
        this.toVisit.addAll(fisheryRegion.getZone());
        this.toVisit.addAll(fisheryRegion.getPort());
        this.toVisit.addAll(fisheryRegion.getSpecies());
        this.toVisit.addAll(fisheryRegion.getGear());
        this.toVisit.addAll(fisheryRegion.getMetier());
        this.toVisit.addAll(fisheryRegion.getTripType());
        this.toVisit.addAll(fisheryRegion.getVesselType());
        this.toVisit.addAll(fisheryRegion.getSetOfVessels());
        this.toVisit.addAll(fisheryRegion.getStrategy());
        this.toVisit.addAll(fisheryRegion.getObservations());
        this.export((TopiaEntity)fisheryRegion, true);
    }

    public void export(TopiaEntity entity) {
        if (entity instanceof FisheryRegion) {
            this.export((FisheryRegion)entity);
        } else {
            this.export(entity, false);
        }
    }

    protected void export(TopiaEntity entity, boolean isRegion) {
        try {
            this.start();
            this.g.writeObjectFieldStart("#info");
            this.g.writeNumberField("formatVersion", 1);
            this.g.writeStringField("isisVersion", IsisConfig.getVersion());
            this.g.writeBooleanField("region", isRegion);
            this.g.writeStringField("root", entity.toString());
            this.g.writeStringField("rootId", entity.getTopiaId());
            this.g.writeEndObject();
            this.g.writeObjectFieldStart("#entities");
            this.toVisit.push(entity);
            while (this.toVisit.peek() != null) {
                TopiaEntity e;
                while ((e = this.toVisit.poll()) != null) {
                    e.accept((EntityVisitor)this);
                }
                Collection<Object> decoratedObject = this.decorator.getDecoratedObject();
                for (Object o : decoratedObject) {
                    if (!(o instanceof TopiaEntity) || this.visited.contains(((TopiaEntity)o).getTopiaId())) continue;
                    this.toVisit.add((TopiaEntity)o);
                }
            }
            this.g.writeEndObject();
            this.end();
        }
        catch (IOException eee) {
            throw new RuntimeException(eee);
        }
    }

    protected void writeValue(Class<?> type, Object value) {
        try {
            if (value == null) {
                this.g.writeNull();
            } else if (TopiaEntity.class.isAssignableFrom(type)) {
                this.g.writeString(((TopiaEntity)value).getTopiaId());
                this.toVisit.add((TopiaEntity)value);
            } else if (MatrixND.class.isAssignableFrom(type)) {
                MatrixND m = (MatrixND)value;
                String s = this.matrixCSVHelper.writeMatrix(m.getName(), m);
                this.g.writeString(s);
            } else if (TimeUnit.class.isAssignableFrom(type)) {
                this.g.writeNumber(((TimeUnit)value).getTime());
            } else if (RangeOfValues.class.isAssignableFrom(type)) {
                this.g.writeString(((RangeOfValues)value).getAsString());
            } else if (Month.class.isAssignableFrom(type)) {
                this.g.writeNumber(((Month)value).getMonthNumber());
            } else if (Number.class.isAssignableFrom(type) || value instanceof Number) {
                this.g.writeNumber(((Number)value).doubleValue());
            } else if (String.class.isAssignableFrom(type)) {
                this.g.writeString((String)value);
            } else if (Boolean.class.isAssignableFrom(type) || value instanceof Boolean) {
                this.g.writeBoolean(((Boolean)value).booleanValue());
            } else if (Class.class.isAssignableFrom(type)) {
                this.g.writeString(((Class)value).getName());
            } else {
                String message = String.format("Unsupported type: '%s' value class '%s' value '%s'", type, value.getClass().getName(), value);
                log.error((Object)message);
                this.g.writeString(message);
            }
        }
        catch (IOException eee) {
            throw new RuntimeException(eee);
        }
    }

    public void start() {
        try {
            this.g.writeStartObject();
        }
        catch (IOException eee) {
            throw new RuntimeException(eee);
        }
    }

    public void end() {
        try {
            for (Map.Entry<String, List<String>> e : this.isisEntities.entrySet()) {
                this.g.writeArrayFieldStart(e.getKey());
                for (String id : e.getValue()) {
                    this.g.writeString(id);
                }
                this.g.writeEndArray();
            }
            this.g.writeEndObject();
            this.g.close();
        }
        catch (IOException eee) {
            throw new RuntimeException(eee);
        }
    }

    public void start(TopiaEntity entity) {
        try {
            String id = entity.getTopiaId();
            boolean bl = this.doVisit = !this.visited.contains(id);
            if (this.doVisit) {
                this.visited.add(id);
                this.g.writeObjectFieldStart(id);
                String className = entity.getClass().getName();
                String name = StringUtils.removeEnd((String)entity.getClass().getSimpleName(), (String)"Impl");
                List<String> list = this.isisEntities.get(name);
                if (list != null) {
                    list.add(id);
                }
                this.g.writeStringField("#class", className);
                this.g.writeStringField("#id", id);
                this.g.writeStringField("#toString", entity.toString());
            }
        }
        catch (IOException eee) {
            throw new RuntimeException(eee);
        }
    }

    public void end(TopiaEntity entity) {
        try {
            if (this.doVisit) {
                this.g.writeEndObject();
            }
        }
        catch (IOException eee) {
            throw new RuntimeException(eee);
        }
    }

    public void visit(TopiaEntity entity, String propertyName, Class<?> type, Object value) {
        try {
            if (this.doVisit) {
                this.g.writeFieldName(propertyName);
                this.writeValue(type, value);
            }
        }
        catch (IOException eee) {
            throw new RuntimeException(eee);
        }
    }

    public void visit(TopiaEntity entity, String propertyName, Class<?> collectionType, Class<?> type, Object value) {
        try {
            if (this.doVisit) {
                this.g.writeFieldName(propertyName);
                this.g.writeStartArray();
                if (value != null) {
                    for (Object currentValue : (Collection)value) {
                        this.writeValue(type, currentValue);
                    }
                }
                this.g.writeEndArray();
            }
        }
        catch (IOException eee) {
            throw new RuntimeException(eee);
        }
    }

    public void visit(TopiaEntity entity, String propertyName, Class<?> collectionType, Class<?> type, int index, Object value) {
        if (this.doVisit) {
            throw new UnsupportedOperationException("FIXME a faire, implantation des properties array");
        }
    }

    public void clear() {
        this.toVisit = null;
        this.visited = null;
        this.isisEntities = null;
        this.matrixCSVHelper = null;
        this.decorator = null;
    }
}

