/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.vcs;

import fr.ifremer.isisfish.util.ssh.InvalidPassphraseException;
import fr.ifremer.isisfish.util.ssh.SSHAgent;
import fr.ifremer.isisfish.vcs.AbstractVCS;
import fr.ifremer.isisfish.vcs.VCS;
import fr.ifremer.isisfish.vcs.VCSActionEvent;
import fr.ifremer.isisfish.vcs.VCSException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.version.Version;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.ISVNStatusHandler;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNCommitClient;
import org.tmatesoft.svn.core.wc.SVNConflictChoice;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNLogClient;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusClient;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNUpdateClient;
import org.tmatesoft.svn.core.wc.SVNWCClient;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class VCSSVN
extends AbstractVCS {
    protected static Log log = LogFactory.getLog(VCSSVN.class);
    protected SVNClientManager svnManager = null;
    protected ConnectionState connectionState = ConnectionState.NOT_TESTED;

    public VCSSVN(File localRepository, String protocol, String host, String path, File sshKeyFile, String login, String password) {
        super(localRepository, protocol, host, path, sshKeyFile, login, password);
        if (protocol.startsWith("file")) {
            FSRepositoryFactory.setup();
        } else if (protocol.startsWith("http")) {
            DAVRepositoryFactory.setup();
        } else {
            SVNRepositoryFactoryImpl.setup();
        }
    }

    protected SVNClientManager getSVNManager() {
        if (this.svnManager == null) {
            ISVNAuthenticationManager auth;
            block12: {
                if (log.isInfoEnabled()) {
                    try {
                        log.info((Object)("Try to connect to " + this.getRemoteURL()));
                    }
                    catch (SVNException e) {
                        if (!log.isErrorEnabled()) break block12;
                        log.error((Object)"Can't get remote repo url");
                    }
                }
            }
            String login = this.getLogin();
            String password = this.getPassword();
            char[] passwd = password != null ? password.toCharArray() : null;
            DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
            if (this.getProtocol().contains("ssh")) {
                if (this.sshKeyFile != null && this.sshKeyFile.canRead()) {
                    char[] passphrase;
                    block13: {
                        if (log.isInfoEnabled()) {
                            log.info((Object)("Using ssh private key : " + this.sshKeyFile.getAbsolutePath()));
                        }
                        passphrase = null;
                        try {
                            passphrase = SSHAgent.getAgent().getPassphrase(this.sshKeyFile);
                        }
                        catch (InvalidPassphraseException e) {
                            if (!log.isWarnEnabled()) break block13;
                            log.warn((Object)"Can't get passphrase for key", (Throwable)e);
                        }
                    }
                    auth = SVNWCUtil.createDefaultAuthenticationManager((File)SVNWCUtil.getDefaultConfigurationDirectory(), (String)login, null, (File)this.sshKeyFile, (char[])passphrase, (boolean)true);
                } else {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)("Cannot read ssh private key : " + this.sshKeyFile));
                    }
                    auth = SVNWCUtil.createDefaultAuthenticationManager((File)SVNWCUtil.getDefaultConfigurationDirectory(), (String)login, (char[])passwd);
                }
            } else {
                auth = SVNWCUtil.createDefaultAuthenticationManager((String)login, (char[])passwd);
            }
            this.svnManager = SVNClientManager.newInstance((ISVNOptions)options, (ISVNAuthenticationManager)auth);
        }
        return this.svnManager;
    }

    @Override
    public boolean isValidLocalRepository() {
        File local = this.getLocalRepository();
        File svn = new File(local, ".svn");
        boolean result = svn.exists();
        return result;
    }

    @Override
    public boolean isConnected() {
        if (this.connectionState == ConnectionState.NOT_TESTED) {
            try {
                SVNURL url = this.getRemoteURL();
                this.getSVNManager().getWCClient().doGetProperty(url, "", SVNRevision.HEAD, SVNRevision.HEAD);
                this.connectionState = ConnectionState.ON_LINE;
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n.t((String)"isisfish.vcs.vcssvn.isconnected.switchto", (Object[])new Object[]{this.getRemoteRepository()}));
                }
            }
            catch (SVNException eee) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)I18n.t((String)"isisfish.vcs.vcssvn.isconnected.switchoff", (Object[])new Object[]{this.getRemoteRepository()}), (Throwable)eee);
                }
                this.connectionState = ConnectionState.OFF_LINE;
            }
        }
        boolean result = this.connectionState == ConnectionState.ON_LINE;
        return result;
    }

    @Override
    public void checkProtocol() throws VCSException {
        try {
            File localRoot = this.getLocalRepository();
            SVNInfo info = this.getSVNManager().getWCClient().doInfo(localRoot, SVNRevision.WORKING);
            SVNURL url = info.getURL();
            SVNURL newUrl = this.getRemoteURL();
            newUrl = newUrl.setPath(url.getPath(), false);
            if ((!url.getProtocol().equals(newUrl.getProtocol()) || url.getUserInfo() == null && newUrl.getUserInfo() != url.getUserInfo() || url.getUserInfo() != null && !url.getUserInfo().equals(newUrl.getUserInfo()) || url.getPort() != newUrl.getPort() || !url.getHost().equals(newUrl.getHost())) && this.fireAction(VCSActionEvent.SWITCH_PROTOCOL, new File[0])) {
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n.t((String)"isisfish.vcs.vcssvn.checkProtocol.relocate", (Object[])new Object[]{localRoot, url, newUrl}));
                }
                this.getSVNManager().getUpdateClient().doRelocate(localRoot, url, newUrl, true);
            }
        }
        catch (SVNException e) {
            throw new VCSException(I18n.t((String)"isisfish.vcs.vcssvn.checkProtocol.error", (Object[])new Object[0]), e);
        }
    }

    @Override
    public List<File> checkFileStatus() throws VCSException {
        List<File> fileInConflict = null;
        Map<File, SVNStatus> status = this.getRemoteStatus(null, true);
        status.putAll(this.getLocalStatus(null, true, SVNStatusType.STATUS_MISSING));
        if (status.size() > 0 && this.fireAction(VCSActionEvent.UPDATE_REPOSITORY, status.keySet().toArray(new File[0]))) {
            fileInConflict = this.update(null, true);
        }
        return fileInConflict;
    }

    protected SVNURL getRemoteURL() throws SVNException {
        SVNURL remoteURL = SVNURL.parseURIEncoded((String)this.getRemoteRepository());
        return remoteURL;
    }

    public String getRemoteRepository() {
        String result;
        String proto = this.getProtocol();
        String user = this.getLogin();
        String host = this.getHost();
        String path = this.getPath();
        if (proto.startsWith("file")) {
            result = proto + "://" + path;
        } else {
            if (user == null) {
                user = "";
            } else if (!"".equals(user)) {
                user = user + "@";
            }
            result = proto + "://" + user + host + path;
        }
        return result;
    }

    @Override
    public boolean isVersionnableFile(File file) {
        boolean result = super.isVersionnableFile(file);
        if (result) {
            ISVNOptions svnOptions = this.getSVNManager().getOptions();
            result &= !DefaultSVNOptions.isIgnored((ISVNOptions)svnOptions, (String)file.getAbsolutePath());
        }
        return result;
    }

    @Override
    public void cleanup(File path) throws VCSException {
        File localFile = path;
        if (localFile == null) {
            localFile = this.getLocalRepository();
        }
        SVNWCClient wcClient = this.getSVNManager().getWCClient();
        try {
            wcClient.doCleanup(localFile);
        }
        catch (SVNException e) {
            throw new VCSException(I18n.t((String)"isisfish.vcs.vcssvn.cleanup.error", (Object[])new Object[0]), e);
        }
    }

    @Override
    public void commit(List<File> files, String msg) throws VCSException {
        if (!this.isWriteable()) {
            throw new VCSException(I18n.t((String)"isisfish.vcs.vcssvn.commit.errorreadonly", (Object[])new Object[0]));
        }
        List<File> localFiles = files;
        if (localFiles == null) {
            localFiles = Arrays.asList(this.getLocalRepository());
        }
        if (this.fireAction(VCSActionEvent.COMMIT, localFiles.toArray(new File[0]))) {
            this.commitWithoutCheck(localFiles, msg);
        }
    }

    protected void commitWithoutCheck(List<File> files, String msg) throws VCSException {
        try {
            SVNCommitClient commitClient = this.getSVNManager().getCommitClient();
            File[] filesToCommit = files.toArray(new File[0]);
            SVNCommitInfo commitInfo = commitClient.doCommit(filesToCommit, false, msg, null, null, false, false, SVNDepth.INFINITY);
            if (log.isInfoEnabled()) {
                log.info((Object)I18n.t((String)"isisfish.vcs.vcssvn.global.torevision", (Object[])new Object[]{commitInfo.getNewRevision()}));
            }
        }
        catch (SVNException e) {
            throw new VCSException(I18n.t((String)"isisfish.vcs.vcssvn.commit.error", (Object[])new Object[0]), e);
        }
    }

    @Override
    public void add(List<File> files, String msg) throws VCSException {
        if (!this.isWriteable()) {
            throw new VCSException(I18n.t((String)"isisfish.vcs.vcssvn.add.errorreadonly", (Object[])new Object[0]));
        }
        try {
            if (this.fireAction(VCSActionEvent.ADD, files.toArray(new File[0]))) {
                for (File file : files) {
                    SVNWCClient wcClient = this.getSVNManager().getWCClient();
                    wcClient.doAdd(file, true, false, true, SVNDepth.EMPTY, false, true);
                }
                this.commitWithoutCheck(files, msg);
            }
        }
        catch (SVNException eee) {
            throw new VCSException(I18n.t((String)"isisfish.vcs.vcssvn.add.error", (Object[])new Object[0]), eee);
        }
    }

    @Override
    public void checkout(Version tag, boolean recurse) throws VCSException {
        try {
            if (this.fireAction(VCSActionEvent.CHECKOUT, this.getLocalRepository())) {
                String tagPath = "/trunk/";
                if (tag != null) {
                    tagPath = "/tags/" + tag + "/";
                }
                SVNURL source = this.getRemoteURL().appendPath(tagPath, false);
                File destDir = this.getLocalRepository();
                destDir.mkdirs();
                SVNUpdateClient updateClient = this.getSVNManager().getUpdateClient();
                long newRevision = updateClient.doCheckout(source, destDir, null, SVNRevision.HEAD, SVNDepth.INFINITY, true);
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n.t((String)"isisfish.vcs.vcssvn.global.torevision", (Object[])new Object[]{newRevision}));
                }
            }
        }
        catch (SVNException eee) {
            throw new VCSException(I18n.t((String)"isisfish.vcs.vcssvn.checkout.error", (Object[])new Object[0]), eee);
        }
    }

    @Override
    public void delete(List<File> files, String msg) throws VCSException {
        if (!this.isWriteable()) {
            throw new VCSException(I18n.t((String)"isisfish.vcs.vcssvn.delete.errorreadonly", (Object[])new Object[0]));
        }
        try {
            if (this.fireAction(VCSActionEvent.DELETE, files.toArray(new File[0]))) {
                for (File file : files) {
                    this.getSVNManager().getWCClient().doDelete(file, true, true, false);
                }
                this.commitWithoutCheck(files, msg);
            }
        }
        catch (SVNException eee) {
            throw new VCSException(I18n.t((String)"isisfish.vcs.vcssvn.delete.error", (Object[])new Object[0]), eee);
        }
    }

    @Override
    public VCS.Status getLocalStatus(File file) throws VCSException {
        VCS.Status resultStatus = VCS.Status.STATUS_NORMAL;
        try {
            SVNStatusClient statusClient = this.getSVNManager().getStatusClient();
            SVNStatusType svnStatus = statusClient.doStatus(file, false).getNodeStatus();
            if (svnStatus == SVNStatusType.STATUS_MODIFIED) {
                resultStatus = VCS.Status.STATUS_MODIFIED;
            } else if (svnStatus == SVNStatusType.STATUS_DELETED) {
                resultStatus = VCS.Status.STATUS_DELETED;
            } else if (svnStatus == SVNStatusType.STATUS_ADDED || svnStatus == SVNStatusType.STATUS_UNVERSIONED) {
                resultStatus = VCS.Status.STATUS_ADDED;
            }
        }
        catch (SVNException e) {
            throw new VCSException("Can't get local status", e);
        }
        return resultStatus;
    }

    protected Map<File, SVNStatus> getLocalStatus(File file, boolean recurse, SVNStatusType ... wanted) throws VCSException {
        try {
            File localFile = file;
            if (localFile == null) {
                localFile = this.getLocalRepository();
            }
            HashMap<File, SVNStatus> result = new HashMap<File, SVNStatus>();
            HashSet<SVNStatusType> acceptedStatusType = new HashSet<SVNStatusType>(Arrays.asList(wanted));
            ISVNStatusHandler handler = status -> {
                File statusFile;
                if ((acceptedStatusType.isEmpty() && status.getNodeStatus() != SVNStatusType.STATUS_NONE && status.getNodeStatus() != SVNStatusType.STATUS_NORMAL || acceptedStatusType.contains(status.getNodeStatus())) && (!(statusFile = status.getFile()).isDirectory() || status.getRemoteNodeStatus() == SVNStatusType.STATUS_ADDED || status.getRemoteNodeStatus() == SVNStatusType.STATUS_DELETED)) {
                    result.put(statusFile, status);
                }
            };
            SVNStatusClient statusClient = this.getSVNManager().getStatusClient();
            statusClient.doStatus(localFile, SVNRevision.WORKING, SVNDepth.INFINITY, false, !acceptedStatusType.contains(SVNStatusType.STATUS_NORMAL), acceptedStatusType.contains(SVNStatusType.STATUS_IGNORED), false, handler, null);
            return result;
        }
        catch (SVNException eee) {
            throw new VCSException(I18n.t((String)"isisfish.vcs.vcssvn.localstatus.error", (Object[])new Object[0]), eee);
        }
    }

    protected Map<File, SVNStatus> getRemoteStatus(File file, boolean recurse) throws VCSException {
        try {
            File localFile = file;
            if (localFile == null) {
                localFile = this.getLocalRepository();
            }
            HashMap<File, SVNStatus> result = new HashMap<File, SVNStatus>();
            ISVNStatusHandler handler = status -> {
                File statusFile;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Status on file " + status.getFile() + " rstatus:" + status.getRemoteNodeStatus() + " lstatus:" + status.getNodeStatus()));
                }
                if (!(status.getRemoteNodeStatus().equals(SVNStatusType.STATUS_NONE) || status.getRemoteNodeStatus().equals(SVNStatusType.STATUS_NORMAL) || (statusFile = status.getFile()).isDirectory() && !status.getRemoteNodeStatus().equals(SVNStatusType.STATUS_ADDED) && !status.getRemoteNodeStatus().equals(SVNStatusType.STATUS_DELETED))) {
                    result.put(statusFile, status);
                }
            };
            SVNStatusClient statusClient = this.getSVNManager().getStatusClient();
            statusClient.doStatus(localFile, SVNRevision.HEAD, SVNDepth.INFINITY, true, true, false, true, handler, null);
            return result;
        }
        catch (SVNException eee) {
            throw new VCSException(I18n.t((String)"isisfish.vcs.vcssvn.remotestatus.error", (Object[])new Object[0]), eee);
        }
    }

    @Override
    public Map<File, String> getChanglog(List<File> files) throws VCSException {
        HashMap<File, String> changLog = new HashMap<File, String>();
        try {
            SVNInfo info = this.getSVNManager().getWCClient().doInfo(this.getLocalRepository(), SVNRevision.WORKING);
            String repoPath = info.getURL().getPath();
            String repoRootPath = info.getRepositoryRootURL().getPath();
            ISVNLogEntryHandler handler = logEntry -> {
                for (Map.Entry entry : logEntry.getChangedPaths().entrySet()) {
                    String path = (String)entry.getKey();
                    SVNLogEntryPath value = (SVNLogEntryPath)entry.getValue();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("path changed : " + path + " =  [" + value.getType() + "] " + logEntry.getMessage()));
                    }
                    String relativePath = SVNPathUtil.getRelativePath((String)repoPath, (String)(repoRootPath + path));
                    File file = new File(this.getLocalRepository().getAbsoluteFile() + File.separator + relativePath);
                    changLog.put(file, logEntry.getMessage());
                }
            };
            File[] filesToGetLog = files.toArray(new File[0]);
            SVNLogClient logClient = this.getSVNManager().getLogClient();
            logClient.doLog(filesToGetLog, SVNRevision.WORKING, SVNRevision.HEAD, false, true, 20L, handler);
        }
        catch (SVNException e) {
            throw new VCSException(I18n.t((String)"Can't get changlog", (Object[])new Object[0]), e);
        }
        return changLog;
    }

    @Override
    public String getDiff(File file) throws VCSException {
        String diff;
        try (ByteArrayOutputStream byte1 = new ByteArrayOutputStream();){
            SVNDiffClient diffClient = this.getSVNManager().getDiffClient();
            diffClient.doDiff(file, SVNRevision.HEAD, file, SVNRevision.WORKING, SVNDepth.IMMEDIATES, false, (OutputStream)byte1, null);
            diff = byte1.toString(StandardCharsets.UTF_8.name());
        }
        catch (IOException | SVNException e) {
            throw new VCSException(I18n.t((String)"isisfish.vcs.vcssvn.diff.error", (Object[])new Object[0]), e);
        }
        return diff;
    }

    @Override
    public List<String> getFileList(File directory) throws VCSException {
        File localFile = directory;
        if (localFile == null) {
            localFile = this.getLocalRepository();
        }
        ArrayList<String> files = new ArrayList<String>();
        ISVNDirEntryHandler handler = dirEntry -> {
            String path = dirEntry.getRelativePath();
            if (!path.isEmpty()) {
                files.add(path);
            }
        };
        try {
            SVNLogClient logClient = this.getSVNManager().getLogClient();
            logClient.doList(localFile, SVNRevision.HEAD, SVNRevision.HEAD, false, SVNDepth.IMMEDIATES, -1, handler);
        }
        catch (SVNException e) {
            throw new VCSException(I18n.t((String)"isisfish.vcs.vcssvn.list.error", (Object[])new Object[0]), e);
        }
        return files;
    }

    @Override
    public List<File> getUpdatedFile() throws VCSException {
        try {
            ArrayList<File> result = new ArrayList<File>();
            ISVNStatusHandler handler = status -> {
                if (log.isDebugEnabled()) {
                    log.debug((Object)I18n.t((String)"isisfish.vcs.vcssvn.global.filestatus", (Object[])new Object[]{status.getFile().getAbsolutePath(), status.getRemoteNodeStatus().toString()}));
                }
                if (status.getRemoteNodeStatus() == SVNStatusType.STATUS_ADDED || status.getRemoteNodeStatus() == SVNStatusType.STATUS_MODIFIED) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)I18n.t((String)"isisfish.vcs.vcssvn.global.foundUpdatedFile", (Object[])new Object[]{status.getFile().getAbsolutePath()}));
                    }
                    result.add(status.getFile());
                }
            };
            SVNStatusClient statusClient = this.getSVNManager().getStatusClient();
            statusClient.doStatus(this.getLocalRepository(), SVNRevision.HEAD, SVNDepth.INFINITY, true, true, false, true, handler, null);
            return result;
        }
        catch (SVNException eee) {
            throw new VCSException(I18n.t((String)"isisfish.vcs.vcssvn.getupdate.error", (Object[])new Object[0]), eee);
        }
    }

    @Override
    public boolean haveUpdate() throws VCSException {
        List<File> updatedFiles = this.getUpdatedFile();
        boolean result = false;
        if (updatedFiles != null && !updatedFiles.isEmpty()) {
            result = true;
        }
        return result;
    }

    @Override
    public boolean isOnRemote(File file) throws VCSException {
        boolean isOnRemote;
        block5: {
            File localFile = file;
            if (localFile == null) {
                localFile = this.getLocalRepository();
            }
            isOnRemote = false;
            try {
                SVNStatusClient statusClient = this.getSVNManager().getStatusClient();
                SVNStatus status = statusClient.doStatus(localFile, true);
                SVNStatusType localStatus = status.getNodeStatus();
                SVNStatusType remoteStatus = status.getRemoteNodeStatus();
                if (log.isDebugEnabled()) {
                    log.debug((Object)I18n.t((String)"isisfish.vcs.vcssvn.global.filelocalandremotestatus", (Object[])new Object[]{localFile.getAbsolutePath(), localStatus, remoteStatus}));
                }
                if (!(localStatus.equals(SVNStatusType.STATUS_ADDED) || remoteStatus.equals(SVNStatusType.STATUS_UNVERSIONED) || remoteStatus.equals(SVNStatusType.STATUS_DELETED))) {
                    isOnRemote = true;
                }
            }
            catch (SVNException e) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)I18n.t((String)"isisfish.vcs.vcssvn.isonremote.error", (Object[])new Object[]{localFile.getAbsolutePath()}), (Throwable)e);
            }
        }
        return isOnRemote;
    }

    @Override
    public boolean isUpToDate(File file) throws VCSException {
        File localFile = file;
        if (localFile == null) {
            localFile = this.getLocalRepository();
        }
        boolean isUpToDate = false;
        try {
            SVNStatusClient statusClient = this.getSVNManager().getStatusClient();
            SVNStatus status = statusClient.doStatus(localFile, true);
            SVNStatusType localStatus = status.getNodeStatus();
            SVNStatusType remoteStatus = status.getRemoteNodeStatus();
            if (localStatus == SVNStatusType.STATUS_NORMAL && remoteStatus == SVNStatusType.STATUS_NONE) {
                isUpToDate = true;
            }
        }
        catch (SVNException eee) {
            throw new VCSException(I18n.t((String)"isisfish.vcs.vcssvn.isuptodate.error", (Object[])new Object[0]), eee);
        }
        return isUpToDate;
    }

    @Override
    public List<File> update(File file, boolean recurse) throws VCSException {
        ArrayList<File> result = new ArrayList<File>();
        try {
            File localFile = file;
            if (localFile == null) {
                localFile = this.getLocalRepository();
            }
            if (!this.accept(localFile)) {
                throw new VCSException(I18n.t((String)"isisfish.vcs.vcssvn.update.notinlocal", (Object[])new Object[0]));
            }
            if (this.fireAction(VCSActionEvent.UPDATE, localFile)) {
                Map<File, SVNStatus> status;
                if (!localFile.getParentFile().exists()) {
                    this.update(localFile.getParentFile(), false);
                }
                SVNUpdateClient updateClient = this.getSVNManager().getUpdateClient();
                long newRevision = updateClient.doUpdate(localFile, SVNRevision.HEAD, recurse ? SVNDepth.INFINITY : SVNDepth.FILES, true, false);
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n.t((String)"isisfish.vcs.vcssvn.global.torevision", (Object[])new Object[]{newRevision}));
                }
                if ((status = this.getLocalStatus(localFile, recurse, SVNStatusType.STATUS_CONFLICTED)).size() > 0) {
                    result.addAll(status.keySet());
                    SVNWCClient wcClient = this.getSVNManager().getWCClient();
                    wcClient.doResolve(localFile, recurse ? SVNDepth.INFINITY : SVNDepth.FILES, SVNConflictChoice.MERGED);
                }
            }
        }
        catch (SVNException e) {
            throw new VCSException(I18n.t((String)"isisfish.vcs.vcssvn.update.error", (Object[])new Object[0]), e);
        }
        return result;
    }

    @Override
    public boolean isWriteable() throws VCSException {
        boolean result = this.writeable;
        if (this.writeable) {
            String login = this.getLogin();
            result = result && login != null && !"".equals(login) && !"anonymous".equals(login);
            result = result || this.getProtocol().startsWith("file");
            result = result && this.isValidLocalRepository();
        }
        return result;
    }

    @Override
    public boolean isTag(Version version) throws VCSException {
        boolean result;
        boolean bl = result = version == null;
        if (!result) {
            try {
                SVNURL url = this.getRemoteURL();
                url = url.appendPath("tags/" + version, true);
                SVNInfo info = this.getSVNManager().getWCClient().doInfo(url, SVNRevision.HEAD, SVNRevision.HEAD);
                result = info != null;
            }
            catch (SVNException eee) {
                log.debug((Object)I18n.t((String)"isisfish.vcs.vcssvn.istag.notexist", (Object[])new Object[]{version}));
            }
        }
        return result;
    }

    @Override
    public String getTag() throws VCSException {
        try {
            File localRoot = this.getLocalRepository();
            SVNInfo info = this.getSVNManager().getWCClient().doInfo(localRoot, SVNRevision.WORKING);
            String url = info.getURL().toDecodedString();
            String result = "/trunk";
            if (!url.endsWith("/trunk")) {
                int i = url.lastIndexOf("/");
                i = url.lastIndexOf("/", i - 1);
                result = url.substring(i);
            }
            return result;
        }
        catch (SVNException eee) {
            throw new VCSException(I18n.t((String)"isisfish.vcs.vcssvn.gettag.error", (Object[])new Object[0]), eee);
        }
    }

    @Override
    public List<File> setTag(Version version) throws VCSException {
        ArrayList<File> filesInConflict = null;
        try {
            String currentTag;
            String tag = "/trunk";
            if (version != null) {
                tag = "/tags/" + version;
            }
            if (!tag.equals(currentTag = this.getTag()) && this.fireAction(VCSActionEvent.SWITCH, new File[0])) {
                Map<File, SVNStatus> status;
                File localRoot = this.getLocalRepository();
                SVNURL newUrl = this.getRemoteURL();
                newUrl = newUrl.appendPath(tag, true);
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n.t((String)"isisfish.vcs.vcssvn.settag.switchfromto", (Object[])new Object[]{currentTag, tag}));
                }
                SVNUpdateClient updateClient = this.getSVNManager().getUpdateClient();
                long newRevision = updateClient.doSwitch(localRoot, newUrl, SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.INFINITY, true, false);
                if (log.isInfoEnabled()) {
                    log.info((Object)I18n.t((String)"isisfish.vcs.vcssvn.global.torevision", (Object[])new Object[]{newRevision}));
                }
                if (!(status = this.getLocalStatus(localRoot, true, SVNStatusType.STATUS_CONFLICTED)).isEmpty()) {
                    filesInConflict = new ArrayList<File>(status.keySet());
                    SVNWCClient wcClient = this.getSVNManager().getWCClient();
                    wcClient.doResolve(localRoot, SVNDepth.INFINITY, SVNConflictChoice.MERGED);
                }
            }
        }
        catch (SVNException eee) {
            throw new VCSException(I18n.t((String)"isisfish.vcs.vcssvn.setTag.error", (Object[])new Object[0]), eee);
        }
        return filesInConflict;
    }

    protected static enum ConnectionState {
        NOT_TESTED,
        OFF_LINE,
        ON_LINE;

    }
}

