/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util.matrix;

import fr.ifremer.isisfish.IsisFishDAOHelper;
import fr.ifremer.isisfish.entities.PopulationDAO;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationGroupDAO;
import fr.ifremer.isisfish.simulator.SimulationContext;
import fr.ifremer.isisfish.ui.input.InputContext;
import fr.ifremer.isisfish.ui.simulator.SimulatorContext;
import fr.ifremer.isisfish.util.converter.ConverterUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.SemanticMapper;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;

public class IsisMatrixSemanticMapper
extends SemanticMapper {
    private static Log log = LogFactory.getLog(IsisMatrixSemanticMapper.class);

    public Class getType(String typeName) {
        Class<Object> clazz;
        try {
            clazz = Class.forName(typeName);
        }
        catch (Exception eee) {
            try {
                clazz = Class.forName("fr.ifremer.isisfish.entities." + typeName);
            }
            catch (Exception eee1) {
                try {
                    clazz = Class.forName("fr.ifremer.isisfish.types." + typeName);
                }
                catch (Exception eee2) {
                    log.warn((Object)("Can't find class for name " + typeName), (Throwable)eee2);
                    clazz = String.class;
                }
            }
        }
        return clazz;
    }

    public Object getValue(Class type, String valueId) {
        Object value;
        try {
            TopiaContext context = SimulationContext.get().getDB();
            if (context == null && (context = InputContext.getDb()) == null) {
                context = SimulatorContext.getDb();
            }
            if (PopulationGroup.class.isAssignableFrom(type)) {
                int separatorIndex = valueId.indexOf(43);
                if (separatorIndex >= 0) {
                    String popName = valueId.substring(0, separatorIndex);
                    int groupId = Integer.parseInt(valueId.substring(separatorIndex + 1));
                    PopulationDAO populationDao = IsisFishDAOHelper.getPopulationDAO(context);
                    PopulationGroupDAO populationGroupDAO = IsisFishDAOHelper.getPopulationGroupDAO(context);
                    Object population = populationDao.findByName(popName);
                    value = populationGroupDAO.findByProperties("population", population, new Object[]{"id", groupId});
                } else {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)"PopulationGroup identifiant doesn't contains '+' separator");
                    }
                    value = valueId;
                }
            } else if (TopiaEntity.class.isAssignableFrom(type)) {
                Object dao = IsisFishDAOHelper.getDAO(context, type);
                value = dao.findByProperty("name", (Object)valueId);
            } else {
                value = ConverterUtil.getConverter(null).convert(valueId, type);
            }
        }
        catch (Exception ex) {
            log.warn((Object)("Can't get value for " + valueId), (Throwable)ex);
            value = valueId;
        }
        return value;
    }
}

