/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util.converter;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.beanutils.ConversionException;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.persistence.TopiaEntity;

public class CollectionConverter
implements Converter {
    private static final Log log = LogFactory.getLog(CollectionConverter.class);
    protected ConvertUtilsBean defaultConverter;

    public CollectionConverter(ConvertUtilsBean defaultConverter) {
        this.defaultConverter = defaultConverter;
    }

    public Object convert(Class type, Object value) {
        Collection result;
        if (value == null) {
            result = null;
        } else if (value instanceof Collection) {
            result = value;
        } else if (value instanceof String) {
            Stream<TopiaEntity> defaultStream = Stream.of(((String)((Object)value)).split("\\s*,\\s*")).map(s -> (TopiaEntity)this.defaultConverter.convert(s, TopiaEntity.class));
            result = type.isAssignableFrom(Set.class) ? defaultStream.collect(Collectors.toSet()) : defaultStream.collect(Collectors.toList());
        } else {
            throw new ConversionException("Can't convert '" + value + "' to " + type.getName());
        }
        return result;
    }

    public Object getCollectionAsString(Collection<?> coll) {
        String result = null;
        if (coll != null) {
            result = coll.stream().map(arg_0 -> ((ConvertUtilsBean)this.defaultConverter).convert(arg_0)).collect(Collectors.joining(","));
        }
        return result;
    }
}

