/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RUtil {
    private static final Log log = LogFactory.getLog(RUtil.class);
    public static final String R_TYPE_PROPERTY = "R.type";

    public static void initJri() {
        block9: {
            System.setProperty(R_TYPE_PROPERTY, "jni");
            if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_10)) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Skip updating java.library.path not working on Java " + SystemUtils.JAVA_SPECIFICATION_VERSION));
                }
                return;
            }
            try {
                ProcessBuilder pb = new ProcessBuilder("Rscript", "-e", "installed.packages()[which(installed.packages()[,1]=='rJava'),]['LibPath']");
                Process process = pb.start();
                int exitValue = process.waitFor();
                if (exitValue == 0) {
                    RUtil.parseRscriptOutput(process.getInputStream());
                } else {
                    InputStream err = process.getErrorStream();
                    if (log.isErrorEnabled()) {
                        log.error((Object)("Can't call Rscript : " + IOUtils.toString((InputStream)err, (Charset)StandardCharsets.UTF_8)));
                    }
                }
            }
            catch (IOException ex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Can't find R", (Throwable)ex);
                }
            }
            catch (InterruptedException ex) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)"Can't find R", (Throwable)ex);
            }
        }
    }

    protected static void parseRscriptOutput(InputStream is) throws IOException {
        List output = IOUtils.readLines((InputStream)is, (Charset)StandardCharsets.UTF_8);
        if (output.size() == 1) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Can't locate rJava package using Rscript (probably not installed)");
            }
        } else if (output.size() == 2) {
            String repository = ((String)output.get(1)).trim();
            repository = StringUtils.removeStart((String)repository, (String)"\"");
            repository = StringUtils.removeEnd((String)repository, (String)"\"");
            repository = repository.replace('/', File.separatorChar);
            String location = RUtil.getArchLibraryPath(repository);
            RUtil.setJavaLibraryPath(location);
        } else if (log.isErrorEnabled()) {
            log.error((Object)"Can't analyze Rscript output. was: ");
            for (String line : output) {
                log.error((Object)line);
            }
        }
    }

    protected static String getArchLibraryPath(String libraryRepository) {
        String archLibraryPath = libraryRepository + File.separator + "rJava" + File.separator + "jri";
        String arch = SystemUtils.OS_ARCH;
        if ("x86_64".equals(arch) || "amd64".equals(arch)) {
            String x64LibraryPath = archLibraryPath + File.separator + "x64";
            if (new File(x64LibraryPath).isDirectory()) {
                archLibraryPath = x64LibraryPath;
            }
        } else {
            String i386LibraryPath = archLibraryPath + File.separator + "i386";
            if (new File(i386LibraryPath).isDirectory()) {
                archLibraryPath = i386LibraryPath;
            }
        }
        return archLibraryPath;
    }

    protected static void setJavaLibraryPath(String newValue) {
        block3: {
            if (log.isInfoEnabled()) {
                log.info((Object)("Adding '" + newValue + "' to java.library.path"));
            }
            System.setProperty("java.library.path", newValue);
            try {
                Field sysPathsField = ClassLoader.class.getDeclaredField("sys_paths");
                sysPathsField.setAccessible(true);
                sysPathsField.set(null, null);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException ex) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Cant' reset ClassLoader#sys_paths value", (Throwable)ex);
            }
        }
    }
}

