/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.util;

import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.annotations.Args;
import fr.ifremer.isisfish.datastore.CodeSourceStorage;
import fr.ifremer.isisfish.datastore.JavaSourceStorage;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.jdt.internal.compiler.tool.EclipseCompiler;
import org.nuiton.i18n.I18n;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaContext;
import org.nuiton.util.FileUtil;
import org.nuiton.util.StringUtil;

public class CompileHelper {
    private static final Log log = LogFactory.getLog(CompileHelper.class);
    protected static Pattern patternGen1 = Pattern.compile("^([\\w\\.]+)<(.*)>$");

    public static List<File> searchSrcToCompile(File srcDir, File destDir) {
        ArrayList<File> result = new ArrayList<File>();
        for (File src : srcDir.listFiles()) {
            File dest = new File(FileUtil.basename((File)src, (String[])new String[]{".java"}), ".class");
            if (!src.getName().endsWith(".java") || !FileUtils.isFileNewer((File)src, (File)dest)) continue;
            result.add(src);
        }
        return result;
    }

    public static Class<?> loadClass(String fqn) {
        Class<?> result = null;
        try {
            ClassLoader cl = IsisFish.config.getScriptClassLoader();
            result = cl.loadClass(fqn);
        }
        catch (ClassNotFoundException eee) {
            log.info((Object)I18n.t((String)"isisfish.error.load.class", (Object[])new Object[]{fqn}), (Throwable)eee);
        }
        return result;
    }

    public static Object newInstance(String fqn) {
        Object result = null;
        try {
            Class<?> clazz = CompileHelper.loadClass(fqn);
            if (clazz != null) {
                result = clazz.newInstance();
            }
        }
        catch (Exception eee) {
            log.warn((Object)I18n.t((String)"isisfish.error.instanciate", (Object[])new Object[]{fqn}), (Throwable)eee);
        }
        return result;
    }

    public static int compile(JavaSourceStorage source, File destDir, boolean force, PrintWriter out) {
        File src = source.getFile();
        File dst = new File(destDir, source.getFQN().replace('.', File.separatorChar) + ".class");
        if (force || !dst.exists() || FileUtils.isFileNewer((File)src, (File)dst)) {
            return CompileHelper.compile(source.getRoot(), src, destDir, out);
        }
        return 0;
    }

    public static int compile(File rootSrc, File src, File dest, PrintWriter out) {
        int result = CompileHelper.compile(rootSrc, Collections.singletonList(src), dest, out);
        return result;
    }

    public static int compile(File rootSrc, Collection<File> src, File dest, PrintWriter out) {
        int result;
        block2: {
            result = -10000;
            try {
                ArrayList<File> classpath = new ArrayList<File>();
                classpath.add(rootSrc.getAbsoluteFile());
                classpath.addAll(Arrays.asList(CodeSourceStorage.Location.ALL.getDirectories()));
                result = CompileHelper.compile(classpath, src, dest, out);
            }
            catch (Exception eee) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"Compilation failed", (Throwable)eee);
            }
        }
        return result;
    }

    protected static int compile(List<File> classpath, Collection<File> src, File dest, PrintWriter out) {
        int result;
        block4: {
            dest.mkdirs();
            result = -1000;
            try {
                EclipseCompiler compiler = new EclipseCompiler();
                StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, StandardCharsets.UTF_8);
                fileManager.setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(dest));
                Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(src);
                ArrayList<String> args = new ArrayList<String>();
                args.add("-" + JavaVersion.JAVA_1_8);
                String classpathAsString = CompileHelper.getClassPathAsString(classpath);
                args.add("-classpath");
                args.add(classpathAsString);
                args.add("-g");
                args.add("-warn:deprecation");
                boolean b = compiler.getTask(out, fileManager, null, args, null, compilationUnits).call();
                int n = result = b ? 0 : -1;
                if (!b) {
                    StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                    System.out.println("stacktrace:");
                    for (StackTraceElement stackTraceElement : stackTrace) {
                        System.out.println(stackTraceElement);
                    }
                }
                fileManager.close();
            }
            catch (IOException eee) {
                if (!log.isWarnEnabled()) break block4;
                log.warn((Object)"Can't get system compiler or classpath info", (Throwable)eee);
            }
        }
        return result;
    }

    public static String getClassPathAsString(List<File> classpath) throws IOException {
        String[] systemClassPathes;
        String result = StringUtils.join(classpath.iterator(), (String)File.pathSeparator);
        Enumeration<URL> e = CompileHelper.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (e.hasMoreElements()) {
            String jarName;
            URL url = e.nextElement();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found manifest : " + url));
            }
            if (url == null || !url.getFile().startsWith("file:/") || result.contains(jarName = url.getPath().substring(5, url.getPath().indexOf("!")))) continue;
            result = result + File.pathSeparator + jarName;
        }
        String systemClassPath = System.getProperty("java.class.path");
        for (String path : systemClassPathes = systemClassPath.split(File.pathSeparator)) {
            String absolutePath = new File(path).getCanonicalPath();
            if (result.contains(absolutePath)) continue;
            result = result + File.pathSeparator + absolutePath;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CLASSPATH : " + result));
        }
        return result;
    }

    public static Iterable<File> getClassPathAsFiles(List<File> classpath) throws IOException {
        String[] systemClassPathes;
        HashSet<File> result = new HashSet<File>(classpath);
        Enumeration<URL> e = CompileHelper.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (e.hasMoreElements()) {
            URL url = e.nextElement();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Found manifest : " + url));
            }
            if (url == null || !url.getFile().startsWith("file:/")) continue;
            String jarName = url.getPath().substring(5, url.getPath().indexOf("!"));
            String path = Paths.get(jarName, new String[0]).toString();
            result.add(new File(path));
        }
        String systemClassPath = System.getProperty("java.class.path");
        for (String path : systemClassPathes = systemClassPath.split(File.pathSeparator)) {
            result.add(new File(path));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("CLASSPATH : " + result));
        }
        return result;
    }

    public static String extractDoc(String category, String name, Class<?> javaInterface) {
        int i;
        String content = "Equation : " + CompileHelper.createHREF(javaInterface.getName(), category) + " - " + name + "<br />";
        content = content + "<b>" + I18n.t((String)"isisfish.editor.parametersnameandtypes", (Object[])new Object[0]) + " :</b>";
        Method[] methods = javaInterface.getDeclaredMethods();
        Method interfaceMethod = methods[0];
        Args args = interfaceMethod.getAnnotation(Args.class);
        String[] names = args.value();
        String[] stringTypes = new String[names.length];
        Type[] types = interfaceMethod.getGenericParameterTypes();
        for (i = 0; i < types.length; ++i) {
            stringTypes[i] = types[i].getTypeName();
        }
        content = content + "<ul style='margin-top: 0'>";
        for (i = 0; i < names.length; ++i) {
            content = content + "<li>" + names[i] + " : " + CompileHelper.createHREF(stringTypes[i], new String[0]);
        }
        content = content + "</ul>";
        return content;
    }

    protected static String createHREF(String type, String ... texts) {
        String result;
        Matcher matcher;
        String text = type;
        if (texts.length > 0) {
            text = texts[0];
        }
        if ((matcher = patternGen1.matcher(type)).matches()) {
            String mainType = matcher.group(1);
            String generics = matcher.group(2);
            StringJoiner joiner = new StringJoiner(", ", StringEscapeUtils.escapeHtml4((String)"<"), StringEscapeUtils.escapeHtml4((String)">"));
            Stream.of(StringUtil.split((Character[])new Character[]{Character.valueOf('<')}, (Character[])new Character[]{Character.valueOf('>')}, (String)generics, (String)", ")).map(x$0 -> CompileHelper.createHREF(x$0, new String[0])).forEach(joiner::add);
            result = CompileHelper.createHREF(mainType, new String[0]) + joiner.toString();
        } else {
            result = StringEscapeUtils.escapeHtml4((String)text);
            String url = null;
            if (type.startsWith(IsisFish.class.getPackage().getName())) {
                url = IsisFish.config.getJavadocIsisURL();
            } else if (type.startsWith(MatrixND.class.getPackage().getName())) {
                url = IsisFish.config.getJavadocMatrixURL();
            } else if (type.startsWith(TopiaContext.class.getPackage().getName())) {
                url = IsisFish.config.getJavadocTopiaURL();
            } else if (StringUtils.startsWithAny((CharSequence)type, (CharSequence[])new CharSequence[]{"java.", "javax."})) {
                url = IsisFish.config.getJavadocJavaURL();
            }
            if (url != null) {
                String ref = url + type.replaceAll("\\.", "/") + ".html";
                String smallType = result.indexOf(46) > 0 ? StringUtils.substringAfterLast((String)result, (String)".") : result;
                result = "<a href='" + ref + "'>" + smallType + "</a>";
            }
        }
        return result;
    }
}

