/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.widget.editor;

import fr.ifremer.isisfish.datastore.RegionStorage;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.types.Month;
import fr.ifremer.isisfish.types.TimeStep;
import fr.ifremer.isisfish.ui.models.common.GenericComboModel;
import fr.ifremer.isisfish.ui.widget.checkboxcombo.CheckedComboBox;
import fr.ifremer.isisfish.ui.widget.checkboxcombo.CheckedComboUtil;
import fr.ifremer.isisfish.ui.widget.editor.FactorEditor;
import fr.ifremer.isisfish.ui.widget.editor.FactorEditorListener;
import fr.ifremer.isisfish.ui.widget.editor.MonthComponent;
import fr.ifremer.isisfish.ui.widget.editor.StepComponent;
import fr.ifremer.isisfish.util.converter.ConverterUtil;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.persistence.TopiaEntity;

public class ParameterTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 6860330126841984303L;
    private static final Log log = LogFactory.getLog(ParameterTableCellEditor.class);
    protected RegionStorage regionStorage = null;
    protected TopiaContext topiaContext = null;
    protected Component editor = null;
    protected Field field = null;
    protected FactorEditorListener factorActionListener;

    public void setRegionStorage(RegionStorage regionStorage) {
        this.regionStorage = regionStorage;
        if (regionStorage == null && log.isWarnEnabled()) {
            log.warn((Object)"setRegionStorage called with null value in parameters table cell editor");
        }
    }

    public void setTopiaContext(TopiaContext topiaContext) {
        this.topiaContext = topiaContext;
        if (topiaContext == null && log.isWarnEnabled()) {
            log.warn((Object)"setTopiaContext called with null value in parameters table cell editor");
        }
    }

    public void setFactorActionListener(FactorEditorListener factorActionListener) {
        this.factorActionListener = factorActionListener;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.field = this.getType(value, row, column);
        TypeClassMapping mapping = TypeClassMapping.getMapping(this.field);
        switch (mapping) {
            case TOPIA: {
                try {
                    if (this.topiaContext == null && this.regionStorage == null) {
                        return null;
                    }
                    TopiaContext context = this.topiaContext;
                    boolean closeContext = false;
                    if (context == null) {
                        context = this.regionStorage.getStorage().beginTransaction();
                        closeContext = true;
                    }
                    List list = context.findAll("from " + this.field.getType().getName(), new Object[0]);
                    JComboBox<Object> c = new JComboBox<Object>(list.toArray());
                    c.setSelectedItem(value);
                    this.editor = c;
                    if (!closeContext) break;
                    context.closeContext();
                }
                catch (Exception eee) {
                    if (!log.isWarnEnabled()) break;
                    log.warn((Object)"Can't get entity object for combobox", (Throwable)eee);
                }
                break;
            }
            case COLLECTION: {
                try {
                    if (this.topiaContext == null && this.regionStorage == null) {
                        return null;
                    }
                    ParameterizedType genericType = (ParameterizedType)this.field.getGenericType();
                    String typeName = genericType.getActualTypeArguments()[0].getTypeName();
                    if (typeName == null || !typeName.startsWith(FisheryRegion.class.getPackage().getName())) {
                        return null;
                    }
                    TopiaContext context = this.topiaContext;
                    boolean closeContext = false;
                    if (context == null) {
                        context = this.regionStorage.getStorage().beginTransaction();
                        closeContext = true;
                    }
                    List list = context.findAll("from " + typeName, new Object[0]);
                    List modelItems = CheckedComboUtil.getModelItems(list, (Collection)value);
                    CheckedComboBox c = new CheckedComboBox(new GenericComboModel(modelItems));
                    c.setSelectedItem(value);
                    this.editor = c;
                    if (!closeContext) break;
                    context.closeContext();
                }
                catch (Exception eee) {
                    if (!log.isWarnEnabled()) break;
                    log.warn((Object)"Can't get entity object for combobox", (Throwable)eee);
                }
                break;
            }
            case BOOLEAN: {
                ArrayList<Boolean> listB = new ArrayList<Boolean>();
                listB.add(Boolean.TRUE);
                listB.add(Boolean.FALSE);
                JComboBox<Object> c = new JComboBox<Object>(listB.toArray());
                listB.clear();
                c.setSelectedItem(value);
                this.editor = c;
                break;
            }
            case TIMESTEP: {
                TimeStep date = (TimeStep)value;
                if (date == null) {
                    date = new TimeStep(0);
                }
                int month = date.getMonth().getMonthNumber();
                int yea = date.getYear();
                this.editor = new StepComponent(month, yea);
                break;
            }
            case MONTH: {
                this.editor = MonthComponent.createMounthCombo(((Month)value).getMonthNumber());
                break;
            }
            case FACTOR: {
                this.editor = new FactorEditor(this, (Factor)value);
                if (this.factorActionListener == null) {
                    throw new RuntimeException("Missing factorActionListener call setFactorActionListener()");
                }
                this.factorActionListener.setFactorCallback((FactorEditorListener.FactorCallback)((Object)this.editor));
                ((JButton)this.editor).addActionListener(this.factorActionListener);
                break;
            }
            default: {
                this.editor = new JTextField(String.valueOf(value));
            }
        }
        if (this.editor != null) {
            if (this.editor instanceof CheckedComboBox) {
                this.editor.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        ParameterTableCellEditor.this.stopCellEditing();
                    }
                });
            } else if (this.editor instanceof JComboBox) {
                ((JComboBox)this.editor).addActionListener(this.getStopEditingListener());
            } else if (this.editor instanceof JTextField) {
                this.editor.addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusLost(FocusEvent e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Stop cell editing");
                        }
                        ParameterTableCellEditor.this.stopCellEditing();
                    }
                });
            } else if (this.editor instanceof StepComponent) {
                StepComponent date = (StepComponent)this.editor;
                if (date.getMounthCombo() != null) {
                    date.getMounthCombo().addActionListener(this.getStopEditingListener());
                }
                if (date.getYearCombo() != null) {
                    date.getYearCombo().addActionListener(this.getStopEditingListener());
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getCellEditorValue [" + this.field + "] [mapping:" + (Object)((Object)mapping) + "=" + this.editor));
        }
        return this.editor;
    }

    protected Field getType(Object value, int row, int column) {
        return null;
    }

    protected ActionListener getStopEditingListener() {
        return e -> this.stopCellEditing();
    }

    @Override
    public Object getCellEditorValue() {
        Object result = null;
        TopiaContext context = null;
        if (this.editor == null) {
            return "";
        }
        TypeClassMapping mapping = TypeClassMapping.getMapping(this.field);
        switch (mapping) {
            case TOPIA: 
            case BOOLEAN: {
                result = ((JComboBox)this.editor).getSelectedItem();
                break;
            }
            case COLLECTION: {
                GenericComboModel comboBoxModel = (GenericComboModel)((JComboBox)this.editor).getModel();
                List modelItems = comboBoxModel.getElementList();
                List selectedItem = CheckedComboUtil.getSelectedItem(modelItems);
                result = selectedItem;
                break;
            }
            case MONTH: {
                result = new Month(((MonthComponent)this.editor).getSelectedValue());
                break;
            }
            case TIMESTEP: {
                result = new TimeStep(((StepComponent)this.editor).getSelectedValue());
                break;
            }
            case FACTOR: {
                result = ((FactorEditor)this.editor).getFactor();
                break;
            }
            default: {
                if (this.editor instanceof JTextField) {
                    result = ((JTextField)this.editor).getText();
                    break;
                }
                if (!(this.editor instanceof JComboBox)) break;
                result = ((JComboBox)this.editor).getSelectedItem();
            }
        }
        if (result instanceof String && !String.class.equals(this.field.getType())) {
            ConvertUtilsBean cub = ConverterUtil.getConverter(context);
            result = cub.convert((String)result, this.field.getType());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("getCellEditorValue [" + this.field + "] [mapping:" + (Object)((Object)mapping) + "]= " + result));
        }
        return result;
    }

    private static enum TypeClassMapping {
        INT(Integer.TYPE, Integer.class),
        TOPIA(TopiaEntity.class),
        MONTH(Month.class),
        TIMESTEP(TimeStep.class),
        DOUBLE(Double.TYPE, Double.class),
        BOOLEAN(Boolean.TYPE, Boolean.class),
        FACTOR(Factor.class),
        FILE(File.class),
        STRING(String.class),
        COLLECTION(Collection.class, Set.class, List.class);

        private final Class<?>[] klazz;

        private TypeClassMapping(Class<?> ... klazz) {
            this.klazz = klazz;
        }

        protected static TypeClassMapping getMapping(Field field) {
            for (TypeClassMapping t : TypeClassMapping.values()) {
                for (Class<?> loopKlazz : t.klazz) {
                    if (!loopKlazz.isAssignableFrom(field.getType())) continue;
                    return t;
                }
            }
            throw new RuntimeException("could not found a TypeClassMapping for this class " + field);
        }
    }
}

