/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.isisfish.ui.input.zone;

import com.bbn.openmap.event.CoordMouseMode;
import com.bbn.openmap.event.SelectMouseMode;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.FisheryRegion;
import fr.ifremer.isisfish.map.OpenMapEvents;
import fr.ifremer.isisfish.ui.input.InputContentHandler;
import fr.ifremer.isisfish.ui.input.zone.ZoneBasicsUI;
import fr.ifremer.isisfish.ui.models.common.GenericListModel;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ZoneBasicsHandler
extends InputContentHandler<ZoneBasicsUI> {
    private static final Log log = LogFactory.getLog(ZoneBasicsHandler.class);

    public ZoneBasicsHandler(ZoneBasicsUI inputContentUI) {
        super(inputContentUI);
    }

    protected void afterInit() {
        new OpenMapEvents(((ZoneBasicsUI)this.inputContentUI).zoneMap, (CoordMouseMode)new SelectMouseMode(false), 2){

            @Override
            public boolean mouseClicked(MouseEvent e) {
                if (((ZoneBasicsUI)ZoneBasicsHandler.this.inputContentUI).getBean() != null) {
                    ((ZoneBasicsUI)ZoneBasicsHandler.this.inputContentUI).getBean().setCell(((ZoneBasicsUI)((ZoneBasicsHandler)ZoneBasicsHandler.this).inputContentUI).zoneMap.getSelectedCells());
                    ZoneBasicsHandler.this.setZoneCells();
                }
                return false;
            }
        };
        ((ZoneBasicsUI)this.inputContentUI).addPropertyChangeListener("bean", evt -> {
            if (evt.getNewValue() == null) {
                ((ZoneBasicsUI)this.inputContentUI).fieldZoneName.setText("");
                ((ZoneBasicsUI)this.inputContentUI).fieldZoneComment.setText("");
                ((ZoneBasicsUI)this.inputContentUI).zoneMap.setSelectedCells(new Cell[0]);
            }
            if (evt.getNewValue() != null) {
                // empty if block
            }
            this.setZoneCells();
            ((ZoneBasicsUI)this.inputContentUI).getZoneMap().setFisheryRegion(((ZoneBasicsUI)this.inputContentUI).getContextValue(FisheryRegion.class));
        });
    }

    protected void setZoneCells() {
        GenericListModel<Cell> zoneModel = new GenericListModel<Cell>();
        if (((ZoneBasicsUI)this.inputContentUI).getBean() != null) {
            List<Cell> cells = ((ZoneBasicsUI)this.inputContentUI).getFisheryRegion().getCell();
            zoneModel.setElementList(cells);
            ((ZoneBasicsUI)this.inputContentUI).zoneCells.setModel(zoneModel);
            int firstIndex = -1;
            if (((ZoneBasicsUI)this.inputContentUI).getBean().getCell() != null) {
                for (Cell selectedCell : ((ZoneBasicsUI)this.inputContentUI).getBean().getCell()) {
                    int index = cells.indexOf(selectedCell);
                    ((ZoneBasicsUI)this.inputContentUI).zoneCells.addSelectionInterval(index, index);
                    if (firstIndex != -1) continue;
                    firstIndex = index;
                }
            }
            if (firstIndex != -1) {
                ((ZoneBasicsUI)this.inputContentUI).zoneCells.ensureIndexIsVisible(firstIndex);
            }
        } else {
            ((ZoneBasicsUI)this.inputContentUI).zoneCells.setModel(zoneModel);
        }
    }

    public void zoneCellsChange(ListSelectionEvent event) {
        if (event.getValueIsAdjusting() && ((ZoneBasicsUI)this.inputContentUI).isActive().booleanValue()) {
            ArrayList<Cell> cells = new ArrayList<Cell>(((ZoneBasicsUI)this.inputContentUI).zoneCells.getSelectedValuesList());
            ((ZoneBasicsUI)this.inputContentUI).getBean().setCell(cells);
        }
    }
}

